

<?php $__env->startSection('site_title', formatTitle([__('Projects'), __('Developers'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 flex-fill">
        <div class="container h-100 py-3 my-3">

            <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                ['url' => route('home'), 'title' => __('Home')],
                ['url' => route('developers'), 'title' => __('Developers')],
                ['title' => __('Projects')]
            ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <h1 class="h2 mb-0 d-inline-block"><?php echo e(__('Projects')); ?></h1>

            <?php echo $__env->make('developers.notes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('List')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

                    <div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
                        <span class="badge bg-light text-success px-2 py-1 mr-3">GET</span>
                        <pre class="m-0 text-light"><?php echo e(route('api.projects.index')); ?></pre>
                    </div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
                    <pre class="bg-dark text-light p-3 mb-0 rounded text-left" dir="ltr">
curl --location --request GET '<?php echo e(route('api.projects.index')); ?>' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>

                    <?php echo $__env->make('developers.projects.list', ['type' => 0], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Delete')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

                    <div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
                        <span class="badge bg-light text-danger px-2 py-1 mr-3">DELETE</span>
                        <pre class="m-0 text-light"><?php echo str_replace(':project', '<span class="text-success">{project}</span>', route('api.projects.destroy', ['project' => ':project'])); ?></pre>
                    </div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
                    <pre class="bg-dark text-light p-3 mb-0 rounded text-left" dir="ltr">
curl --location --request DELETE '<?php echo str_replace(':project', '<span class="text-success">{project}</span>', route('api.projects.destroy', ['project' => ':project'])); ?>' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/developers/projects/index.blade.php ENDPATH**/ ?>