<div class="text-center mb-3 mt-5 pb-3">
    <div class="btn-group btn-group-toggle" data-toggle="buttons">
        <label class="btn btn-outline-dark active" id="plan-month">
            <input type="radio" name="options" autocomplete="off" checked><?php echo e(__('Monthly')); ?>

        </label>
        <label class="btn btn-outline-dark" id="plan-year">
            <input type="radio" name="options" autocomplete="off"><?php echo e(__('Yearly')); ?>

        </label>
    </div>
</div>

<div class="row flex-column-reverse flex-md-row justify-content-center m-n2 m-md-n3">
    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12 col-md-6 col-xl-4 p-2 p-md-3">
            <div class="card border-0 shadow-sm rounded h-100 overflow-hidden plan">
                <div class="card-body p-4 d-flex flex-column">
                    <div class="mb-3">
                        <div class="badge badge-pill badge-primary text-uppercase px-2 py-1"><?php echo e($plan->name); ?></div>
                    </div>

                    <div class="mb-4">
                        <?php if(!$plan->isDefault()): ?>
                            <div class="plan-preload plan-month d-none d-block">
                                <div>
                                    <span class="h1 mb-0 font-weight-bold">
                                        <?php echo e(formatMoney($plan->amount_month, $plan->currency)); ?>

                                    </span>
                                    <span class="h5 font-weight-bold text-muted">
                                        <?php echo e($plan->currency); ?>

                                    </span>
                                </div>
                                <span class="text-muted text-lowercase"><?php echo e(__('Month')); ?></span>
                            </div>

                            <div class="plan-year d-none">
                                <div>
                                    <span class="h1 mb-0 font-weight-bold">
                                        <?php echo e(formatMoney($plan->amount_year, $plan->currency)); ?>

                                    </span>
                                    <span class="h5 font-weight-bold text-muted">
                                        <?php echo e($plan->currency); ?>

                                    </span>
                                </div>

                                <span class="text-muted text-lowercase"><?php echo e(__('Year')); ?></span>

                                <?php if(($plan->amount_month * 12) > $plan->amount_year): ?>
                                    <span class="badge badge-success">
                                        <?php echo e(__(':value% off', ['value' => number_format(((($plan->amount_month*12) - $plan->amount_year)/($plan->amount_month * 12) * 100), 0)])); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="plan-preload plan-month d-none d-block">
                                <div class="">
                                    <span class="h1 mb-0 font-weight-bold text-uppercase">
                                        <?php echo e(__('Free')); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="plan-year d-none">
                                <div class="">
                                    <span class="h1 mb-0 font-weight-bold text-uppercase">
                                        <?php echo e(__('Free')); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="plan-month d-none d-block">
                                <span class="text-muted text-lowercase"><?php echo e(__('Month')); ?></span>
                            </div>

                            <div class="plan-year d-none">
                                <span class="text-muted text-lowercase"><?php echo e(__('Year')); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="row m-n2">
                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->reports != 0): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php if($plan->features->reports < 0): ?>
                                    <?php echo e(__('Unlimited reports')); ?>

                                <?php else: ?>
                                    <?php echo e(__(($plan->features->reports == 1 ? ':number report' : ':number reports'), ['number' => number_format($plan->features->reports, 0, __('.'), __(','))])); ?> <span class="text-muted">/ <?php echo e(mb_strtolower(__('Month'))); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->branded_reports): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->branded_reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('Branded reports')); ?>

                            </div>

                            <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Customizable reports when printing or saving as PDF.')); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->white_label_reports): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->white_label_reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('White-label reports')); ?>

                            </div>

                            <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('White-label reports when printing or saving as PDF.')); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->research_tools): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->research_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('Research tools')); ?>

                            </div>

                            <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'research' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->developer_tools): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->developer_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('Developer tools')); ?>

                            </div>

                            <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'developer' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->content_tools): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->content_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('Content tools')); ?>

                            </div>

                            <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'content' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->data_export): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->data_export == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('Data export')); ?>

                            </div>
                        </div>

                        <div class="col-12 p-2 d-flex align-items-center">
                            <?php if($plan->features->api): ?>
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <div class="<?php echo e(($plan->features->api == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                                <?php echo e(__('API')); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer border-0 pt-0 pr-4 pb-4 pl-4 d-flex">
                    <div class="z-1 w-100">
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(!$plan->isDefault()): ?>
                                <?php if(Auth::user()->plan->id == $plan->id): ?>
                                    <div class="btn btn-primary btn-block text-uppercase py-2 disabled"><?php echo e(__('Active')); ?></div>
                                <?php else: ?>
                                    <div class="plan-no-animation plan-month d-none d-block">
                                        <a href="<?php echo e(route('checkout.index', ['id' => $plan->id, 'interval' => 'month'])); ?>" class="btn btn-primary btn-block text-uppercase py-2">
                                            <?php if($plan->trial_days > 0 && ! Auth::user()->plan_trial_ends_at): ?>
                                                <?php echo e(__('Free trial')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Subscribe')); ?>

                                            <?php endif; ?>
                                        </a>
                                    </div>
                                    <div class="plan-no-animation plan-year d-none">
                                        <a href="<?php echo e(route('checkout.index', ['id' => $plan->id, 'interval' => 'year'])); ?>" class="btn btn-primary btn-block text-uppercase py-2">
                                            <?php if($plan->trial_days > 0 && ! Auth::user()->plan_trial_ends_at): ?>
                                                <?php echo e(__('Free trial')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Subscribe')); ?>

                                            <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="btn btn-primary btn-block text-uppercase py-2 disabled"><?php echo e(__('Free')); ?></div>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if(config('settings.registration')): ?>
                                <div class="plan-no-animation plan-month d-none d-block">
                                    <a href="<?php echo e(route('register', ['plan' => $plan->id, 'interval' => 'month'])); ?>" class="btn btn-primary btn-block text-uppercase py-2"><?php echo e(__('Register')); ?></a>
                                </div>
                                <div class="plan-no-animation plan-year d-none">
                                    <a href="<?php echo e(route('register', ['plan' => $plan->id, 'interval' => 'year'])); ?>" class="btn btn-primary btn-block text-uppercase py-2"><?php echo e(__('Register')); ?></a>
                                </div>
                            <?php else: ?>
                                <div class="plan-no-animation plan-month d-none d-block">
                                    <a href="<?php echo e(route('login', ['plan' => $plan->id, 'interval' => 'month'])); ?>" class="btn btn-primary btn-block text-uppercase py-2"><?php echo e(__('Login')); ?></a>
                                </div>
                                <div class="plan-no-animation plan-year d-none">
                                    <a href="<?php echo e(route('login', ['plan' => $plan->id, 'interval' => 'year'])); ?>" class="btn btn-primary btn-block text-uppercase py-2"><?php echo e(__('Login')); ?></a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/shared/pricing.blade.php ENDPATH**/ ?>