<?php $__env->startSection('site_title', formatTitle([__('Website status checker'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Website status checker')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Website status checker')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.website_status_checker')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">

                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.website_status_checker')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="list-group list-group-flush my-n3">
                <div class="list-group-item px-0">
                    <div class="row align-items-center">
                        <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('URL')); ?></div>
                        <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e($domain); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                            <span dir="ltr"><?php echo e($domain); ?></span>
                        </div>
                    </div>
                </div>

                <div class="list-group-item px-0">
                    <div class="row align-items-center">
                        <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Status')); ?></div>
                        <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                            <?php if($result): ?>
                                <div class="bg-success width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                <div class="text-truncate"><?php echo e(__('Online')); ?></div>
                            <?php else: ?>
                                <div class="bg-danger width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                <div class="text-truncate"><?php echo e(__('Offline')); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="list-group-item px-0">
                    <div class="row align-items-center">
                        <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Code')); ?></div>
                        <div class="col-12 col-lg-8 text-truncate d-flex align-items-center"><?php echo e($result->getStatusCode()); ?></div>
                    </div>
                </div>

                <div class="list-group-item px-0">
                    <div class="row align-items-center">
                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Load time')); ?></div>
                        <div class="col-12 col-lg-8 text-break"><?php echo e(__(':value seconds', ['value' => number_format($stats['total_time'] ?? 0, 2, __('.'), __(','))])); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/website-status-checker.blade.php ENDPATH**/ ?>