

<?php $__env->startSection('site_title', formatTitle([__('Pricing'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="flex-fill">
        <div class="bg-base-1">
            <div class="container py-6">
                <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="text-center">
                    <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Pricing')); ?></h1>
                    <div class="m-auto">
                        <p class="text-muted font-weight-normal font-size-lg"><?php echo e(__('Simple pricing plans for everyone and every budget.')); ?></p>
                    </div>
                </div>

                <?php echo $__env->make('shared.pricing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <div class="bg-base-0">
            <div class="container py-6">
                <div class="text-center">
                    <h3 class="d-inline-block mb-0"><?php echo e(__('Frequently asked questions')); ?></h3>
                </div>

                <div class="row">
                    <div class="col-12 col-md-6 mt-5 h-100">
                        <div class="h5 font-weight-medium"><?php echo e(__('What payment methods do you accept?')); ?></div>
                        <div class="text-muted"><?php echo e(__('We support the following payment methods: :list.', ['list' => implode(', ', array_unique(array_map(function ($payment) { return __($payment['type']); }, paymentProcessors())))])); ?></div>
                    </div>

                    <div class="col-12 col-md-6 mt-5 h-100">
                        <div class="h5 font-weight-medium"><?php echo e(__('Can I change plans?')); ?></div>
                        <div class="text-muted"><?php echo e(__('Yes, you can change your plan at any time.')); ?> <?php echo e(__('Upon switching plans, your current subscription will be cancelled immediately.')); ?></div>
                    </div>

                    <div class="col-12 col-md-6 mt-5 h-100">
                        <div class="h5 font-weight-medium"><?php echo e(__('Can I cancel my subscription?')); ?></div>
                        <div class="text-muted"><?php echo e(__('Yes, you can cancel your subscription at any time.')); ?> <?php echo e(__('You\'ll continue to have access to the features you\'ve paid for until the end of your billing cycle.')); ?></div>
                    </div>

                    <div class="col-12 col-md-6 mt-5 h-100">
                        <div class="h5 font-weight-medium"><?php echo e(__('What happens when my subscription expires?')); ?></div>
                        <div class="text-muted"><?php echo e(__('Once your subscription expires, you\'ll lose access to all the subscription features.')); ?></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bg-base-1">
            <div class="container py-6 text-center">
                <div><h3 class="d-inline-block mb-5"><?php echo e(__('Still have questions?')); ?></h3></div>

                <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary btn-lg font-size-lg"><?php echo e(__('Contact us')); ?></a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/pricing/index.blade.php ENDPATH**/ ?>