<?php $__env->startSection('site_title', formatTitle([__('Keyword research'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-truncate"><?php echo e(__('Keyword research')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Keyword research')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.keyword_research')); ?>" method="post" enctype="multipart/form-data" id="keywords-research-form"  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-keywords"><?php echo e(__('Keywords')); ?></label>
                <textarea name="keywords" id="i-keywords" class="form-control<?php echo e($errors->has('keywords') ? ' is-invalid' : ''); ?>" rows="3"><?php echo e($keywords ?? (old('keywords') ?? '')); ?></textarea>
                <?php if($errors->has('keywords')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('keywords')); ?></strong>
                    </span>
                <?php endif; ?>
                <small class="form-text text-muted"><?php echo e(__('One per line.')); ?></small>
            </div>

            <div class="form-group">
                <label for="i-country"><?php echo e(__('Country')); ?></label>
                <select name="country" id="i-country" class="custom-select<?php echo e($errors->has('country') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = ['' => __('All'), 'au' => 'Australia', 'ca' => 'Canada', 'in' => 'India', 'nz' => 'New Zealand', 'za' => 'South Africa', 'uk' => 'United Kingdom', 'us' => 'United States']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((isset($country) && $key == $country) || (old('country') !== null && $key == old('country')) || (empty($key) && old('country'))): ?> selected <?php endif; ?>><?php echo e(__($value)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('country')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('country')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-currency"><?php echo e(__('Currency')); ?></label>
                <select name="currency" id="i-currency" class="custom-select<?php echo e($errors->has('currency') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = ['USD', 'EUR', 'GBP', 'AED', 'ALL', 'ANG', 'ARS', 'AUD', 'AWG', 'BBD', 'BDT', 'BGN', 'BIF', 'BMD', 'BND', 'BOB', 'BRL', 'BSD', 'BWP', 'BZD', 'CAD', 'CHF', 'CLP', 'CNY', 'COP', 'CRC', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ETB', 'FJD', 'FKP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HUF', 'IDR', 'ILS', 'INR', 'ISK', 'JPY', 'KES', 'KGS', 'KHR', 'KMF', 'KRW', 'KYD', 'KZT', 'LKR', 'MAD', 'MDL', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MYR', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'QAR', 'RON', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'STD', 'SVC', 'SZL', 'THB', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UGX', 'UYU', 'UZS', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((isset($currency) && $key == $currency) || (old('currency') !== null && $key == old('currency')) || (empty($key) && old('currency'))): ?> selected <?php endif; ?>><?php echo e($key); ?>

                            - <?php echo e(config('currencies.all')[$key]); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('currency')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('currency')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <?php if(config('settings.captcha_keyword_research')): ?>
                        <?php echo NoCaptcha::displaySubmit('keywords-research-form', __('Search'), ['data-theme' => (config('settings.dark_mode') == 1 ? 'dark' : 'light'), 'data-size' => 'invisible', 'class' => 'btn ' . ($errors->has('g-recaptcha-response') ? 'btn-danger' : 'btn-primary')]); ?>


                        <?php echo NoCaptcha::renderJs(__('lang_code')); ?>

                    <?php else: ?>
                        <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Analyze')); ?></button>
                    <?php endif; ?>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.keyword_research')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>

            <?php if($errors->has('g-recaptcha-response')): ?>
                <span class="invalid-feedback d-block" role="alert">
                    <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                </span>
            <?php endif; ?>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Results')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($results['data'])): ?>
                <?php echo e(__('No results found.')); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0 text-muted">
                        <div class="row align-items-center">
                            <div class="col">
                                <div class="row">
                                    <div class="col-12 col-lg-3 text-truncate">
                                        <?php echo e(__('Keyword')); ?>

                                    </div>

                                    <div class="col-12 col-lg-3 text-truncate">
                                        <?php echo e(__('Search volume')); ?>

                                    </div>

                                    <div class="col-12 col-lg-3 text-truncate">
                                        <?php echo e(__('Cost per click')); ?>

                                    </div>

                                    <div class="col-12 col-lg-3 text-truncate">
                                        <?php echo e(__('Competition')); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <div class="invisible btn btn-sm btn-outline-primary"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $results['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="list-group-item px-0">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-12 col-lg-3 text-truncate">
                                            <?php echo e($keyword['keyword']); ?>

                                        </div>

                                        <div class="col-12 col-lg-3 text-truncate">
                                            <?php echo e(number_format($keyword['vol'], 0, __('.'), __(','))); ?>

                                        </div>

                                        <div class="col-12 col-lg-3 text-truncate">
                                            <?php echo e(formatMoney($keyword['cpc']['value'], $keyword['cpc']['currency'])); ?>

                                            <span class="text-muted"><?php echo e(mb_strtoupper($currency)); ?></span>
                                        </div>

                                        <div class="col-12 col-lg-3 text-truncate">
                                            <?php if($keyword['competition'] >= 0.66): ?>
                                                <span class="text-danger" data-tooltip="true" title="<?php echo e(__('High competition')); ?>"><?php echo e(($keyword['competition'] * 100)); ?>%</span>
                                            <?php elseif($keyword['competition'] >= 0.33): ?>
                                                <span class="text-warning" data-tooltip="true" title="<?php echo e(__('Medium competition')); ?>"><?php echo e(($keyword['competition'] * 100)); ?>%</span>
                                            <?php else: ?>
                                                <span class="text-success" data-tooltip="true" title="<?php echo e(__('Low competition')); ?>"><?php echo e(($keyword['competition'] * 100)); ?>%</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="btn btn-sm btn-outline-primary" data-tooltip-copy="true" data-clipboard-copy="<?php echo e($keyword['keyword']); ?>" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>"><?php echo e(__('Copy')); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/keyword-research.blade.php ENDPATH**/ ?>