

<?php $__env->startSection('site_title', formatTitle([__('Contact'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 d-flex align-items-center flex-fill">
        <div class="container h-100 py-6">

            <div class="text-center d-block d-lg-none">
                <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Contact')); ?></h1>
                <div class="m-auto">
                    <p class="text-muted font-weight-normal font-size-lg mb-0"><?php echo e(__('Get in touch with us.')); ?></p>
                </div>
            </div>

            <div class="row h-100 justify-content-center align-items-center mt-5 mt-lg-0">
                <div class="col-12">
                    <div class="card border-0 shadow-sm overflow-hidden">
                        <div class="row no-gutters">
                            <div class="col-12 col-lg-5">
                                <div class="card-body p-lg-5">
                                    <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <form method="POST" action="<?php echo e(route('contact')); ?>" id="contact-form">
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group">
                                            <label for="i-email"><?php echo e(__('Email address')); ?></label>
                                            <input id="i-email" type="text" dir="ltr" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>" autofocus>
                                            <?php if($errors->has('email')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="i-subject"><?php echo e(__('Subject')); ?></label>
                                            <input id="i-subject" type="text" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="subject" value="<?php echo e(old('subject')); ?>" autofocus>
                                            <?php if($errors->has('subject')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('subject')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="i-message"><?php echo e(__('Message')); ?></label>
                                            <textarea name="message" id="i-message" class="form-control<?php echo e($errors->has('message') ? ' is-invalid' : ''); ?>"><?php echo e(old('message')); ?></textarea>
                                            <?php if($errors->has('message')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('message')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <?php if(config('settings.captcha_contact')): ?>
                                            <?php echo NoCaptcha::displaySubmit('contact-form', __('Send'), ['data-theme' => (config('settings.dark_mode') == 1 ? 'dark' : 'light'), 'data-size' => 'invisible', 'class' => 'btn btn-block btn-primary']); ?>


                                            <?php echo NoCaptcha::renderJs(__('lang_code')); ?>

                                        <?php else: ?>
                                            <button type="submit" class="btn btn-block btn-primary">
                                                <?php echo e(__('Send')); ?>

                                            </button>
                                        <?php endif; ?>

                                        <?php if($errors->has('g-recaptcha-response')): ?>
                                            <span class="invalid-feedback d-block" role="alert">
                                                <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </form>
                                </div>
                            </div>
                            <div class="col-12 col-lg-7 bg-dark d-none d-lg-flex flex-fill background-size-cover background-position-center" style="background-image: url(<?php echo e(asset('images/contact.svg')); ?>)">
                                <div class="card-body p-lg-5 d-flex flex-column flex-fill position-absolute top-0 right-0 bottom-0 left-0">
                                    <div class="d-flex align-items-center d-flex flex-fill">
                                        <div class="text-light <?php echo e((__('lang_dir') == 'rtl' ? 'mr-5' : 'ml-5')); ?>">
                                            <div class="h2 font-weight-bold">
                                                <?php echo e(__('Contact')); ?>

                                            </div>
                                            <div class="font-size-lg font-weight-medium">
                                                <?php echo e(__('Get in touch with us.')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/contact/index.blade.php ENDPATH**/ ?>