<?php $__env->startSection('site_title', formatTitle([__('UTM builder'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('UTM builder')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('UTM builder')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.utm_builder')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-url"><?php echo e(__('URL')); ?></label>
                <input type="text" dir="ltr" name="url" id="i-url" class="form-control<?php echo e($errors->has('url') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('url') ?? ($url ?? null)); ?>">
                <?php if($errors->has('url')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('url')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-source"><?php echo e(__('Source')); ?></label>

                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><code class="code">utm_source</code></span>
                    </div>
                    <input type="text" name="source" id="i-source" class="form-control<?php echo e($errors->has('source') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('source') ?? ($source ?? null)); ?>">
                    <?php if($errors->has('source')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('source')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <label for="i-medium"><?php echo e(__('Medium')); ?></label>

                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><code class="code">utm_medium</code></span>
                    </div>
                    <input type="text" name="medium" id="i-medium" class="form-control<?php echo e($errors->has('medium') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('medium') ?? ($medium ?? null)); ?>">
                    <?php if($errors->has('medium')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('medium')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <label for="i-campaign"><?php echo e(__('Campaign')); ?></label>

                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><code class="code">utm_campaign</code></span>
                    </div>
                    <input type="text" name="campaign" id="i-campaign" class="form-control<?php echo e($errors->has('campaign') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('campaign') ?? ($campaign ?? null)); ?>">
                    <?php if($errors->has('campaign')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('campaign')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <label for="i-term"><?php echo e(__('Term')); ?></label>

                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><code class="code">utm_term</code></span>
                    </div>
                    <input type="text" name="term" id="i-term" class="form-control<?php echo e($errors->has('term') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('term') ?? ($term ?? null)); ?>">
                    <?php if($errors->has('term')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('term')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <label for="i-content"><?php echo e(__('Content')); ?></label>

                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><code class="code">utm_content</code></span>
                    </div>
                    <input type="text" name="content" id="i-content" class="form-control<?php echo e($errors->has('content') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('content') ?? ($content ?? null)); ?>">
                    <?php if($errors->has('content')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('content')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Generate')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.utm_builder')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body mb-n3">
            <div class="form-group">
                <label for="i-result-content"><?php echo e(__('Content')); ?></label>

                <div class="position-relative">
                    <textarea name="result-content" id="i-result-content" class="form-control" onclick="this.select();" readonly><?php echo e($result); ?></textarea>

                    <div class="position-absolute top-0 right-0">
                        <div class="btn btn-sm btn-primary m-2" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-result-content"><?php echo e(__('Copy')); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/utm-builder.blade.php ENDPATH**/ ?>