<?php if(isset($report['results'][$name])): ?>
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                <?php echo $__env->make('reports.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate font-weight-medium"><?php echo e(__('In-page links')); ?></div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            <?php if($report['results'][$name]['passed']): ?>
                                <div>
                                    <?php echo e(__('The number of links on the webpage is okay.')); ?>

                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $report['results'][$name]['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e((!$loop->first) ? 'mt-3' : ''); ?>">
                                        <?php if($error == 'too_many'): ?>
                                            <?php echo e(__('The webpage contains more than :value links.', ['value' => number_format($details['max'], 0, __('.'), __(','))])); ?>

                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <?php if($report['results'][$name]['value']): ?>
                                <div class="list-group small mt-2">
                                    <?php $__currentLoopData = $report['results'][$name]['value']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item p-0">
                                            <a href="#collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>" class="d-flex text-secondary justify-content-between align-items-center text-decoration-none px-3 py-2" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>}">
                                                <div class="font-weight-medium"><?php echo e(__($key)); ?></div>
                                                <span class="badge badge-secondary badge-pill"><?php echo e(number_format(count($value), 0, __('.'), __(','))); ?></span>
                                            </a>

                                            <div class="px-3 collapse" id="collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>">
                                                <div class="pb-2">
                                                    <ol class="mb-0">
                                                        <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="py-1 text-break"><a href="<?php echo e($link['url']); ?>" rel="nofollow" target="_blank"><?php echo e($link['text'] ?: $link['url']); ?></a></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ol>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse<?php echo e($name); ?>" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse<?php echo e($name); ?>" data-tooltip="true" title="<?php echo e(__('More')); ?>">
                        <?php echo $__env->make('icons.info', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse<?php echo e(Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : ''); ?>" id="collapse<?php echo e($name); ?>">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                <?php echo e(__('The in-page links should be kept at a minimum, to avoid issues with search engines not being able to crawl additional links from the webpage.')); ?>

            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/in-page-links.blade.php ENDPATH**/ ?>