

<?php $__env->startSection('site_title', formatTitle([__('Dashboard'), config('settings.title')])); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 flex-fill">
    <div class="bg-base-0">
        <div class="container py-5">
            <?php if(config('settings.ad_dashboard_top')): ?>
                <div class="d-print-none mb-3"><?php echo config('settings.ad_dashboard_top'); ?></div>
            <?php endif; ?>

            <div class="d-flex">
                <div class="row no-gutters w-100">
                    <div class="d-flex col-12 col-md">
                        <div class="flex-shrink-1">
                            <a href="<?php echo e(route('account')); ?>" class="d-block"><img src="<?php echo e(gravatar(Auth::user()->email, 128)); ?>" class="rounded-circle width-16 height-16"></a>
                        </div>
                        <div class="flex-grow-1 d-flex align-items-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3' : 'ml-3')); ?>">
                            <div>
                                <h4 class="font-weight-medium mb-0"><?php echo e(Auth::user()->name); ?></h4>

                                <div class="d-flex flex-wrap">
                                    <?php if(paymentProcessors()): ?>
                                        <div class="d-inline-block mt-2 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-4' : 'mr-4')); ?>">
                                            <div class="d-flex">
                                                <div class="d-inline-flex align-items-center">
                                                    <?php echo $__env->make('icons.package', ['class' => 'text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>

                                                <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>">
                                                    <a href="<?php echo e(route('account.plan')); ?>" class="text-dark text-decoration-none"><?php echo e(Auth::user()->plan->name); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="d-inline-block mt-2 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-4' : 'mr-4')); ?>">
                                            <div class="d-flex">
                                                <div class="d-inline-flex align-items-center">
                                                    <?php echo $__env->make('icons.email', ['class' => 'text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>

                                                <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>">
                                                    <?php echo e(Auth::user()->email); ?>

                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if(paymentProcessors()): ?>
                        <?php if(Auth::user()->planIsDefault()): ?>
                            <div class="col-12 col-md-auto d-flex flex-row-reverse align-items-center">
                                <a href="<?php echo e(route('pricing')); ?>" class="btn btn-outline-primary btn-block d-flex justify-content-center align-items-center mt-3 mt-md-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-md-3' : 'mr-md-3')); ?>"><?php echo $__env->make('icons.unarchive', ['class' => 'width-4 height-4 fill-current '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php echo e(__('Upgrade')); ?></a>
                            </div>
                        <?php else: ?>
                            <div class="col-12 col-md-auto d-flex flex-row-reverse align-items-center">
                                <a href="<?php echo e(route('pricing')); ?>" class="btn btn-outline-primary btn-block d-flex justify-content-center align-items-center mt-3 mt-md-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-md-3' : 'mr-md-3')); ?>"><?php echo $__env->make('icons.package', ['class' => 'width-4 height-4 fill-current '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php echo e(__('Plans')); ?></a>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div class="col-12 col-md-auto d-flex flex-row-reverse align-items-center">
                        <a href="<?php echo e(route('reports')); ?>" class="btn btn-primary btn-block d-flex justify-content-center align-items-center mt-3 mt-md-0"><?php echo $__env->make('icons.add', ['class' => 'width-4 height-4 fill-current '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php echo e(__('New report')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-base-1">
        <div class="container py-3 my-3">
            <div class="row">
                <div class="col-12 col-lg">
                    <h4 class="mb-0"><?php echo e(__('Overview')); ?></h4>
                </div>
            </div>

            <div class="card border-0 rounded-top shadow-sm my-3 overflow-hidden mb-5">
                <div class="px-3">
                    <div class="row">
                        <!-- Title -->
                        <div class="col-12 col-lg-auto d-none d-lg-flex align-items-center border-bottom border-bottom-lg-0 <?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?>">
                            <div class="px-2 py-4 d-flex">
                                <div class="d-flex position-relative text-primary width-10 height-10 align-items-center justify-content-center flex-shrink-0">
                                    <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-xl"></div>
                                    <?php echo $__env->make('icons.list-alt', ['class' => 'fill-current width-5 height-5'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-lg">
                            <div class="row h-100">
                                <!-- Bad -->
                                <div class="col-12 col-lg border-bottom border-bottom-lg-0 text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?>">
                                    <div class="px-1 py-4">
                                        <div class="d-flex align-items-center pb-1">
                                            <?php echo $__env->make('icons.triangle', ['class' => 'fill-current width-4 height-4 flex-shrink-0 text-danger'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                            <div class="flex-grow-1 mx-2 d-flex text-truncate">
                                                <a href="<?php echo e(route('reports', ['project' => request()->input('project'), 'result' => 'bad', 'sort_by' => 'result', 'sort' => 'asc'])); ?>" class="text-secondary font-weight-medium d-flex align-items-center text-truncate">
                                                    <span class="d-inline-block text-truncate"><?php echo e(__(($badReportsCount == 1 ? ':value bad report' : ':value bad reports'), ['value' => number_format($badReportsCount, 0, __('.'), __(','))])); ?></span>

                                                    <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current flex-shrink-0 '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </a>
                                            </div>

                                            <div class="d-flex align-items-center text-muted mb-0 text-truncate flex-shrink-0">
                                                <?php echo e(number_format($badReportsCount ? (($badReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0, 1, __('.'), __(','))); ?>%
                                            </div>
                                        </div>

                                        <div class="progress height-1.25 w-100 mt-2">
                                            <div class="progress-bar bg-danger rounded" role="progressbar" style="width: <?php echo e(number_format($badReportsCount ? (($badReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>%" aria-valuenow="<?php echo e(number_format($badReportsCount ? (($badReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>" aria-valuemin="0" aria-valuemax="<?php echo e(($goodReportsCount + $decentReportsCount + $badReportsCount)); ?>"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Decent -->
                                <div class="col-12 col-lg border-bottom border-bottom-lg-0 text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?>">
                                    <div class="px-1 py-4">
                                        <div class="d-flex align-items-center pb-1">
                                            <?php echo $__env->make('icons.square', ['class' => 'fill-current width-4 height-4 flex-shrink-0 text-warning'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                            <div class="flex-grow-1 mx-2 d-flex text-truncate">
                                                <a href="<?php echo e(route('reports', ['project' => request()->input('project'), 'result' => 'decent', 'sort_by' => 'result', 'sort' => 'asc'])); ?>" class="text-secondary font-weight-medium d-flex align-items-center text-truncate">
                                                    <span class="d-inline-block text-truncate"><?php echo e(__(($decentReportsCount == 1 ? ':value decent report' : ':value decent reports'), ['value' => number_format($decentReportsCount, 0, __('.'), __(','))])); ?></span>

                                                    <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current flex-shrink-0 '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </a>
                                            </div>

                                            <div class="d-flex align-items-center text-muted mb-0 text-truncate flex-shrink-0">
                                                <?php echo e(number_format($decentReportsCount ? (($decentReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0, 1, __('.'), __(','))); ?>%
                                            </div>
                                        </div>

                                        <div class="progress height-1.25 w-100 mt-2">
                                            <div class="progress-bar bg-warning rounded" role="progressbar" style="width: <?php echo e(number_format($decentReportsCount ? (($decentReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>%" aria-valuenow="<?php echo e(number_format($decentReportsCount ? (($decentReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>" aria-valuemin="0" aria-valuemax="<?php echo e(($goodReportsCount + $decentReportsCount + $badReportsCount)); ?>"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Good -->
                                <div class="col-12 col-lg text-truncate">
                                    <div class="px-1 py-4">
                                        <div class="d-flex align-items-center pb-1">
                                            <?php echo $__env->make('icons.circle', ['class' => 'fill-current width-4 height-4 flex-shrink-0 text-success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                            <div class="flex-grow-1 mx-2 d-flex text-truncate">
                                                <a href="<?php echo e(route('reports', ['project' => request()->input('project'), 'result' => 'good', 'sort_by' => 'result', 'sort' => 'asc'])); ?>" class="text-secondary font-weight-medium d-flex align-items-center text-truncate">
                                                    <span class="d-inline-block text-truncate"><?php echo e(__(($goodReportsCount == 1 ? ':value good report' : ':value good reports'), ['value' => number_format($goodReportsCount, 0, __('.'), __(','))])); ?></span>

                                                    <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current flex-shrink-0 '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </a>
                                            </div>

                                            <div class="d-flex align-items-center text-muted mb-0 text-truncate flex-shrink-0">
                                                <?php echo e(number_format($goodReportsCount ? (($goodReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0, 1, __('.'), __(','))); ?>%
                                            </div>
                                        </div>

                                        <div class="progress height-1.25 w-100 mt-2">
                                            <div class="progress-bar bg-success rounded" role="progressbar" style="width: <?php echo e(number_format($goodReportsCount ? (($goodReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>%" aria-valuenow="<?php echo e(number_format($goodReportsCount ? (($goodReportsCount / ($goodReportsCount + $decentReportsCount + $badReportsCount)) * 100) : 0)); ?>" aria-valuemin="0" aria-valuemax="<?php echo e(($goodReportsCount + $decentReportsCount + $badReportsCount)); ?>"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <h4 class="mb-3"><?php echo e(__('Activity')); ?></h4>

            <div class="row m-n2">
                <div class="col-12 col-lg-6 p-2">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header align-items-center">
                            <div class="row">
                                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Latest reports')); ?></div></div>
                            </div>
                        </div>

                        <div class="card-body">
                            <?php if(count($latestReports) == 0): ?>
                                <?php echo e(__('No data')); ?>.
                            <?php else: ?>
                                <div class="list-group list-group-flush my-n3">
                                    <?php $__currentLoopData = $latestReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item px-0">
                                            <div class="row align-items-center">
                                                <div class="col d-flex text-truncate">
                                                    <div class="text-truncate">
                                                        <div class="d-flex align-items-center">
                                                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($report->fullUrl, PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                            <div class="text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>" data-tooltip="true" title="<?php echo e($report->url); ?>">
                                                                <a href="<?php echo e(route('reports.show', $report->id)); ?>" dir="ltr"><?php echo e($report->url); ?></a>
                                                            </div>

                                                            <span class="d-flex align-items-center"><?php echo $__env->make('reports.partials.badge', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <div class="width-4 flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>
                                                            <div class="text-muted text-truncate small">
                                                                <span class="text-muted" data-tooltip="true" title="<?php echo e($report->created_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($report->created_at->diffForHumans()); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-auto d-flex">
                                                    <div class="form-row">
                                                        <div class="col">
                                                            <?php echo $__env->make('reports.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if(count($latestReports) > 0): ?>
                            <div class="card-footer bg-base-2 border-0">
                                <a href="<?php echo e(route('reports')); ?>" class="text-muted font-weight-medium d-flex align-items-center justify-content-center"><?php echo e(__('View all')); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-12 col-lg-6 p-2">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header align-items-center">
                            <div class="row">
                                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Latest projects')); ?></div></div>
                            </div>
                        </div>

                        <div class="card-body">
                            <?php if(count($latestProjects) == 0): ?>
                                <?php echo e(__('No data')); ?>.
                            <?php else: ?>
                                <div class="list-group list-group-flush my-n3">
                                    <?php $__currentLoopData = $latestProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item px-0">
                                            <div class="row align-items-center">
                                                <div class="col d-flex text-truncate">
                                                    <div class="text-truncate">
                                                        <div class="d-flex align-items-center">
                                                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e($project->project); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                            <div class="text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>">
                                                                <a href="<?php echo e(route('reports', ['project' => $project->project])); ?>" dir="ltr"><?php echo e($project->project); ?></a>
                                                            </div>

                                                            <span class="d-flex align-items-center">
                                                                <a href="<?php echo e(route('reports', ['project' => $project->project])); ?>" class="d-none d-md-inline-block badge <?php echo e((($project->result / $project->reports) > 79 ? 'badge-success' : (($project->result / $project->reports) > 49 ? 'badge-warning' : 'badge-danger'))); ?> text-truncate"><?php echo e((($project->result / $project->reports) > 79 ? __('Good') : (($project->result / $project->reports) > 49 ? __('Decent') : __('Bad')))); ?></a>
                                                            </span>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <div class="width-4 flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>
                                                            <div class="text-muted text-truncate small">
                                                                <span class="text-muted" data-tooltip="true" title="<?php echo e($project->created_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($project->created_at->diffForHumans()); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-auto d-flex">
                                                    <div class="form-row">
                                                        <div class="col">
                                                            <?php echo $__env->make('projects.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if(count($latestProjects) > 0): ?>
                            <div class="card-footer bg-base-2 border-0">
                                <a href="<?php echo e(route('projects')); ?>" class="text-muted font-weight-medium d-flex align-items-center justify-content-center"><?php echo e(__('View all')); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <h4 class="mb-3 mt-5"><?php echo e(__('More')); ?></h4>

            <div class="row m-n2">
                <div class="col-12 col-xl-4 p-2">
                    <div class="card border-0 h-100 shadow-sm">
                        <div class="card-body d-flex">
                            <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                <?php echo $__env->make('icons.list-alt', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="d-flex flex-column justify-content-center">
                                <a href="<?php echo e(route('reports')); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Reports')); ?></a>

                                <div class="text-muted">
                                    <?php echo e(__('Manage the reports.')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-xl-4 p-2">
                    <div class="card border-0 h-100 shadow-sm">
                        <div class="card-body d-flex">
                            <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                <?php echo $__env->make('icons.account-tree', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="d-flex flex-column justify-content-center">
                                <a href="<?php echo e(route('projects')); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Projects')); ?></a>

                                <div class="text-muted">
                                    <?php echo e(__('Manage the projects.')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-xl-4 p-2">
                    <div class="card border-0 h-100 shadow-sm">
                        <div class="card-body d-flex">
                            <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                <?php echo $__env->make('icons.handyman', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="d-flex flex-column justify-content-center">
                                <a href="<?php echo e(route('tools')); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Tools')); ?></a>

                                <div class="text-muted">
                                    <?php echo e(__('Manage the tools.')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(config('settings.ad_dashboard_bottom')): ?>
                <div class="d-print-none mt-3"><?php echo config('settings.ad_dashboard_bottom'); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/dashboard/index.blade.php ENDPATH**/ ?>