<?php $__env->startSection('site_title', formatTitle([__('DNS lookup'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('DNS lookup')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('DNS lookup')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.dns_lookup')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">
                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.dns_lookup')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($results)): ?>
                <?php echo e(__('No results found.')); ?>

            <?php else: ?>
                <ul class="nav nav-pills d-flex flex-fill flex-column flex-md-row mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link active" id="pills-dns-a-tab" data-toggle="pill" href="#pills-dns-a" role="tab" aria-controls="pills-dns-a" aria-selected="true"><?php echo e(__('A')); ?></a>
                    </li>
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link" id="pills-dns-aaaa-tab" data-toggle="pill" href="#pills-dns-aaaa" role="tab" aria-controls="pills-dns-aaaa" aria-selected="false"><?php echo e(__('AAAA')); ?></a>
                    </li>
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link" id="pills-dns-cname-tab" data-toggle="pill" href="#pills-dns-cname" role="tab" aria-controls="pills-dns-cname" aria-selected="false"><?php echo e(__('CNAME')); ?></a>
                    </li>
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link" id="pills-dns-mx-tab" data-toggle="pill" href="#pills-dns-mx" role="tab" aria-controls="pills-dns-mx" aria-selected="false"><?php echo e(__('MX')); ?></a>
                    </li>
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link" id="pills-dns-txt-tab" data-toggle="pill" href="#pills-dns-txt" role="tab" aria-controls="pills-dns-txt" aria-selected="false"><?php echo e(__('TXT')); ?></a>
                    </li>
                    <li class="nav-item flex-grow-1 text-center">
                        <a class="nav-link" id="pills-dns-ns-tab" data-toggle="pill" href="#pills-dns-ns" role="tab" aria-controls="pills-dns-ns" aria-selected="false"><?php echo e(__('NS')); ?></a>
                    </li>
                </ul>

                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-dns-a" role="tabpanel"
                         aria-labelledby="pills-dns-a-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('IP')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'a'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['ip']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="pills-dns-aaaa" role="tabpanel" aria-labelledby="pills-dns-aaaa-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('IPv6')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'aaaa'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['ipv6']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="pills-dns-cname" role="tabpanel"
                         aria-labelledby="pills-dns-cname-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Target')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'cname'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['target']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="pills-dns-mx" role="tabpanel" aria-labelledby="pills-dns-mx-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-3 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-3 text-truncate"><?php echo e(__('Target')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Priority')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'mx'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-3 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-3 text-break"><?php echo e($result['target']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['pri']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="pills-dns-txt" role="tabpanel" aria-labelledby="pills-dns-txt-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Entries')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'txt'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-4 text-break">
                                                <?php $__currentLoopData = $result['entries']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="text-break <?php echo e(!$loop->first ? 'mt-1' : ''); ?>"><?php echo e($entry); ?></div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="pills-dns-ns" role="tabpanel" aria-labelledby="pills-dns-ns-tab">
                        <div class="list-group list-group-flush mb-n3">
                            <div class="list-group-item px-0">
                                <div class="row align-items-center text-muted">
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('Type')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Hostname')); ?></div>
                                    <div class="col-12 col-lg-4 text-truncate"><?php echo e(__('Target')); ?></div>
                                    <div class="col-12 col-lg-2 text-truncate"><?php echo e(__('TTL')); ?></div>
                                </div>
                            </div>

                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'ns'): ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center text-muted">
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['type']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['host']); ?></div>
                                            <div class="col-12 col-lg-4 text-break"><?php echo e($result['target']); ?></div>
                                            <div class="col-12 col-lg-2 text-break"><?php echo e($result['ttl']); ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/dns-lookup.blade.php ENDPATH**/ ?>