<?php $__env->startSection('site_title', formatTitle([__('Indexed pages checker'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Indexed pages checker')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Indexed pages checker')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.indexed_pages_checker')); ?>" method="post" enctype="multipart/form-data" id="indexed-pages-checker-form" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">
                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-country"><?php echo e(__('Country')); ?></label>
                <select name="country" id="i-country" class="custom-select<?php echo e($errors->has('country') ? ' is-invalid' : ''); ?>">
                    <option value="" hidden disabled selected><?php echo e(__('Country')); ?></option>
                    <?php $__currentLoopData = array_diff_key(config('countries'), array_flip(['AX', 'BQ', 'CT', 'NQ', 'FQ', 'GG', 'IM', 'JE', 'JT', 'FX', 'MI', 'ME', 'NT', 'VD', 'PC', 'PZ', 'YD', 'BL', 'MF', 'RS', 'PU', 'SU', 'ZZ', 'WK'])); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((isset($country) && $country == $key) || (!isset($country) && old('country') !== null && old('country') == $key) || (!isset($country) && config('settings.gcs_country') == $key && old('country') == null)): ?> selected <?php endif; ?>><?php echo e(__($value)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('country')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('country')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <?php if(config('settings.captcha_indexed_pages_checker')): ?>
                        <?php echo NoCaptcha::displaySubmit('indexed-pages-checker-form', __('Search'), ['data-theme' => (config('settings.dark_mode') == 1 ? 'dark' : 'light'), 'data-size' => 'invisible', 'class' => 'btn ' . ($errors->has('g-recaptcha-response') ? 'btn-danger' : 'btn-primary')]); ?>


                        <?php echo NoCaptcha::renderJs(__('lang_code')); ?>

                    <?php else: ?>
                        <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                    <?php endif; ?>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.indexed_pages_checker')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>

            <?php if($errors->has('g-recaptcha-response')): ?>
                <span class="invalid-feedback d-block" role="alert">
                    <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                </span>
            <?php endif; ?>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($result)): ?>
                <?php echo e(__('No results found.')); ?>

            <?php elseif(isset($result['error'])): ?>
                <?php echo e($result['error']['code'] ?? null); ?> <?php echo e($result['error']['message'] ?? null); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Domain')); ?></div>
                            <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                                <img src="https://icons.duckduckgo.com/ip3/<?php echo e($domain); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                <span dir="ltr"><?php echo e($domain); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Status')); ?></div>
                            <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                                <?php if($result['searchInformation']['totalResults'] > 0): ?>
                                    <div class="bg-success width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                    <div class="text-truncate"><?php echo e(__('Indexed')); ?></div>
                                <?php else: ?>
                                    <div class="bg-danger width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                    <div class="text-truncate"><?php echo e(__('Not indexed')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Pages')); ?></div>
                            <div class="col-12 col-lg-8 text-break">≈<?php echo e(number_format($result['searchInformation']['totalResults'], 0, __('.'), __(','))); ?></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/indexed-pages-checker.blade.php ENDPATH**/ ?>