

<?php $__env->startSection('site_title', formatTitle([__('Developers'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 flex-fill">
        <div class="container h-100 py-6">

            <div class="text-center">
                <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Developers')); ?></h1>
                <div class="m-auto">
                    <p class="text-muted font-weight-normal font-size-lg mb-5"><?php echo e(__('Explore our API documentation.')); ?></p>
                </div>
            </div>

            <?php
                $resources = [
                    [
                        'icon' => 'account-tree',
                        'title' => __('Projects'),
                        'description' => __('Manage the projects.'),
                        'route' => route('developers.projects')
                    ],
                    [
                        'icon' => 'list-alt',
                        'title' => __('Reports'),
                        'description' => __('Manage the reports.'),
                        'route' => route('developers.reports')
                    ],
                    [
                        'icon' => 'portrait',
                        'title' => __('Account'),
                        'description' => __('Manage the account.'),
                        'route' => route('developers.account')
                    ]
                ];
            ?>

            <div class="row m-n2">
                <?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12 col-sm-6 col-md-4 p-2">
                        <div class="card border-0 h-100 shadow-sm">
                            <div class="card-body d-flex">
                                <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                    <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                    <?php echo $__env->make('icons.' . $resource['icon'], ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="d-flex flex-column justify-content-center">
                                    <a href="<?php echo e($resource['route']); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e($resource['title']); ?></a>

                                    <div class="text-muted">
                                        <?php echo e($resource['description']); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/developers/index.blade.php ENDPATH**/ ?>