<?php if(isset($report['results'][$name])): ?>
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                <?php echo $__env->make('reports.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate font-weight-medium"><?php echo e(__('Structured data')); ?></div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            <?php if($report['results'][$name]['passed']): ?>
                                <div>
                                    <?php echo e(__('The webpage has structured data.')); ?>

                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $report['results'][$name]['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e((!$loop->first) ? 'mt-3' : ''); ?>">
                                        <?php if($error == 'missing'): ?>
                                            <?php echo e(__('There are no structured data tags on the webpage.')); ?>

                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <div class="list-group small mt-2">
                                <?php $__currentLoopData = $report['results'][$name]['value']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item p-0">
                                        <a href="#collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>" class="d-flex text-secondary justify-content-between align-items-center text-decoration-none px-3 py-2" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>">
                                            <div class="font-weight-medium"><?php echo e($key); ?></div>
                                            <span class="badge badge-secondary badge-pill"><?php echo e(number_format(count($report['results'][$name]['value'][$key]), 0, __('.'), __(','))); ?></span>
                                        </a>

                                        <div class="px-3 collapse" id="collapse-<?php echo e(mb_strtolower(str_replace([' ', '.'], '-', $key))); ?>">
                                            <div class="pb-2">
                                                <?php echo e(arrayToHtml($value, ['<ol class="mb-0">', '</ol>'], ['<ul>', '</ul>'], ['<li class="py-1 text-break">', '</li>'], ['<span class="font-weight-medium">', '</span> '], ['<span class="text-muted">', '</span>'])); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse<?php echo e($name); ?>" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse<?php echo e($name); ?>" data-tooltip="true" title="<?php echo e(__('More')); ?>">
                        <?php echo $__env->make('icons.info', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse<?php echo e(Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : ''); ?>" id="collapse<?php echo e($name); ?>">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                <?php echo e(__('The structured data tags help the search engines better understand the content of the webpage, and allows them to create rich snippets in search results.')); ?>


                <hr>

                <div class="row">
                    <div class="col-12 col-md">
                        <?php echo e(__('Learn more')); ?>

                    </div>

                    <div class="col-12 col-md-auto">
                        <a href="https://developer.twitter.com/en/docs/twitter-for-websites/cards/overview/markup" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Twitter <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://schema.org/" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Schema.org <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://ogp.me/" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Open Graph <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://www.bing.com/webmasters/help/marking-up-your-site-with-structured-data-3a93e731" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Bing <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://developers.google.com/search/docs/advanced/structured-data/intro-structured-data" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Google <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/structured-data.blade.php ENDPATH**/ ?>