

<?php $__env->startSection('site_title', formatTitle([__('Reports'), __('Developers'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 flex-fill">
        <div class="container h-100 py-3 my-3">

            <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                ['url' => route('home'), 'title' => __('Home')],
                ['url' => route('developers'), 'title' => __('Developers')],
                ['title' => __('Reports')]
            ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <h1 class="h2 mb-0 d-inline-block"><?php echo e(__('Reports')); ?></h1>

            <?php echo $__env->make('developers.notes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('List')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

<div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
    <span class="badge bg-light text-success px-2 py-1 mr-3">GET</span>
    <pre class="m-0 text-light"><?php echo e(route('api.reports.index')); ?></pre>
</div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
<pre class="bg-dark text-light p-3 mb-0 rounded text-left" dir="ltr">
curl --location --request GET '<?php echo e(route('api.reports.index')); ?>' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>

                <?php echo $__env->make('developers.reports.list', ['type' => 0], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Show')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

<div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
<span class="badge bg-light text-success px-2 py-1 mr-3">GET</span>
<pre class="m-0 text-light"><?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.show', ['id' => ':id'])); ?></pre>
</div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
<pre class="bg-dark text-light p-3 mb-0 rounded text-left" dir="ltr">
curl --location --request GET '<?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.show', ['id' => ':id'])); ?>' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>
                </div>
            </div>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Store')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

<div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
<span class="badge bg-light text-warning px-2 py-1 mr-3">POST</span>
<pre class="m-0 text-light"><?php echo e(route('api.reports.store')); ?></pre>
</div>
                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
<pre class="bg-dark text-light p-3 rounded text-left" dir="ltr">
curl --location --request POST '<?php echo e(route('api.reports.store')); ?>' \
--header 'Content-Type: application/x-www-form-urlencoded' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>' \
--data-urlencode 'url=<span class="text-success">{url}</span>'
</pre>

                    <?php echo $__env->make('developers.reports.store-update', ['type' => 1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Update')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

                    <div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
                        <span class="badge bg-light text-info px-2 py-1 mr-2">PUT</span> <span class="badge bg-light text-info px-2 py-1 mr-3">PATCH</span>
                        <pre class="m-0 text-light"><?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.update', ['id' => ':id'])); ?></pre>
                    </div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
                    <pre class="bg-dark text-light p-3 rounded text-left" dir="ltr">
curl --location --request PUT '<?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.update', ['id' => ':id'])); ?>' \
--header 'Content-Type: application/x-www-form-urlencoded' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>

                    <?php echo $__env->make('developers.reports.store-update', ['type' => 0], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <div class="card border-0 shadow-sm mt-3">
                <div class="card-header align-items-center">
                    <div class="row">
                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Delete')); ?></div></div>
                    </div>
                </div>

                <div class="card-body">
                    <p class="mb-1">
                        <?php echo e(__('API endpoint')); ?>:
                    </p>

                    <div class="bg-dark text-light p-3 rounded d-flex align-items-center mb-3" dir="ltr">
                        <span class="badge bg-light text-danger px-2 py-1 mr-3">DELETE</span>
                        <pre class="m-0 text-light"><?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.destroy', ['id' => ':id'])); ?></pre>
                    </div>

                    <p class="mb-1">
                        <?php echo e(__('Request example')); ?>:
                    </p>
                    <pre class="bg-dark text-light p-3 mb-0 rounded text-left" dir="ltr">
curl --location --request DELETE '<?php echo str_replace(':id', '<span class="text-success">{id}</span>', route('api.reports.destroy', ['id' => ':id'])); ?>' \
--header 'Authorization: Bearer <span class="text-success">{api_key}</span>'
</pre>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/developers/reports/index.blade.php ENDPATH**/ ?>