

<?php $__env->startSection('site_title', formatTitle([__('Register'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 d-flex align-items-center flex-fill">
    <div class="container h-100 py-6">

        <div class="text-center d-block d-lg-none">
            <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Register')); ?></h1>
            <div class="m-auto">
                <p class="text-muted font-weight-normal font-size-lg mb-0"><?php echo e(__('Join us.')); ?></p>
            </div>
        </div>

        <div class="row h-100 justify-content-center align-items-center mt-5 mt-lg-0">
            <div class="col-12">
                <div class="card border-0 shadow-sm overflow-hidden">
                    <div class="row no-gutters">
                        <div class="col-12 col-lg-5">
                            <div class="card-body p-lg-5">
                                <form method="POST" action="<?php echo e(route('register')); ?>" id="registration-form">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <label for="i-name"><?php echo e(__('Name')); ?></label>
                                        <input id="i-name" type="text" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="name" value="<?php echo e(old('name')); ?>" autofocus>
                                        <?php if($errors->has('name')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('name')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="i-email"><?php echo e(__('Email address')); ?></label>
                                        <input id="i-email" type="text" dir="ltr" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>">
                                        <?php if($errors->has('email')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('email')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="i-password"><?php echo e(__('Password')); ?></label>
                                        <input id="i-password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password">
                                        <?php if($errors->has('password')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('password')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="i-password-confirmation"><?php echo e(__('Confirm password')); ?></label>
                                        <input id="i-password-confirmation" type="password" class="form-control<?php echo e($errors->has('password_confirmation') ? ' is-invalid' : ''); ?>" name="password_confirmation">
                                    </div>

                                    <div class="form-group">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input<?php echo e($errors->has('agreement') ? ' is-invalid' : ''); ?>" name="agreement" id="i-agreement">
                                            <label class="custom-control-label" for="i-agreement"><?php echo __('I agree to the :terms and :privacy.', ['terms' => mb_strtolower('<a href="'.config('settings.legal_terms_url').'" target="_blank">'. __('Terms of service').'</a>'), 'privacy' => mb_strtolower('<a href="'.config('settings.legal_privacy_url').'" target="_blank">'. __('Privacy policy') .'</a>')]); ?></label>
                                            <?php if($errors->has('agreement')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('agreement')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <?php if(config('settings.captcha_registration')): ?>
                                        <?php echo NoCaptcha::displaySubmit('registration-form', __('Register'), ['data-theme' => (config('settings.dark_mode') == 1 ? 'dark' : 'light'), 'data-size' => 'invisible', 'class' => 'btn btn-block btn-primary py-2']); ?>


                                        <?php echo NoCaptcha::renderJs(__('lang_code')); ?>

                                    <?php else: ?>
                                        <button type="submit" class="btn btn-block btn-primary py-2">
                                            <?php echo e(__('Register')); ?>

                                        </button>
                                    <?php endif; ?>

                                    <?php if($errors->has('g-recaptcha-response')): ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </form>
                            </div>
                            <div class="card-footer bg-base-2 border-0">
                                <div class="text-center text-muted my-2"><?php echo e(__('Already have an account?')); ?> <a href="<?php echo e(route('login')); ?>" role="button"><?php echo e(__('Login')); ?></a></div>
                            </div>
                        </div>
                        <div class="col-12 col-lg-7 bg-dark d-none d-lg-flex flex-fill background-size-cover background-position-center" style="background-image: url(<?php echo e(asset('images/register.svg')); ?>)">
                            <div class="card-body p-lg-5 d-flex flex-column flex-fill position-absolute top-0 right-0 bottom-0 left-0">
                                <div class="d-flex align-items-center d-flex flex-fill">
                                    <div class="text-light <?php echo e((__('lang_dir') == 'rtl' ? 'mr-5' : 'ml-5')); ?>">
                                        <div class="h2 font-weight-bold">
                                            <?php echo e(__('Register')); ?>

                                        </div>
                                        <div class="font-size-lg font-weight-medium">
                                            <?php echo e(__('Join us.')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/auth/register.blade.php ENDPATH**/ ?>