<?php $__env->startSection('site_title', formatTitle([__('Lorem ipsum generator'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Lorem ipsum generator')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Lorem ipsum generator')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.lorem_ipsum_generator')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-type"><?php echo e(__('Type')); ?></label>
                <select name="type" id="i-type" class="custom-select<?php echo e($errors->has('type') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = ['paragraphs' => __('Paragraphs'), 'sentences' => __('Sentences'), 'words' => __('Words')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('type') !== null && old('type') == $key) || (isset($type) && $type == $key && old('type') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('type')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('type')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-number"><?php echo e(__('Number')); ?></label>
                <input type="number" name="number" id="i-number" class="form-control<?php echo e($errors->has('number') ? ' is-invalid' : ''); ?>" value="<?php echo e($number ?? (old('number') ?? '5')); ?>">
                <?php if($errors->has('number')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('number')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Generate')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.lorem_ipsum_generator')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body mb-n3">
            <div class="form-group">
                <label for="i-result-content"><?php echo e(__('Content')); ?></label>

                <div class="position-relative">
                        <textarea rows="5" id="i-result-content" class="form-control" onclick="this.select();" readonly>
<?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php echo e($block); ?>

<?php if(!$loop->last): ?><?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></textarea>

                    <div class="position-absolute top-0 right-0">wf
                        <div class="btn btn-sm btn-primary m-2" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-result-content"><?php echo e(__('Copy')); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/lorem-ipsum-generator.blade.php ENDPATH**/ ?>