

<?php $__env->startSection('site_title', formatTitle([__('Login'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 d-flex align-items-start align-items-lg-center flex-fill">
    <div class="container h-100 py-6">

        <div class="text-center d-block d-lg-none">
            <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Login')); ?></h1>
            <div class="m-auto">
                <p class="text-muted font-weight-normal font-size-lg mb-0"><?php echo e(__('Welcome back.')); ?></p>
            </div>
        </div>

        <div class="row h-100 justify-content-center align-items-center mt-5 mt-lg-0">
            <div class="col-12">
                <div class="card border-0 shadow-sm overflow-hidden">
                    <div class="row no-gutters">
                        <div class="col-12 col-lg-5">
                            <div class="card-body p-lg-5">
                                <form method="POST" action="<?php echo e(route('login')); ?>">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <label for="i-email"><?php echo e(__('Email address')); ?></label>
                                        <input id="i-email" type="text" dir="ltr" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>" autofocus>
                                        <?php if($errors->has('email')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('email')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="i-password"><?php echo e(__('Password')); ?></label>
                                        <input id="i-password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password">
                                        <?php if($errors->has('password')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('password')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="form-group row">
                                        <div class="col-6">
                                            <div class="custom-control custom-checkbox">
                                                <input class="custom-control-input" type="checkbox" name="remember" id="i-remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>

                                                <label class="custom-control-label" for="i-remember">
                                                    <?php echo e(__('Remember me')); ?>

                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-6 <?php echo e((__('lang_dir') == 'rtl' ? 'text-left' : 'text-right')); ?>">
                                            <?php if(Route::has('password.request')): ?>
                                                <a href="<?php echo e(route('password.request')); ?>">
                                                    <?php echo e(__('Forgot password?')); ?>

                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-block btn-primary py-2">
                                        <?php echo e(__('Login')); ?>

                                    </button>
                                </form>
                            </div>
                            <?php if(config('settings.registration')): ?>
                                <div class="card-footer bg-base-2 border-0">
                                    <div class="text-center text-muted my-2"><?php echo e(__('Don\'t have an account?')); ?> <a href="<?php echo e(route('register')); ?>" role="button"><?php echo e(__('Register')); ?></a></div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-12 col-lg-7 bg-dark d-none d-lg-flex flex-fill background-size-cover background-position-center" style="background-image: url(<?php echo e(asset('images/login.svg')); ?>)">
                            <div class="card-body p-lg-5 d-flex flex-column flex-fill position-absolute top-0 right-0 bottom-0 left-0">
                                <div class="d-flex align-items-center d-flex flex-fill">
                                    <div class="text-light <?php echo e((__('lang_dir') == 'rtl' ? 'mr-5' : 'ml-5')); ?>">
                                        <div class="h2 font-weight-bold">
                                            <?php echo e(__('Login')); ?>

                                        </div>
                                        <div class="font-size-lg font-weight-medium">
                                            <?php echo e(__('Welcome back.')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/auth/login.blade.php ENDPATH**/ ?>