

<?php $__env->startSection('site_title', formatTitle([__('Tools'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 flex-fill">
    <div class="container py-3 my-3">
        <div class="row">
            <div class="col-12">
                <?php if(config('settings.tools_guest') && !Auth::check()): ?>
                    <div class="text-center mt-3 mb-5">
                        <h1 class="h2 my-3 d-inline-block"><?php echo e(__('Tools')); ?></h1>
                        <div class="m-auto">
                            <p class="text-muted font-weight-normal font-size-lg mb-0"><?php echo e(__('Web tools and utilities.')); ?></p>
                        </div>
                    </div>
                <?php else: ?>
                    <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                        ['url' => route('dashboard'), 'title' => __('Home')],
                        ['title' => __('Tools')],
                    ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="d-flex align-items-end">
                        <h1 class="h2 mb-3 flex-grow-1 text-truncate"><?php echo e(__('Tools')); ?></h1>
                    </div>
                <?php endif; ?>

                <div class="card border-0 shadow-sm mb-3">
                    <div class="card-body">
                        <form enctype="multipart/form-data" autocomplete="off" id="form-tools-search" onsubmit="event.preventDefault();">
                            <?php echo csrf_field(); ?>

                            <div class="input-group input-group-lg">
                                <input type="text" name="search" class="form-control font-size-lg" autocapitalize="none" spellcheck="false" id="i-search" placeholder="<?php echo e(__('Search')); ?>" autofocus>
                            </div>

                            <div class="input-group-append border-left-0 d-none" data-tooltip="true" id="clear-button-container">
                                <button type="button" class="btn text-secondary bg-transparent input-group-text d-flex align-items-center" id="b-clear">
                                    <?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="row m-n2" id="tools">
                    <?php $__currentLoopData = config('tools'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!isset($category) || isset($category) && $category != $tool['category']): ?>
                            <div class="col-12 p-2 mt-3" data-tool-category="<?php echo e($tool['category']); ?>">
                                <div class="badge badge-<?php echo e(($tool['category'] == 'research' ? 'danger' : ($tool['category'] == 'developer' ? 'success' : 'info'))); ?>"><?php echo e(__(Str::ucfirst($tool['category']))); ?></div>
                            </div>
                        <?php endif; ?>

                        <div class="col-12 col-md-6 col-lg-4 p-2" data-tool-title="<?php echo e(__($tool['title'])); ?>" data-tool-parent="<?php echo e($tool['category']); ?>">
                            <div class="card border-0 h-100 shadow-sm">
                                <div class="card-body d-flex align-items-center text-truncate">
                                    <div class="d-flex position-relative text-<?php echo e(($tool['category'] == 'research' ? 'danger' : ($tool['category'] == 'developer' ? 'success' : 'info'))); ?> width-8 height-8 align-items-center justify-content-center flex-shrink-0">
                                        <div class="position-absolute bg-<?php echo e(($tool['category'] == 'research' ? 'danger' : ($tool['category'] == 'developer' ? 'success' : 'info'))); ?> opacity-10 top-0 right-0 bottom-0 left-0 border-radius-lg"></div>
                                        <?php echo $__env->make('icons.' . $tool['icon'], ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                    <a href="<?php echo e(route($tool['route'])); ?>" class="text-dark font-weight-medium stretched-link text-decoration-none text-truncate mx-3"><?php echo e(__($tool['title'])); ?></a>

                                    <div class="text-muted d-flex align-items-center text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'mr-auto' : 'ml-auto')); ?>">
                                        <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'flex-shrink-0 width-3 height-3 fill-current mx-2'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php $category = $tool['category']; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/list.blade.php ENDPATH**/ ?>