

<?php $__env->startSection('site_title', formatTitle([Str::ucfirst(mb_strtolower(__('Reset Password'))), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 d-flex align-items-start align-items-lg-center flex-fill">
        <div class="container h-100 py-6">

            <div class="text-center d-block d-lg-none">
                <h1 class="h2 mb-3 d-inline-block"><?php echo e(Str::ucfirst(mb_strtolower(__('Reset Password')))); ?></h1>
                <div class="m-auto">
                    <p class="text-muted font-weight-normal font-size-lg mb-0"><?php echo e(__('Get back your account.')); ?></p>
                </div>
            </div>

            <div class="row h-100 justify-content-center align-items-center mt-5 mt-lg-0">
                <div class="col-12">
                    <div class="card border-0 shadow-sm overflow-hidden">
                        <div class="row no-gutters">
                            <div class="col-12 col-lg-5">
                                <div class="card-body p-lg-5">
                                    <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <?php if(request()->session()->get('status')): ?>
                                        <div class="alert alert-success" role="alert">
                                            <?php echo e(request()->session()->get('status')); ?>

                                        </div>
                                    <?php endif; ?>

                                    <form method="POST" action="<?php echo e(route('password.email')); ?>">
                                        <?php echo csrf_field(); ?>


                                        <div class="form-group">
                                            <label for="i-email"><?php echo e(__('Email address')); ?></label>
                                            <input id="i-email" type="text" dir="ltr" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>" autofocus>
                                            <?php if($errors->has('email')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <button type="submit" class="btn btn-block btn-primary">
                                            <?php echo e(__('Send Password Reset Link')); ?>

                                        </button>
                                    </form>
                                </div>
                            </div>
                            <div class="col-12 col-lg-7 bg-dark d-none d-lg-flex flex-fill background-size-cover background-position-center" style="background-image: url(<?php echo e(asset('images/password.svg')); ?>)">
                                <div class="card-body p-lg-5 d-flex flex-column flex-fill position-absolute top-0 right-0 bottom-0 left-0">
                                    <div class="d-flex align-items-center d-flex flex-fill">
                                        <div class="text-light <?php echo e((__('lang_dir') == 'rtl' ? 'mr-5' : 'ml-5')); ?>">
                                            <div class="h2 font-weight-bold">
                                                <?php echo e(Str::ucfirst(mb_strtolower(__('Reset Password')))); ?>

                                            </div>
                                            <div class="font-size-lg font-weight-medium">
                                                <?php echo e(__('Get back your account.')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>