<?php $__env->startSection('site_title', formatTitle([__('Redirect checker'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Redirect checker')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Redirect checker')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.redirect_checker')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-url"><?php echo e(__('URL')); ?></label>
                <input type="text" dir="ltr" name="url" id="i-url" class="form-control<?php echo e($errors->has('url') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('url') ?? ($url ?? null)); ?>">
                <?php if($errors->has('url')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('url')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Analyze')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.redirect_checker')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <?php if(empty($results)): ?>
                <?php echo e(__('No results found.')); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0 text-muted">
                        <div class="row align-items-center">
                            <div class="col">
                                <div class="row">
                                    <div class="col d-flex align-items-center">
                                        <div class="flex-shrink-0 width-8 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">#</div>
                                        <?php echo e(__('URL')); ?>

                                    </div>

                                    <div class="col-auto">
                                        <?php echo e(__('Status')); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-auto <?php echo e((__('lang_dir') == 'rtl' ? 'text-right' : 'text-left')); ?>">
                                <div class="invisible btn btn-sm btn-outline-primary"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="list-group-item px-0">
                            <div class="row align-items-center">
                                <div class="col text-truncate">
                                    <div class="row text-truncate">
                                        <div class="col d-flex text-truncate">
                                            <div class="text-truncate">
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0 width-8 text-dark <?php echo e($result['http_code'] == '200' ? 'font-weight-medium' : ''); ?>"><?php echo e(($loop->index + 1)); ?></div>

                                                    <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($result['url'], PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="flex-shrink-0 width-4 height-4 mx-3">

                                                    <div class="text-truncate">
                                                        <a href="<?php echo e($result['url']); ?>" class="<?php echo e($result['http_code'] == '200' ? 'text-dark font-weight-medium' : 'text-secondary'); ?>" dir="ltr" rel="nofollow" target="_blank"><?php echo e($result['url']); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-auto d-flex text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'text-right' : 'text-left')); ?>">
                                            <span class="<?php echo e($result['http_code'] == '200' ? 'text-success font-weight-medium' : 'text-secondary'); ?>"><?php echo e($result['http_code']); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="btn btn-sm btn-outline-primary" data-tooltip-copy="true" data-clipboard-copy="<?php echo e($result['url']); ?>" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>"><?php echo e(__('Copy')); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/redirect-checker.blade.php ENDPATH**/ ?>