<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');

        $user_id = $_SESSION['user']['id'];
        $website_url = $_POST['website_url'];

        // Validate the website URL
        if (filter_var($website_url, FILTER_VALIDATE_URL) === false) {
            echo json_encode(array('success' => false, 'message' => 'Invalid website URL', 'icon' => 'error' ));
        } else {
            $website_url = strtolower($website_url);

            // Check if the website URL already exists in the database
            $check_sql = "SELECT website_id FROM analytics_websites WHERE user_id = ? AND website_url = ?";
            $check_stmt = $conn->prepare($check_sql);
            $check_stmt->bind_param("is", $user_id, $website_url);
            $check_stmt->execute();
            $check_result = $check_stmt->get_result();

            if ($check_result->num_rows > 0) {
                // Website already exists in the database
                echo json_encode(array('success' => false, 'message' => 'Website already added', 'icon' => 'error'));
            } else {
                // SQL query to insert a new website
                $sql = "INSERT INTO analytics_websites (user_id, website_url) VALUES (?, ?)";

                // Prepare and execute the query
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("is", $user_id, $website_url);

                if ($stmt->execute()) {
                    echo json_encode(array('success' => true, 'message' => 'Website added'));
                } else {
                    echo json_encode(array('success' => false, 'message' => 'Error adding the website'));
                }

                // Close the database connection
                $stmt->close();
            }
            // Close the check statement and database connection
            $check_stmt->close();
            $conn->close();
        }
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed.'));
    }
}
?>
