<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');

    $user_id = $_SESSION['user']['id'];

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // SQL query to fetch website URLs and IDs for the specific user
    $sql = "SELECT website_url, website_id FROM analytics_websites WHERE user_id = ?";

    // Prepare and execute the query
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $websites = array();

        // Fetch website URLs and IDs and store them in an associative array
        while ($row = $result->fetch_assoc()) {
            $websites[] = array(
                'website_url' => $row['website_url'],
                'website_id' => $row['website_id']
            );
        }

        // Close the database connection
        $stmt->close();
        $conn->close();

        // Return the website URLs and IDs as JSON
        echo json_encode($websites);
    } else {
        // No records found
        echo json_encode(array());
    }
}
?>
