<?php
include_once includes('config.php');

// Initialize an array to store invoice data
$invoicesData = array();

// Retrieve billing for the logged-in user
$user_id = $_SESSION['user']['id'];
$sql = "SELECT invoice_status, invoice_number, total_amount, currency, invoice_date FROM invoices WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $currencySign = getCurrencySign($row['currency']);
        if ($row['currency'] === 'try') {
            $row['total_amount'] = $row['total_amount'] . ' ' . $currencySign; // Add a space before the currency sign
        } else {
            $row['total_amount'] = $currencySign . $row['total_amount'];
        }
        // Prepare the invoice data
        $invoiceData = array(
            'invoice_status' => $row['invoice_status'],
            'invoice_number' => $row['invoice_number'],
            'total_amount' => $row['total_amount'],
            'currency' => $row['currency'],
            'invoice_date' => $row['invoice_date']
        );

        // Add the invoice data to the array
        $invoicesData[] = $invoiceData;
    }
}

// Return the invoice data as JSON
header('Content-Type: application/json');
echo json_encode(array('invoices' => $invoicesData));
function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'usd' => '$',
        'eur' => '€',
        'gbp' => '£',
        'try' => ' TL', // Added space before the TRY sign
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}

?>
