<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');

        // Retrieve form data
        $user_id = $_SESSION['user']['id'];
        $name = isset($_POST['name']) ? $_POST['name'] : "";
        $username = isset($_POST['username']) ? $_POST['username'] : "";
        $email = isset($_POST['email']) ? $_POST['email'] : "";
        $phone = isset($_POST['phone-number']) ? $_POST['phone-number'] : "";
        $password = isset($_POST['password']) ? $_POST['password'] : "";
        $confirmPassword = isset($_POST['confirmPassword']) ? $_POST['confirmPassword'] : "";
        $currency = isset($_POST['currency']) ? $_POST['currency'] : "";

        if (isset($_FILES['profile-picture']) && $_FILES['profile-picture']['error'] === UPLOAD_ERR_OK) {
            // Specify the destination directory with the full server path
            $uploadDirectory = $_SERVER['DOCUMENT_ROOT'] . '/assets/uploads/profile_pictures/';

            // Get the original file name and extension
            $originalFilename = $_FILES['profile-picture']['name'];
            $extension = pathinfo($originalFilename, PATHINFO_EXTENSION);

            // Generate a unique filename for the uploaded file with lowercase extension
            $filename = uniqid() . '.' . strtolower($extension);

            // Move the uploaded file to the specified directory
            if (move_uploaded_file($_FILES['profile-picture']['tmp_name'], $uploadDirectory . $filename)) {
                // File upload was successful, store the profile picture details
                $profile_picture_filename = $filename;
                cropToSquare($uploadDirectory . $filename);
            } else {
                $response = array('success' => false, 'message' => $lang['update-profile-photo-upload-error']);
                echo json_encode($response);
                exit;
            }
        }

        if (!empty($password) && strlen($password) < 8) {
            $response = array('status' => 'error', 'reason' => 'password', 'message' => $lang['user-register-password-length-error'], 'icon' => 'error');
            echo json_encode($response);
            die();
        }

        if (!empty($username)) {
            if (strlen($username) < 4) {
                $response = array('status' => 'error','reason' => 'username','message' => $lang['user-register-username-length-error'], 'icon' => 'error');
                echo json_encode($response);
                die();
            }
            if (strlen($username) > 32) {
                $response = array('status' => 'error','reason' => 'username','message' => $lang['user-register-username-long-length-error'], 'icon' => 'error');
                echo json_encode($response);
                die();
            }
            // Check if the username contains only alphanumeric characters and underscores
            if (!preg_match('/^[a-zA-Z0-9_]+$/', $username)) {
                $response = array('status' => 'error', 'reason' => 'username', 'message' => $lang['user-register-username-special-chars-error'], 'icon' => 'error');
                echo json_encode($response);
                die();
            }
        }

        if (!isValidPhoneNumber($phone)) {
            $response = array('status' => 'error', 'reason' => 'phone_number', 'message' => $lang['update-profile-invalid-phone-number'], 'icon' => 'error');
            echo json_encode($response);
            die();
        }

        if ($password !== $confirmPassword) {
            $response = array('status' => 'error', 'reason' => 'username', 'message' => $lang['update-profile-password-not-match'], 'icon' => 'error');
            echo json_encode($response);
            die();
        }



        // Check the connection
        if ($conn->connect_error) {
            die('Connection failed: ' . $conn->connect_error);
        }

        // Initialize an empty array to store the update values and types
        $updateValues = [];
        $updateTypes = "";

        // Build the SQL query dynamically based on the fields that have data
        $query = "UPDATE users SET";

        if (!empty($username)) {
            $query .= " username = ?,";
            $updateValues[] = $username;
            $updateTypes .= "s";
        }

        if (!empty($name)) {
            $query .= " name = ?,";
            $updateValues[] = $name;
            $updateTypes .= "s";
        }

        if (!empty($email)) {
            $query .= " email = ?,";
            $updateValues[] = $email;
            $updateTypes .= "s";
        }

        if (!empty($phone)) {
            $query .= " phone_number = ?,";
            $updateValues[] = $phone;
            $updateTypes .= "s";
        }

        if (!empty($password)) {
            // You should hash the password for security
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $query .= " password = ?,";
            $updateValues[] = $hashedPassword;
            $updateTypes .= "s";
        }

        if (!empty($currency)) {
            $query .= " currency = ?,";
            $updateValues[] = $currency;
            $updateTypes .= "s";
        }
        if (!empty($profile_picture_filename)) {
            $query .= " profile_picture = ?,";
            $updateValues[] = $profile_picture_filename;
            $updateTypes .= "s";
        }

        // Remove the trailing comma and add the WHERE clause
        $query = rtrim($query, ',') . " WHERE user_id = ?";
        $updateValues[] = $user_id;
        $updateTypes .= "i";

        // Prepare and execute the SQL query
        $stmt = $conn->prepare($query);
        if ($stmt) {
            $stmt->bind_param($updateTypes, ...$updateValues);
            if ($stmt->execute()) {
                $response = array('success' => true, 'message' => $lang['update-profile-updated'], 'icon' => 'success');
                echo json_encode($response);
            } else {
                $response = array('success' => true, 'message' => $lang['update-profile-update-error']);
                echo json_encode($response);
            }
            $stmt->close();
        } else {
            $response = array('success' => true, 'message' => 'Error preparing the statement');
            echo json_encode($response);        }

        // Close the database connection
        $conn->close();
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed.'));
    }
}
// Function to validate a phone number
function isValidPhoneNumber($phoneNumber) {
    // Remove any non-digit characters
    $cleanedPhoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

    // Check if the cleaned phone number has a valid length
    if (strlen($cleanedPhoneNumber) < 10 || strlen($cleanedPhoneNumber) > 15) {
        return false;
    }

    // You can add more specific validation rules based on your requirements
    // For example, you may want to check the format, country code, etc.

    return true;
}
// Function to crop an image to a square (1x1 aspect ratio)
function cropToSquare($imagePath) {
    // Determine the image type based on the file extension
    $extension = strtolower(pathinfo($imagePath, PATHINFO_EXTENSION));

    // Load the image based on its type
    switch ($extension) {
        case 'jpg':
        case 'jpeg':
            $image = imagecreatefromjpeg($imagePath);
            break;
        case 'png':
            $image = imagecreatefrompng($imagePath);
            break;
        case 'gif':
            $image = imagecreatefromgif($imagePath);
            break;
        // Add more cases for other image types as needed
        default:
            // Unsupported image type, handle or return an error
            return false;
    }

    if (!$image) {
        // Error loading the image, handle or return an error
        return false;
    }

    $width = imagesx($image);
    $height = imagesy($image);

    // Determine the size of the square crop
    $size = min($width, $height);

    // Calculate the coordinates for the crop
    $x = ($width - $size) / 2;
    $y = ($height - $size) / 2;

    // Create a new square image
    $squareImage = imagecreatetruecolor($size, $size);

    // Perform the crop
    imagecopy($squareImage, $image, 0, 0, $x, $y, $size, $size);

    // Save the cropped image back to the original file path
    switch ($extension) {
        case 'jpg':
        case 'jpeg':
            imagejpeg($squareImage, $imagePath);
            break;
        case 'png':
            imagepng($squareImage, $imagePath);
            break;
        case 'gif':
            imagegif($squareImage, $imagePath);
            break;
        // Add more cases for other image types as needed
    }

    imagedestroy($squareImage);
    imagedestroy($image);

    return true;
}

?>
