<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        include_once includes('config.php');

        // Assuming you have the user's ID stored in the session
        if (isset($_SESSION['user']['id'])) {
            $user_id = $_SESSION['user']['id'];

            // Prepare and execute the SQL query
            $query = "SELECT user_id, username, email, phone_number, profile_picture, name, verification_badge, email_verified, created_at FROM users WHERE user_id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 1) {
                $row = $result->fetch_assoc();

                // Display the user's information
                $user_username = $row['username'];
                $user_email = $row['email'];
                $user_phone_number = $row['phone_number'];
                $user_id_database = $row['user_id'];
                $user_profilePicture = $row['profile_picture'];
                $user_name = $row['name'];
                $user_verificationBadgeStatus = $row['verification_badge'];
                $email_verification_status = $row['email_verified'];
                $created_at = $row['created_at'];

                $userAvatar = getUserAvatar($user_profilePicture, $user_name, $user_username);

                // Check if the user is verified and display the verification badge
                $user_verificationBadge = '';
                if (!empty($user_verificationBadgeStatus)) {
                    $user_verificationBadge = getVerificationBadgeHTML($user_verificationBadgeStatus);
                }

                // You can also send this data as JSON to the frontend if needed
                $response = [
                    'user_username' => $user_username,
                    'user_email' => $user_email,
                    'user_phoneNumber' => $user_phone_number,
                    'user_id' => $user_id_database,
                    'userAvatar' => $userAvatar,
                    'user_name' => $user_name,
                    'user_verificationBadge' => $user_verificationBadge,
                    'email_verification_status' => $email_verification_status,
                    'created_at' => $created_at,
                ];

                echo json_encode($response);
            } else {
                echo json_encode(['error' => 'User not found.']);
            }

            // Close the statement
            $stmt->close();
        } else {
            echo json_encode(['error' => 'User ID not found in the session.']);
        }
    } else {
        // Handle CSRF token validation failure
        echo json_encode(['error' => 'CSRF validation failed.']);
    }
}

function getUserAvatar($profilePicture, $name, $username)
{
    // Check if the profile picture is empty or if it's a Google URL
    if (empty($profilePicture)) {
        // Generate an avatar based on initials
        $avatar = strtoupper(substr($name, 0, 1));

        // Display the avatar
        return '<div class="relative inline-flex items-center justify-center w-24 h-24 mb-3 rounded-full overflow-hidden bg-gray-100 dark:bg-gray-600"><span class="font-medium text-gray-600 dark:text-gray-300">' . $avatar . '</span></div>';
    } else if (strpos($profilePicture, 'https://lh3.googleusercontent.com') !== false){
        // Display the user's profile picture
        return '<img class="relative inline-flex w-24 h-24 mb-3 overflow-hidden rounded-full" src="' . $profilePicture . '" alt="' . htmlspecialchars($username) . ' Profile Picture">';
    }else {
        // Display the user's profile picture
        return '<img class="relative inline-flex w-24 h-24 mb-3 overflow-hidden rounded-full" src="' . asset('uploads/profile_pictures/'.$profilePicture) . '" alt="' . htmlspecialchars($username) . ' Profile Picture">';
    }
}


function getVerificationBadgeHTML($verificationBadgeStatus)
{
    // Generate and return HTML for the verification badge based on the status
    if ($verificationBadgeStatus === 'government') {
        return '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__government-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    }elseif ($verificationBadgeStatus === 'corporation'){
        return '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__corporation-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    }elseif ($verificationBadgeStatus === 'personal'){
        return '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__personal-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    } else {
        return ''; // No verification badge
    }
}
?>
