<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');

        // Check if the database connection was successful
        if (!$conn) {
            $response = array('success' => false, 'message' => 'Database connection failed');
            echo json_encode($response);
            exit;
        }

        // Replace this with your authentication and user role checking logic
        if (!isset($_SESSION['user'])) {
            $response = array('success' => false, 'message' => 'Access denied');
            echo json_encode($response);
            exit;
        }

        $ticket_id = $_POST['ticket_id'];
        $message = $_POST['message'];
        $user_id = $_SESSION['user']['id'];

        // Initialize variables for attachment handling
        $attachment_filename = null;

        // Check if a file was uploaded
        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
            // Specify the destination directory with the full server path
            $uploadDirectory = $_SERVER['DOCUMENT_ROOT'] . '/assets/uploads/support/';

            // Get the original file name and extension
            $originalFilename = $_FILES['attachment']['name'];
            $extension = pathinfo($originalFilename, PATHINFO_EXTENSION);

            // Generate a unique filename for the uploaded file with lowercase extension
            $filename = uniqid() . '.' . strtolower($extension);

            // Move the uploaded file to the specified directory
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadDirectory . $filename)) {
                // File upload was successful, store the attachment details
                $attachment_filename = $filename;
            } else {
                $response = array('success' => false, 'message' => 'Error moving uploaded file');
                echo json_encode($response);
                exit;
            }
        }

        // Insert the message with attachment details into the database
        if (saveMessage($conn, $ticket_id, $user_id, $message, 'client', $attachment_filename)) {
            $response = array('success' => true, 'message' => $lang['support-reply-success']);
        } else {
            $response = array('success' => false, 'message' => $lang['support-reply-error']);
        }

        mysqli_close($conn);

        // Return the JSON response
        echo json_encode($response);
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed.'));
    }
}

// Function to save a message to the support_messages table
function saveMessage($conn, $ticket_id, $user_id, $message, $user_type, $attachment_filename = null) {
    // Check the current status of the ticket
    $checkStatusQuery = "SELECT status FROM support_tickets WHERE id = ?";
    $statusStmt = mysqli_prepare($conn, $checkStatusQuery);
    mysqli_stmt_bind_param($statusStmt, 'i', $ticket_id);
    mysqli_stmt_execute($statusStmt);
    mysqli_stmt_bind_result($statusStmt, $currentStatus);
    mysqli_stmt_fetch($statusStmt);
    mysqli_stmt_close($statusStmt);

    // If the current status is "Closed," update it to "Open"
    if ($currentStatus === 'Closed') {
        $updateStatusQuery = "UPDATE support_tickets SET status = 'Open' WHERE id = ?";
        $updateStatusStmt = mysqli_prepare($conn, $updateStatusQuery);
        mysqli_stmt_bind_param($updateStatusStmt, 'i', $ticket_id);
        mysqli_stmt_execute($updateStatusStmt);
        mysqli_stmt_close($updateStatusStmt);
    }

    // Insert the new message
    $insertMessageQuery = "INSERT INTO support_messages (ticket_id, user_id, message, user_type, attachment_filename) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $insertMessageQuery);

    if (!$stmt) {
        return false; // Handle prepare error
    }

    mysqli_stmt_bind_param($stmt, 'iisss', $ticket_id, $user_id, $message, $user_type, $attachment_filename);

    if (!mysqli_stmt_execute($stmt)) {
        return false; // Handle execute error
    }

    mysqli_stmt_close($stmt);
    return true; // Message successfully inserted
}
?>
