<?php
session_start();

// Include your database configuration file
include_once includes('config.php');

// Check if a user is logged in
if (isset($_SESSION['user']['id'])) {
    $user_id = $_SESSION['user']['id'];

    // Fetch ticket data for the logged-in user from the database
    $query = "SELECT id, subject, status, created_at FROM support_tickets WHERE user_id = ? ORDER BY created_at DESC";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 'i', $user_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (!$result) {
        $response = array('success' => false, 'message' => 'Error fetching tickets');
    } else {
        $tickets = array();
        while ($row = mysqli_fetch_assoc($result)) {
            $tickets[] = $row;
        }
        $response = array('success' => true, 'tickets' => $tickets);
    }

    mysqli_stmt_close($stmt);
} else {
    // User is not logged in
    $response = array('success' => false, 'message' => 'User is not logged in');
}
mysqli_close($conn);

echo json_encode($response);
?>
