<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {

        include_once includes('config.php');

        // Replace this with your authentication and user role checking logic
        if (!isset($_SESSION['user'])) {
            $response = array('success' => false, 'message' => 'Access denied');
            echo json_encode($response);
            exit;
        }

        $ticketId = $_POST['ticket_id']; // You need to pass the ticket ID as a POST parameter

// Fetch ticket details
        $ticketQuery = "SELECT id, subject, status, created_at FROM support_tickets WHERE id = ?";
        $ticketStmt = mysqli_prepare($conn, $ticketQuery);
        mysqli_stmt_bind_param($ticketStmt, 'i', $ticketId);
        mysqli_stmt_execute($ticketStmt);
        mysqli_stmt_bind_result($ticketStmt, $ticketId, $subject, $status, $created_at);
        mysqli_stmt_fetch($ticketStmt);
        mysqli_stmt_close($ticketStmt);

        // Fetch message history with ordering
        $messageQuery = "SELECT message, user_type, attachment_filename, created_at FROM support_messages WHERE ticket_id = ? ORDER BY created_at DESC";
        $messageStmt = mysqli_prepare($conn, $messageQuery);
        mysqli_stmt_bind_param($messageStmt, 'i', $ticketId);
        mysqli_stmt_execute($messageStmt);
        $messageResult = mysqli_stmt_get_result($messageStmt);

        $messages = array();
        while ($row = mysqli_fetch_assoc($messageResult)) {
            $messages[] = $row;
        }

        mysqli_stmt_close($messageStmt);
        mysqli_close($conn);

        $response = array(
            'success' => true,
            'subject' => $subject,
            'status' => $status,
            'created_at' => $created_at,
            'messages' => $messages,
        );

        echo json_encode($response);


    } else {
        // handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}
?>
