<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');

        // Retrieve form data
        $user_id = $_SESSION['user']['id'];
        $name = isset($_POST['name']) ? $_POST['name'] : "";
        $username = isset($_POST['username']) ? $_POST['username'] : "";
        $email = isset($_POST['email']) ? $_POST['email'] : "";
        $phone = isset($_POST['phone-number']) ? $_POST['phone-number'] : "";
        $password = isset($_POST['password']) ? $_POST['password'] : "";
        $confirmPassword = isset($_POST['confirmPassword']) ? $_POST['confirmPassword'] : "";
        $currency = isset($_POST['currency']) ? $_POST['currency'] : "";

        // Validate form data (you should add more thorough validation)
        // ...

        if ($password !== $confirmPassword) {
            echo 'Passwords do not match.';
            exit;
        }

        // Check the connection
        if ($conn->connect_error) {
            die('Connection failed: ' . $conn->connect_error);
        }

        // Initialize an empty array to store the update values and types
        $updateValues = [];
        $updateTypes = "";

        // Build the SQL query dynamically based on the fields that have data
        $query = "UPDATE users SET";

        if (!empty($username)) {
            $query .= " username = ?,";
            $updateValues[] = $username;
            $updateTypes .= "s";
        }

        if (!empty($name)) {
            $query .= " name = ?,";
            $updateValues[] = $name;
            $updateTypes .= "s";
        }

        if (!empty($email)) {
            $query .= " email = ?,";
            $updateValues[] = $email;
            $updateTypes .= "s";
        }

        if (!empty($phone)) {
            $query .= " phone = ?,";
            $updateValues[] = $phone;
            $updateTypes .= "s";
        }

        if (!empty($password)) {
            // You should hash the password for security
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $query .= " password = ?,";
            $updateValues[] = $hashedPassword;
            $updateTypes .= "s";
        }

        if (!empty($currency)) {
            $query .= " currency = ?,";
            $updateValues[] = $currency;
            $updateTypes .= "s";
        }

        // Remove the trailing comma and add the WHERE clause
        $query = rtrim($query, ',') . " WHERE user_id = ?";
        $updateValues[] = $user_id;
        $updateTypes .= "i";

        // Prepare and execute the SQL query
        $stmt = $conn->prepare($query);
        if ($stmt) {
            $stmt->bind_param($updateTypes, ...$updateValues);
            if ($stmt->execute()) {
                $response = array('success' => true, 'message' => 'Profile updated successfully');
                echo json_encode($response);
            } else {
                echo 'Error updating profile: ' . $stmt->error;
            }
            $stmt->close();
        } else {
            echo 'Error preparing the statement.';
        }

        // Close the database connection
        $conn->close();
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed.'));
    }
}

?>
