<?php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');

    $productId = $_POST['product_id'];
    $productDuration = $_POST['product_duration'];
    $userRegion = $_POST['userRegion'];

    // Determine the language (session) and currency (session) settings
    $country = isset($userRegion) ? $userRegion : 'us';
    $currency = isset($_SESSION['currency']) ? strtolower($_SESSION['currency']) : 'usd'; // Ensure currency code is in lowercase
    // Define the columns based on the language and currency settings
    $nameColumn = ($country === 'tr') ? 'name_tr' : 'name';
    $descriptionColumn = ($country === 'tr') ? 'description_tr' : 'description';
    $featuresColumn = ($country === 'tr') ? 'features_tr' : 'features';
    $priceColumn = 'price_' . $currency; // Ensure currency code is in lowercase
    $offerPriceColumn = 'offer_price_' . $currency; // Ensure currency code is in lowercase
    include_once('includes/language/' . $country . '.php');

    // Query to fetch product data
    $query = "SELECT product_id, $nameColumn AS name, $descriptionColumn AS description, $featuresColumn AS features, picture, $priceColumn AS price, $offerPriceColumn AS offerprice, features_icons, category FROM products WHERE product_id = ?";

    // Use prepared statements to prevent SQL injection
    $stmt = mysqli_prepare($conn, $query);

    if ($stmt) {
        // Bind the product_id parameter
        mysqli_stmt_bind_param($stmt, "i", $productId); // Assuming product_id is an integer

        // Execute the prepared statement
        mysqli_stmt_execute($stmt);

        // Get the result set
        $result = mysqli_stmt_get_result($stmt);

        // Fetch the product data
        $product = mysqli_fetch_assoc($result);

        // Close the statement
        mysqli_stmt_close($stmt);

        if ($product) {
            // Add the currency to the product information
            $product['currency'] = getCurrencySign($currency);

            // Calculate yearly price if quantity is 12
            if ($productDuration == 12) {
                $yearlyPriceOriginal = ($product['price']) * 12 * 0.9; // Normal price x12 - 10% discount
                $yearlyPriceOffer = ($product['offerprice']) * 12 * 0.6; // Offer price x12 - 40% discount

                // Add the yearly price to the product information
                $product['price'] = number_format($yearlyPriceOriginal, 2);
                $product['offerprice'] = number_format($yearlyPriceOffer, 2);

                // Append (1 Year) to the product name
                $product['name'] = "<span class='flex items-center'><span>". $product['name'] ."</span><span class='flex items-center justify-center py-0 px-2 ml-3 rounded-full bg-gray-200 dark:bg-dark-500'>".$lang['cart-item-x-year']."</span></span>";
            } else {
                // Append x months to the product name
                $product['name'] ="<span class='flex items-center'><span>". $product['name'] ."</span><span class='flex items-center justify-center py-0 px-2 ml-3 rounded-full bg-gray-200 dark:bg-dark-500'>".$lang['cart-item-x-months']."</span></span>";
            }

            // Product found, return its information
            echo json_encode($product);
        } else {
            // Product not found
            echo json_encode(['error' => 'Product not found']);
        }
    } else {
        // Handle the database query error
        echo json_encode(['error' => 'Failed to prepare and execute the statement: ' . mysqli_error($conn)]);
    }
}

function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'usd' => '$',
        'eur' => '€',
        'gbp' => '£',
        'try' => ' TL', // Added space before the TRY sign
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}
?>
