<?php
// Include your database connection code here
// Example: $conn = new mysqli("localhost", "username", "password", "database");
include_once includes('config.php');

// Check if the request is a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect data from the request
    $name = $_POST['name'];
    $slug = $_POST['slug'];
    $description = $_POST['description'];
    $icon = $_POST['icon'];

    // Perform the SQL insertion
    $query = "INSERT INTO blog_categories (name, slug, description, icon) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssss", $name, $slug, $description, $icon);

    $result = $stmt->execute();

    // Prepare response
    $response = ['success' => $result];

    // Send JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Invalid request method
    http_response_code(405); // Method Not Allowed
    exit();
}
?>
