<?php
include_once includes('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Assuming you have a user authentication system, get the user_id of the logged-in user
    // Assuming you have user authentication in place
    $user_id = $_SESSION['user']['id'];
    $slug = $_POST['slug'];
    $title = $_POST['title'];
    $content = $_POST['content'];
    $language = $_POST['language'];
    $status = $_POST['status'];
    $category = $_POST['category'];

    // New fields for meta title and meta description
    $meta_title = $_POST['meta_title'];
    $meta_description = $_POST['meta_description'];

// Upload main photo and get the file path
    $main_photo = uploadMainPhoto();

    // Insert data into the Blog table with meta title and meta description
    $stmt = $conn->prepare("INSERT INTO blog (slug, title, content, user_id, main_photo, language, category, status, meta_title, meta_description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssissssss", $slug, $title, $content, $user_id, $main_photo, $language, $category, $status, $meta_title, $meta_description);



    if ($stmt->execute()) {
        // Blog post successfully inserted, now handle photo uploads
        $blog_id = $stmt->insert_id;
        uploadPhotos($blog_id);

        echo json_encode(['status' => 'success', 'message' => 'Blog post successfully added.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Error adding blog post.']);
    }

    $stmt->close();
    $conn->close();
}

function uploadMainPhoto() {
    // Specify the destination directory with the full server path
    $uploadDirectory = $_SERVER['DOCUMENT_ROOT'] . '/assets/uploads/blog/';

    // Get the original file name and extension
    $originalFilename = $_FILES['main_photo']['name'];

    // Generate a unique filename for the uploaded file while keeping the original name
    $filename = uniqid() . '_' . $originalFilename;

    // Move the uploaded file to the specified directory
    if (move_uploaded_file($_FILES['main_photo']['tmp_name'], $uploadDirectory . $filename)) {
        // File upload was successful, return only the filename
        return $filename;
    } else {
        $response = array('success' => false, 'message' => 'Error uploading main photo.');
        echo json_encode($response);
        exit;
    }
}

function uploadPhotos($blog_id) {
    // Implement your logic to handle additional photo uploads and save to the Photos table
    // Adjust this based on your actual form structure and field names
    // Example:
    // foreach ($_FILES['additional_photos']['tmp_name'] as $key => $tmp_name) {
    //     move_uploaded_file($tmp_name, 'path/to/uploaded/photos/photo_' . $key . '.jpg');
    //     $photo_path = 'path/to/uploaded/photos/photo_' . $key . '.jpg';
    //     $is_main = ($key === 0) ? 1 : 0;
    //     $stmt = $conn->prepare("INSERT INTO Photos (blog_id, photo_path, is_main) VALUES (?, ?, ?)");
    //     $stmt->bind_param("iss", $blog_id, $photo_path, $is_main);
    //     $stmt->execute();
    //     $stmt->close();
    // }
}
?>
