<?php
session_start();

// Include database configuration
include_once includes('config.php');

// Set response headers
header('Content-Type: application/json');

// Initialize response array
$response = ['success' => false, 'message' => '', 'data' => []];

try {
    // Ensure user is logged in
    if (!isset($_SESSION['user']['id'])) {
        throw new Exception('User not authenticated');
    }

    // Prepare SQL query
    $query = "SELECT recipient, message, status, created_at 
              FROM sms_logs 
              WHERE user_id = ? 
              ORDER BY created_at DESC 
              LIMIT 5";

    $stmt = mysqli_prepare($conn, $query);

    if (!$stmt) {
        throw new Exception('Error preparing query');
    }

    // Bind user ID
    mysqli_stmt_bind_param($stmt, "i", $_SESSION['user']['id']);

    // Execute query
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception('Error executing query');
    }

    // Get result
    $result = mysqli_stmt_get_result($stmt);

    if (!$result) {
        throw new Exception('Error fetching SMS logs');
    }

    // Fetch data
    $recentSms = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $recentSms[] = $row;
    }

    // Close statement
    mysqli_stmt_close($stmt);

    // Successful response
    $response = [
        'success' => true,
        'data' => $recentSms,
        'count' => count($recentSms)
    ];
} catch (Exception $e) {
    // Log error
    error_log('SMS log error: ' . $e->getMessage());

    // Error response
    $response['message'] = 'An error occurred while fetching SMS logs';
}

// Close DB connection
mysqli_close($conn);

// Return JSON response
echo json_encode($response);
exit;
