<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Correct include syntax - FIXED from includes() to include_once
include_once includes('config.php');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

// Initialize response
$response = ['success' => false, 'message' => ''];

try {
    // Verify POST request
    if ($_SERVER["REQUEST_METHOD"] != "POST") {
        throw new Exception('Invalid request method');
    }

    // Verify CSRF token
    if (!function_exists('is_csrf_valid') || !is_csrf_valid()) {
        throw new Exception('Invalid CSRF token');
    }

    // Verify required fields
    $required = ['phone-number', 'message-type', 'message'];
    foreach ($required as $field) {
        if (!isset($_POST[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }

    // Sanitize inputs
    $userPhoneNumber = trim($_POST["phone-number"]);
    $messageType = trim($_POST["message-type"]);
    $message = trim($_POST["message"]);

    // Validate phone number
    if (!preg_match('/^[0-9]{11,15}$/', $userPhoneNumber)) {
        throw new Exception('Invalid phone number format');
    }

    // Validate message
    if (empty($message)) {
        throw new Exception('Message cannot be empty');
    }

    // Initialize SOAP client
    try {
        $SOAP = new SoapClient("http://panel.vatansms.com/webservis/service.php?wsdl", [
            "trace" => 1,
            "exceptions" => 0,
            "connection_timeout" => 10
        ]);
    } catch (Exception $e) {
        throw new Exception('SOAP connection failed: ' . $e->getMessage());
    }

    // SMS API credentials
    $MUSTERINO = '44168';
    $KULLANICIADI = '905382244717';
    $SIFRE = '17GPbC47';
    $ORGINATOR = 'DATANITO';
    $TUR = ($messageType == "tr") ? 'Turkce' : 'Normal';
    $mesaj1 = $message;
    $ZAMAN = '';
    $ZAMANASIMI = '';
    $nu1 = $userPhoneNumber;
    $paraNU_ME = '{['.$nu1.']['.$mesaj1.']}';

    // Send SMS
    $result = $SOAP->HerBirNumarayaFarkliSmsGonder(
        $MUSTERINO,
        $KULLANICIADI,
        $SIFRE,
        $ORGINATOR,
        $paraNU_ME,
        $ZAMAN,
        $ZAMANASIMI,
        $TUR
    );

    // Debug output
    error_log("Full SOAP Response: " . print_r($result, true));

    // NEW: Handle string response directly
    if (is_string($result)) {
        $responseParts = explode(':', $result);

        if (count($responseParts) >= 3 && $responseParts[0] === 'OK' && $responseParts[2] === 'Gonderildi') {
            $response['success'] = true;
            $response['message'] = 'SMS sent successfully';
            $response['sms_id'] = $responseParts[1];
            $response['credit_used'] = $responseParts[4] ?? null;

            // Log success if DB available
            @logSms($userPhoneNumber, $message, 'delivered', $result, $conn);
        } else {
            throw new Exception('SMS sending failed: ' . $result);
        }
    }
    // Handle object response if needed
    elseif (is_object($result) && isset($result->HerBirNumarayaFarkliSmsGonderResult)) {
        $apiResponse = $result->HerBirNumarayaFarkliSmsGonderResult;

        if (is_string($apiResponse)) {
            $responseParts = explode(':', $apiResponse);

            if (count($responseParts) >= 3 && $responseParts[0] === 'OK' && $responseParts[2] === 'Gonderildi') {
                $response['success'] = true;
                $response['message'] = 'SMS sent successfully';
                $response['sms_id'] = $responseParts[1];
                @logSms($userPhoneNumber, $message, 'delivered', $apiResponse, $conn);
            } else {
                throw new Exception('SMS sending failed: ' . $apiResponse);
            }
        } elseif (is_object($apiResponse) && property_exists($apiResponse, 'Mesaj')) {
            $messageResponse = $apiResponse->Mesaj;
            if (stripos($messageResponse, 'success') !== false || stripos($messageResponse, 'başarılı') !== false) {
                $response['success'] = true;
                $response['message'] = 'SMS sent successfully';
                @logSms($userPhoneNumber, $message, 'delivered', $messageResponse, $conn);
            } else {
                throw new Exception('SMS service reported: ' . $messageResponse);
            }
        } else {
            throw new Exception('Unexpected API response format');
        }
    } else {
        throw new Exception('Invalid response from SMS service: ' . gettype($result));
    }

} catch (Exception $e) {
    error_log('SMS Error: ' . $e->getMessage());
    $response['message'] = $e->getMessage();

    // Attempt to log failure (silently fail if DB issues)
    if (isset($userPhoneNumber) && isset($message)) {
        @logSms($userPhoneNumber, $message, 'failed', $e->getMessage(), $conn);
    }
}

echo json_encode($response);
exit;

function logSms($recipient, $message, $status, $apiResponse = null, $conn) {
    try {
        session_start(); // Ensure session is started


        $userId = $_SESSION['user']['id'];
        $messageType = $_POST['message-type'] ?? 'normal';

        $query = "INSERT INTO sms_logs 
                 (user_id, recipient, message, message_type, status, api_response, created_at) 
                 VALUES (?, ?, ?, ?, ?, ?, NOW())";

        $stmt = $conn->prepare($query);
        return $stmt->execute([$userId, $recipient, $message, $messageType, $status, $apiResponse]);

    } catch (PDOException $e) {
        error_log('Database error in logSms: ' . $e->getMessage());
        return false;
    }
}
