<?php
session_start();

// Include your database configuration file
include_once includes('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        // Replace this with your authentication and user role checking logic
        if (!isset($_SESSION['user'])) {
            $response = array('success' => false, 'message' => 'Access denied');
            echo json_encode($response);
            exit;
        }

        $ticketId = $_POST['ticket_id'];
        $newStatus = $_POST['new_status'];

        // Update the ticket status in the database
        $updateQuery = "UPDATE support_tickets SET status = ? WHERE id = ?";
        $stmt = mysqli_prepare($conn, $updateQuery);
        mysqli_stmt_bind_param($stmt, 'si', $newStatus, $ticketId);

        if (mysqli_stmt_execute($stmt)) {
            $response = array('success' => true, 'message' => 'Status updated successfully');
        } else {
            $response = array('success' => false, 'message' => 'Error updating status: ' . mysqli_error($conn));
        }

        mysqli_stmt_close($stmt);
        mysqli_close($conn);

        echo json_encode($response);
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed'));
    }
}
?>
