<?php


session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {

        include_once includes('config.php');

        // Process the login request
        if (isset($_POST['email']) && isset($_POST['password'])) {
            // Process the login request
            // Prepare the SQL statement with a placeholder for the email value
            $email = trim($_POST['email']);
            $password = trim($_POST['password']);
            $sql = "SELECT * FROM `users` WHERE email = ?";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "s", $email);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);

            if (mysqli_num_rows($result) == 1) {
                $row = mysqli_fetch_assoc($result);
                if (password_verify($password, $row['password'])) {
                    // Password is correct
                    $_SESSION['user']['id'] = $row['user_id'];
                    $_SESSION['userLoggedIn'] = true;

                    // Set a cookie to remember the user
                    $token = generateToken();
                    $expires_at = date('Y-m-d H:i:s', strtotime('+30 days')); // Token expiration set to 30 days from now
                    saveTokenInDatabase($row['user_id'], $token, $expires_at, $conn);
                    setcookie('remember_token', $token, time() + (60 * 60 * 24 * 30), '/'); // Cookie expires in 30 days
                    
                    if (isset($_SESSION['intended_destination'])) {
                        // Redirect the user back to the intended destination (checkout page)
                        $redirectDestination = $_SESSION['intended_destination'];
                    }
                    $response = array('status' => 'success', 'message' => $lang['user-login-success-message'], 'icon' => 'Check icon', 'redirect' => $redirectDestination);
                    unset($_SESSION['intended_destination']); // Clear the intended destination after saving it
                    echo json_encode($response);
                } else {
                    // Password is incorrect
                    $response = array('status' => 'error', 'message' => $lang['user-login-failed-message']);
                    echo json_encode($response);
                }
            } else {
                // User not found
                $response = array('status' => 'error', 'message' => $lang['user-login-failed-message']);
                echo json_encode($response);
            }

        }

        // Process the email submission request
        if (isset($_POST['email']) && $_POST['action'] == 'validate_email') {
            $email = $_POST['email'];
            // You can perform additional validation here before storing the email
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $response = array('status' => 'error', 'message' => $lang['user-login-failed-email-message']);
            } else {
                $response = array('status' => 'success');
            }
            echo json_encode($response);
        }

        // Close the database connection
        mysqli_close($conn);

    } else {
        // handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}
function generateToken() {
    return bin2hex(random_bytes(32)); // Generates a 64-character hexadecimal string
}
function saveTokenInDatabase($user_id, $token, $expires_at, $conn) {

    $sql = "INSERT INTO remember_me_tokens (user_id, token, expires_at) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "iss", $user_id, $token, $expires_at);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

function getVerificationEmailContent($verificationLink, $userName, $lang) {
    $htmlContent = file_get_contents(includes('emails/system_email.php'));

    // Replace placeholders with dynamic content
    $replacements = [
        '{{cta-link}}' => $verificationLink,
        '{{user-name}}' => $userName,
        '{{headline}}' => $lang['email-verification-headline'],
        '{{email-p1}}' => $lang['email-verification-instructions'],
        '{{cta}}' => $lang['email-verification-cta'],
        '{{email-p2}}' => $lang['email-verification-instructions-p2'],
        '{{email-p3}}' => '',

        // Language-specific replacements
        '{{hello}}' => $lang['email-hello'] ?? '',
        '{{email-copyright}}' => $lang['email-copyright'] ?? '',
        '{{best-regards}}' => $lang['best-regards'] ?? 'Best regards',
        '{{company-team}}' => $lang['company-team'] ?? 'The Datanito Team',
        '{{home}}' => $lang['email-home'] ?? 'Home',
        '{{about}}' => $lang['email-about'] ?? 'About',
        '{{products}}' => $lang['email-ai'] ?? 'Datanito AI',
        '{{contact}}' => $lang['email-contact'] ?? 'Contact',
        '{{privacy}}' => $lang['email-privacy'] ?? 'Privacy',
        '{{company-name}}' => $lang['company-name'] ?? 'Datanito Ltd.',
        '{{company-tagline}}' => $lang['company-tagline'] ?? 'Leading AI-Powered Software and Payment Solutions'
    ];

    foreach ($replacements as $placeholder => $value) {
        $htmlContent = str_replace($placeholder, $value, $htmlContent);
    }

    return $htmlContent;
}

?>
