<?php
// Start the session
session_start();
include_once includes('config.php');

// Unset specific session variables related to login
unset($_SESSION['user']['id']);
unset($_SESSION['user_email']);
unset($_SESSION['user_username']);
unset($_SESSION['user_name']);
unset($_SESSION['user_profile_picture']);
unset($_SESSION['userLoggedIn']);

// Destroy the session
session_destroy();


// Retrieve the token from the cookie
$token = $_COOKIE['remember_token'];

// Delete the token from the database
deleteTokenFromDatabase($token, $conn);

// Expire the remember me cookie by setting its expiration time in the past
setcookie('remember_token', '', time() - 3600, '/'); // Set expiry time in the past

function deleteTokenFromDatabase($token, $conn) {
    // Prepare and execute the SQL query to delete the token
    $sql = "DELETE FROM remember_me_tokens WHERE token = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $token);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}
?>
