<?php
// Include necessary files and configurations
include_once includes('config.php');

// Function to fetch blog posts with author information based on user's country and post status
function getBlogBySlug($slug, $conn) {
    // Perform SQL query to retrieve blog posts with author information
    $query = "
        SELECT b.*, u.user_id as author_id, u.name as author_name, u.verification_badge as author_verification_badge, u.profile_picture as author_avatar
        FROM blog b
        INNER JOIN users u ON b.user_id = u.user_id
        WHERE b.slug = ? AND b.status = 'published'";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result) {
        // Fetch the results as an associative array
        $blogPost = $result->fetch_assoc();

        // Check if the blog post was found
        if ($blogPost) {
            // Add verification badge HTML
            $authorVerificationBadgeStatus = $blogPost['author_verification_badge'];
            $blogPost['author_verification_badge_html'] = getVerificationBadgeHTML($authorVerificationBadgeStatus);
            // Add other modifications as needed
            $post['short_content'] = mb_substr(strip_tags($blogPost['content']), 0, 200);
            // ... (other modifications)

            return $blogPost;
        }
    }

    // Return null if blog post not found or an error occurred
    return null;
}
// Function to fetch related articles by category and title
function getRelatedArticles($category, $blogId, $language, $conn) {
    // Perform SQL query to retrieve related articles
    $query = "
        SELECT b.*, u.name as author_name, u.profile_picture as author_avatar
        FROM blog b
        INNER JOIN users u ON b.user_id = u.user_id
        WHERE b.category = ? AND b.blog_id != ? AND b.status = 'published' AND b.language = ?
        ORDER BY RAND()  -- Order randomly to add variety to the suggestions
        LIMIT 4";  // Adjust the limit as needed

    $stmt = $conn->prepare($query);
    $stmt->bind_param("sss", $category, $blogId, $language);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result) {
        // Fetch the results as an associative array
        $relatedArticles = $result->fetch_all(MYSQLI_ASSOC);

        // Check if the blog posts were found
        if ($relatedArticles) {
            // Iterate through each related article and make modifications
            foreach ($relatedArticles as &$relatedArticle) {
                // Add verification badge HTML
                $authorVerificationBadgeStatus = $relatedArticle['author_verification_badge'];
                $relatedArticle['author_verification_badge_html'] = getVerificationBadgeHTML($authorVerificationBadgeStatus);
                // Add other modifications as needed
                $relatedArticle['short_content'] = substr(strip_tags($relatedArticle['content']), 0, 200);
            }

            return $relatedArticles;
        }
    }

    // Return an empty array if no related articles found or an error occurred
    return array();
}


// Function to get verification badge HTML based on verification status
function getVerificationBadgeHTML($verificationBadgeStatus) {
    $verificationBadge = '';

    if (!empty($verificationBadgeStatus)) {
        // Display the verification badge and type
        if ($verificationBadgeStatus === 'government') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__government-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        } elseif ($verificationBadgeStatus === 'corporation') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__corporation-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        } elseif ($verificationBadgeStatus === 'personal') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__personal-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        }
    }

    return $verificationBadge;
}

$slug = isset($_POST['slug']) ? $_POST['slug'] : '';

// Get blog post based on slug
$blogPost = getBlogBySlug($slug, $conn);

// Return the blog post as JSON
header('Content-Type: application/json');
if ($blogPost) {
    // Fetch related articles based on category and title
    $relatedArticles = getRelatedArticles($blogPost['category'], $blogPost['blog_id'], $blogPost['language'], $conn);

    // Combine blog post and related articles in the response
    $response = array(
        'blogPost' => $blogPost,
        'relatedArticles' => $relatedArticles,
    );

    echo json_encode($response);
} else {
    // Return an empty response or handle the error as needed
    echo json_encode(array());
}
?>
