<?php
include_once includes('config.php');

if (!isset($_SESSION['user']['id'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$user_id = $_SESSION['user']['id'];
$orderNumber = $_POST['orderNumber'];

if (empty($orderNumber)) {
    die(json_encode(['error' => 'Order number required']));
}

function getUsername($orderNumber, $user_id, $conn) {
    $stmt = $conn->prepare("SELECT username FROM hosting_orders WHERE user_id = ? AND order_number = ?");
    $stmt->bind_param("is", $user_id, $orderNumber);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc()['username'];
}

$cpanel_user = getUsername($orderNumber, $user_id, $conn);

if (!$cpanel_user) {
    die(json_encode(['error' => 'Account not found']));
}

// Create cPanel session
$query = "https://$whm_host:2087/json-api/create_user_session?api.version=1&user=$cpanel_user&service=cpaneld";

$curl = curl_init();
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$header = ["Authorization: Basic " . base64_encode("$whm_user:$whm_pass")];
curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
curl_setopt($curl, CURLOPT_URL, $query);
$result = curl_exec($curl);

if ($result === false) {
    die(json_encode(['error' => curl_error($curl)]));
}

$response = json_decode($result, true);

if (!isset($response['data']['url'])) {
    die(json_encode(['error' => 'Failed to create session']));
}

// Log activity
$stmt = $conn->prepare("INSERT INTO hosting_activity (user_id, action, description) VALUES (?, ?, ?)");
$action = "cpanel_login";
$description = "Logged into cPanel";
$stmt->bind_param("iss", $user_id, $action, $description);
$stmt->execute();

echo json_encode(['url' => $response['data']['url']]);
?>