<?php

include_once includes('config.php');

// Function to retrieve a list of accounts
function listAccounts() {
    global $whm_host, $whm_user, $whm_pass;

    // Construct the request URL
    $request_url = "https://$whm_host:2087/json-api/listaccts?api.version=1";

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $request_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // You may need to adjust this option based on your server's SSL configuration
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_USERPWD, "$whm_user:$whm_pass");

    // Execute the cURL request
    $response = curl_exec($ch);

    // Check for errors
    if(curl_error($ch)) {
        echo 'Error: ' . curl_error($ch);
        return false;
    }

    // Close cURL session
    curl_close($ch);

    // Decode JSON response
    $accounts = json_decode($response, true);

    return $accounts['data']['acct'];
}

// Function to suspend an account
function suspendAccount($username) {
    global $whm_host, $whm_user, $whm_pass;

    // Construct the request URL
    $request_url = "https://$whm_host:2087/json-api/suspendacct?api.version=1&user=$username";

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $request_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // You may need to adjust this option based on your server's SSL configuration
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_USERPWD, "$whm_user:$whm_pass");

    // Execute the cURL request
    $response = curl_exec($ch);

    // Check for errors
    if(curl_error($ch)) {
        echo 'Error: ' . curl_error($ch);
        return false;
    }

    // Close cURL session
    curl_close($ch);

    // Output the response
    echo $response;

    return true;
}

// Retrieve a list of accounts
$accounts = listAccounts();

// Check each account for overdue status and suspend if necessary
foreach ($accounts as $account) {
    // Check if the account is overdue (replace this condition with your logic)
    if ($account['suspended'] === '0' && $account['diskusedpercent'] > 90) { // Example condition: suspend if disk usage is over 90%
        // Suspend the account
        suspendAccount($account['user']);
    }
}

?>
