<?php
include_once includes('config.php');

// Assuming you have a user_id variable to search for a specific user
$user_id = $_SESSION['user']['id'];

// Fetch conversations with last_message_date
$sql = "SELECT c.conversation_id, c.conversation_name, MAX(m.created_at) as last_message_date
        FROM dino_conversations c
        LEFT JOIN dino_messages m ON c.conversation_id = m.conversation_id
        WHERE c.user_id = ?
        GROUP BY c.conversation_id, c.conversation_name
        ORDER BY last_message_date DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$conversations = [];

while ($row = $result->fetch_assoc()) {
    $conversations[] = [
        'id' => $row['conversation_id'],
        'name' => $row['conversation_name'],
        'last_message_date' => $row['last_message_date']
    ];
}

// Return conversations as JSON
echo json_encode($conversations);

?>
