<?php
include_once includes('config.php');

if (isset($_POST['id'])) {
    $conversationId = $_POST['id'];

    // Validate if the conversation ID is a valid UUID
    if (!isValidUUID($conversationId)) {
        echo json_encode(['error' => 'Invalid conversation ID format.']);
        exit();
    }

    // Fetch messages from the database based on the conversation ID
    $messages = getConversationMessages($conversationId, $conn);

    // Return messages as JSON
    header('Content-Type: application/json');
    echo json_encode($messages);
} else {
    // Handle the case when id is not set
    echo json_encode(['error' => 'Conversation ID is not set.']);
}

function isValidUUID($uuid) {
    // Use a regular expression to validate UUID format
    $uuidPattern = '/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/';
    return preg_match($uuidPattern, $uuid);
}

function getConversationMessages($conversationId, $conn) {
    $query = "SELECT role, content, attachment_filename FROM dino_messages 
              WHERE conversation_id = ? 
              ORDER BY created_at ASC";

    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "s", $conversationId); // Use "s" for string (UUID)
    mysqli_stmt_execute($stmt);

    $result = mysqli_stmt_get_result($stmt);
    $messages = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $messages[] = ['role' => $row['role'], 'content' => $row['content'], 'attachment_filename' => $row['attachment_filename']];
    }

    mysqli_stmt_close($stmt);

    return $messages;
}
?>
