<?php
// Include the necessary library
include_once includes('domain/dna.php');
include_once includes('config.php');

// Start or resume the session
session_start();
$currencySymbols = array(
    'USD' => '$', // US Dollar
    'EUR' => '€', // Euro
    'TL' => 'TL', // Turkish Lira
);
if (isset($_POST['userInput'])) {
    // Process the user input and check domain availability as before
    $userInput = $_POST['userInput'];

    // Save the user input to session history only if it's not a duplicate
    if (!isset($_SESSION['search_history'])) {
        $_SESSION['search_history'] = array();
    }

    // Check if the user input is not already in the history
    if (!in_array($userInput, $_SESSION['search_history'])) {
        // Add the user input to the history array
        $_SESSION['search_history'][] = $userInput;
    }
}

// Function to display domain information
function displayDomainInfo($domainName, $tld, $status, $normalPrice, $renderPrice, $currency, $lang, $increasedPrice, $checkoutPrice, $currencySymbol, $brokerPriceRender, $brokerPrice) {
    global $currencySymbols;
    $isFavorite = false;
    foreach ($_SESSION['favorite_domains'] ?? array() as $favoriteDomain) {
        if ($favoriteDomain['domain'] === $domainName && $favoriteDomain['tld'] === $tld) {
            $isFavorite = true;
            break;
        }
    }

    echo "<div class='block md:flex justify-between items-center mb-3 py-3 px-5 space-y-4 md:space-y-0 md:h-20 bg-white border border-gray-200 rounded-3xl hover:bg-gray-100 dark:bg-dark-700 dark:border-dark-600 dark:hover:bg-dark-700'>";
    echo "<span class='flex items-center'>";

    echo "<span class='flex items-center justify-start mr-4 font-bold cursor-pointer favorite-icon' data-offer-price='$checkoutPrice' data-price='$increasedPrice' data-domain='$domainName' data-tld='$tld' data-status='$status' data-render-price='$renderPrice' data-normal-price='$normalPrice' data-currency='$currencySymbol' data-quantity='1'>";
    echo "<svg class='w-5 h-5 " . ($isFavorite ? "text-red-600 fill-red-600" : "text-dark-600 fill-white dark:text-white dark:fill-dark-900") . "' aria-hidden='true' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 21 19'>";
    echo "<path stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M11 4C5.5-1.5-1.5 5.5 4 11l7 7 7-7c5.458-5.458-1.542-12.458-7-7Z'/>";
    echo "</svg>";
    echo "</span>";


    if ($status === 'available') {
        echo "<span class='space-y-2 md:space-y-4'>";
        echo "<span class='flex items-center justify-start font-bold'>$domainName<span class='text-green-600'>.$tld</span></span>";
        echo "<span class='flex items-center md:hidden'>";
        echo "<span class='block md:hidden text-sm font-medium text-gray-900 line-through dark:text-white mr-2'>$normalPrice</span>";
        echo "<span class='block md:hidden text-lg text-gray-700 mr-4 font-semibold dark:text-white'>$renderPrice</span>";
        echo "</span>";
        echo "</span>";
        echo "</span>";
        echo "<span class='hidden md:flex items-center space-x-4 justify-end'>";
        echo "<span class='block'>";
        echo "<span class='hidden md:block text-sm font-medium text-gray-800 line-through dark:text-gray-200 dark:text-white'>$normalPrice</span>";
        echo "<span class='hidden md:block text-lg text-gray-700 mr-4 dark:text-white font-semibold dark:text-white'>$renderPrice</span>";
        echo "</span>";
        echo "<button data-offer-price='$checkoutPrice' data-price='$increasedPrice' data-currency='$currencySymbol' data-product-id='16' data-domain='$domainName' data-tld='$tld' data-quantity='1' class='add-to-cart-btn-domain w-[9em] hidden md:flex items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-200 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-700'>
                  <span>
                  <svg aria-hidden='true' class='w-6 h-6 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden' viewBox='0 0 100 101' fill='none' xmlns='http://www.w3.org/2000/svg'>
                     <path d='M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z' fill='currentColor'/>
                     <path d='M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z' fill='currentFill'/>
                  </svg>
                  <span class='sr-only'>Loading...</span>
                  </span>
                  <span class='add-to-cart-cta'>". $lang['domain-register-cta'] ."</span>
                  </button>";
        echo "</span>";
        echo "<span class='flex items-center justify-end md:hidden'>
                <button data-offer-price='$checkoutPrice' data-price='$increasedPrice' data-currency='$currencySymbol' data-product-id='16' data-domain='$domainName' data-tld='$tld' data-quantity='1' class='add-to-cart-btn-domain w-[9em] flex items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-500 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-700'>
                  <span>
                  <svg aria-hidden='true' class='w-5 h-5 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden' viewBox='0 0 100 101' fill='none' xmlns='http://www.w3.org/2000/svg'>
                     <path d='M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z' fill='currentColor'/>
                     <path d='M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z' fill='currentFill'/>
                  </svg>
                  <span class='sr-only'>Loading...</span>
                  </span>
                  <span class='add-to-cart-cta'>". $lang['domain-register-cta'] ."</span>
                  </button>
                </span>";
    } else {
        echo "<span class='space-y-4'>";
        echo "<span class='block text-left'>";
        echo "<p class='font-bold text-sm md:text-lg text-gray-600 dark:text-gray-300'>$domainName.$tld ".$lang["domain-is-taken"]."</p>";
        echo "<p class='font-semibold text-xs md:text-sm text-gray-600 dark:text-gray-300'>".$lang["domain-is-taken-subheading"];
        echo "<button type='button' data-modal-target='broker-guide-modal' data-modal-toggle='broker-guide-modal' data-domain='$domainName' data-tld='$tld' class='btn-open-modal cursor-pointer text-xs md:text-sm tracking-tight font-medium text-blue-600 dark:text-blue-400 dark:text-blue-500 hover:underline'>".$lang['broker-service-guide-cta']."</button>";
        echo "</p>";
        echo "</span>";
        echo "<span class='flex md:hidden text-xs md:text-sm text-gray-700 font-medium text-gray-700 mr-2 font-semibold dark:text-white'><img class='w-10 h-10 md:w-12 md:h-12 rounded-full mr-1.5' src='".asset('images/content/domain-broker-agent.jpg')."' alt='Domain Broker Agent'><span class='text-left'><p>".$brokerPriceRender."</p> <p class='flex items-center justify-start text-center text-sm md:text-lg text-gray-700 font-semibold dark:text-white'>".$lang['broker-service-fee-price']."<button type='button' data-modal-target='broker-guide-modal' data-modal-toggle='broker-guide-modal' data-domain='$domainName' data-tld='$tld' class='btn-open-modal ml-0.5'><svg class='w-4 h-4 text-gray-400 hover:text-gray-500' aria-hidden='true' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-3a1 1 0 00-.867.5 1 1 0 11-1.731-1A3 3 0 0113 8a3.001 3.001 0 01-2 2.83V11a1 1 0 11-2 0v-1a1 1 0 011-1 1 1 0 100-2zm0 8a1 1 0 100-2 1 1 0 000 2z' clip-rule='evenodd'></path></svg><span class='sr-only'>Show Information</span></button></p></span></span>";
        echo "</span></span>";
        echo "<span class='hidden md:flex items-center space-x-4 justify-end'>";
        echo "<span class='hidden md:flex text-xs md:text-sm text-gray-700 font-medium text-gray-700 mr-2 font-semibold dark:text-white'><span class='text-right mr-2'><p>".$lang['broker-service-fee']."</p> <p class='flex items-center justify-end text-center text-sm md:text-lg text-gray-700 font-semibold dark:text-white'>".$brokerPriceRender."<button type='button' data-modal-target='broker-guide-modal' data-modal-toggle='broker-guide-modal' data-domain='$domainName' data-tld='$tld' class='btn-open-modal ml-0.5'><svg class='w-4 h-4 text-gray-400 hover:text-gray-500' aria-hidden='true' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-3a1 1 0 00-.867.5 1 1 0 11-1.731-1A3 3 0 0113 8a3.001 3.001 0 01-2 2.83V11a1 1 0 11-2 0v-1a1 1 0 011-1 1 1 0 100-2zm0 8a1 1 0 100-2 1 1 0 000 2z' clip-rule='evenodd'></path></svg><span class='sr-only'>Show Information</span></button></p></span><img class='w-10 h-10 md:w-12 md:h-12 rounded-full mr-4' src='".asset('images/content/domain-broker-agent.jpg')."' alt='Domain Broker Agent'></span>";
        echo "<button data-domain='$domainName' data-tld='$tld' data-product-id='11' class='add-to-cart-btn w-[9em] hidden md:flex items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-dark-900 hover:bg-dark-800 focus:ring-4 focus:ring-blue-200 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-900'>
                  <span class='flex items-center justify-center'>
                  <svg aria-hidden='true' class='w-6 h-6 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden' viewBox='0 0 100 101' fill='none' xmlns='http://www.w3.org/2000/svg'>
                     <path d='M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z' fill='currentColor'/>
                     <path d='M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z' fill='currentFill'/>
                  </svg>
                  <span class='sr-only'>Loading...</span>
                  </span>
                  <span class='add-to-cart-cta'>". $lang['broker-service-cta'] ."</span>
                  </button>";
        echo "</span>";
        echo "<span class='flex items-center justify-end md:hidden'>
                <button data-domain='$domainName' data-tld='$tld' data-product-id='11' class='add-to-cart-btn w-[9em] items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-dark-900 hover:bg-dark-800 focus:ring-4 focus:ring-blue-200 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-900'>
                  <span class='flex items-center justify-center'>
                  <svg aria-hidden='true' class='w-5 h-5 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden' viewBox='0 0 100 101' fill='none' xmlns='http://www.w3.org/2000/svg'>
                     <path d='M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z' fill='currentColor'/>
                     <path d='M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z' fill='currentFill'/>
                  </svg>
                  <span class='sr-only'>Loading...</span>
                  </span>
                  <span class='add-to-cart-cta'>". $lang['broker-service-cta'] ."</span>
                  </button>
                </span>";    }

    echo "</div>";
}

if (isset($_POST['userInput'])) {
    $username = 'datanito';
    $password = 'at*rF2h@6gC.W#k';
    $dna = new \DomainNameApi\DomainNameAPI_PHPLibrary($username, $password);

    $userInput = $_POST['userInput'];

    $supportedTLDs = array(
        'com', 'net', 'org', 'site', 'tr','com.tr', 'store', 'shop', 'app', 'co', 'blog', 'xyz', 'tech', 'online',
        'website', 'space', 'design', 'dev', 'me', 'info',
        'us', 'ca', 'uk', 'au', 'in', 'eu', 'de', 'fr', 'it', 'es', 'nl', 'ch',
        'ru', 'jp', 'cn', 'web.tr', 'edu.tr', 'gov.tr'
        // Add more TLDs here
    );
    foreach ($supportedTLDs as $tld) {
        $userInput = str_replace('.' . $tld, '', $userInput);
    }

    // Determine the input TLD and user input without TLD
    $inputTLD = '';
    $userInputParts = explode('.', $userInput); // Split user input by dot
    if (count($userInputParts) > 1) {
        $inputTLD = $userInputParts[count($userInputParts) - 1]; // Get the last part as potential TLD
        if (in_array($inputTLD, $supportedTLDs)) {
            // Use the user-provided TLD if it's supported
            $tlds = [$inputTLD];
            $userInput = str_replace("." . $inputTLD, '', $userInput); // Remove TLD from user input
        } else {
            // Invalid TLD, reset inputTLD and use all supported TLDs for checking
            $inputTLD = '';
            $tlds = $supportedTLDs;
        }
    } else {
        // Use all supported TLDs for checking
        $tlds = $supportedTLDs;
    }

    // Check availability
    $result = $dna->CheckAvailability([$userInput], $tlds, 1, 'create');
// Sort the results by TLDs, putting the searched TLD at the beginning
    $sortedResults = [];

// First, add the results for the user's input TLD to the sorted results
    foreach ($result as $domainInfo) {
        if ($domainInfo['TLD'] === $inputTLD) {
            $sortedResults[] = $domainInfo;
        }
    }

// Then, add the rest of the results
    foreach ($tlds as $tld) {
        if ($tld !== $inputTLD) {
            foreach ($result as $domainInfo) {
                if ($domainInfo['TLD'] === $tld) {
                    $sortedResults[] = $domainInfo;
                }
            }
        }
    }

    // Display sorted results
    foreach ($sortedResults as $domainInfo) {
        $tld = $domainInfo['TLD'];
        $domainName = $domainInfo['DomainName'];
        $status = $domainInfo['Status'];
        $priceWithDecimal = $domainInfo['Price'];
        $currency = $domainInfo['Currency'];

        // Convert price based on conditions
        if ($currentCurrency === 'TRY' && $currency === 'TL') {
            $price = round($priceWithDecimal, 2);
            $currencySymbol = getCurrencySign($currentCurrency);
        } elseif ($currentCurrency === 'TRY' && $currency === 'USD') {
            $price = round($priceWithDecimal * $conversionRate, 2);
            $currencySymbol = getCurrencySign($currentCurrency);
        } elseif ($currentCurrency === 'USD' && $currency === 'USD') {
            $price = round($priceWithDecimal * $conversionRate, 2);
            $currencySymbol = getCurrencySign($currentCurrency);
        } elseif ($currentCurrency === 'USD' && $currency === 'TL') {
            $price = round($priceWithDecimal / $tlRate, 2);
            $currencySymbol = getCurrencySign($currentCurrency);
        } else {
            $price = ($currency === 'TL') ? round($priceWithDecimal * $conversionRate, 2) : $priceWithDecimal;
            $currencySymbol = getCurrencySign($currentCurrency);
        }
        $checkoutPrice = round($price, 2);

        // Remove trailing zeros from the price
        $formattedPrice = number_format($price, 2, '.', '');
        $formattedPrice = rtrim($formattedPrice, '0');
        $formattedPrice = rtrim($formattedPrice, '.');

        // Calculate increased price
        $increasedPrice = round($price * 1.20, 2);

        // Format prices with appropriate currency symbol
        $normalPrice = ($currencySymbol === ' TL') ? $increasedPrice . $currencySymbol : $currencySymbol . number_format($increasedPrice, 2);
        $renderPrice = ($currencySymbol === ' TL') ? $formattedPrice . $currencySymbol : $currencySymbol . $formattedPrice;

        $category = 'domain-broker';

        $country = isset($_SESSION['country']) ? $_SESSION['country'] : 'us';

        // Define the columns based on the language and currency settings
        $nameColumn = ($country === 'tr') ? 'name_tr' : 'name';
        $descriptionColumn = ($country === 'tr') ? 'description_tr' : 'description';
        $featuresColumn = ($country === 'tr') ? 'features_tr' : 'features';
        $priceColumn = 'price_' . $currentCurrency; // Ensure currency code is in lowercase

        // Query to fetch product data
        $query = "SELECT product_id, $nameColumn AS name, $descriptionColumn AS description, $featuresColumn AS features, picture, $priceColumn AS price, category FROM products WHERE category = ?";

        // Use prepared statements to prevent SQL injection
        $stmt = mysqli_prepare($conn, $query);

        if ($stmt) {
            // Bind the category parameter
            mysqli_stmt_bind_param($stmt, "s", $category);

            // Execute the prepared statement
            mysqli_stmt_execute($stmt);

            // Get the result set
            $result = mysqli_stmt_get_result($stmt);

            $products = [];

            while ($row = mysqli_fetch_assoc($result)) {
                // Convert features JSON to an array
                $row['features'] = json_decode($row['features'], true);

                // Cast the price to an integer to remove the decimal part
                $brokerPrice = intval($row['price']);

                // Add currency sign to the price
                $currencySign = getCurrencySign($_SESSION["currency"]);
                if ($_SESSION["currency"] === 'try') {
                    $row['price'] = $brokerPrice . ' ' . $currencySign; // Add a space before the currency sign
                } else {
                    $row['price'] = $currencySign . $brokerPrice;
                }

                $products[] = $row;
                $brokerPriceRender = $row['price'];
            }



        }

        displayDomainInfo($domainName, $tld, $status, $normalPrice, $renderPrice, $currency, $lang, $increasedPrice, $checkoutPrice, $currencySymbol, $brokerPriceRender, $brokerPrice);
        mysqli_free_result($result);
        mysqli_stmt_close($stmt);
    }




    echo "</div>";
}


function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'USD' => '$',
        'EUR' => '€',
        'GBP' => '£',
        'TRY' => ' TL', // Added space before the TRY sign
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}



if (isset($_POST['action']) && $_POST['action'] === 'toggle_favorite' && isset($_POST['domain'])) {
    $domain = $_POST['domain'];
    $favoriteDomains = isset($_SESSION['favorite_domains']) ? $_SESSION['favorite_domains'] : array();

    // Define additional information for the favorite domain
    $tld = $_POST['tld']; // Assuming you are sending the TLD along with the domain
    $status = $_POST['status']; // Assuming you have the status information
    $price = $_POST['offerprice']; // Assuming you have the price information
    $increasedPrice = $_POST['price']; // Assuming you have the price information
    $renderPrice = $_POST['renderPrice']; // Assuming you have the price information
    $normalPrice = $_POST['normalPrice']; // Assuming you have the price information
    $itemCurrency = $_POST['itemCurrency']; // Assuming you have the currency information
    if (isset($_POST['productId'])) {
        $product_id = $_POST['productId'];
    }
    $brokerPrice = $price;

    $entryExists = false;

    // Check if the entry already exists in the favorites array
    foreach ($favoriteDomains as $favoriteDomain) {
        if ($favoriteDomain['domain'] === $domain && $favoriteDomain['tld'] === $tld) {
            $entryExists = true;
            break;
        }
    }

    // Toggle favorite status
    if ($entryExists) {
        $favoriteDomains = array_filter($favoriteDomains, function($entry) use ($domain, $tld) {
            return !($entry['domain'] === $domain && $entry['tld'] === $tld);
        });
        $isFavorite = false;
    } else {
        // Add favorite domain with additional information
        $favoriteDomains[] = array(
            'domain' => $domain,
            'tld' => $tld,
            'status' => $status,
            'increasedPrice' => $increasedPrice,
            'price' => $price,
            'itemCurrency' => $itemCurrency,
            'normalPrice' => $normalPrice,
            'renderPrice' => $renderPrice,
        );
        $isFavorite = true;
    }

    $_SESSION['favorite_domains'] = $favoriteDomains;

    // Return JSON response
    echo json_encode(array('isFavorite' => $isFavorite));
    exit();
}

if (isset($_POST['action']) && $_POST['action'] === 'get_favorites') {
    if (isset($_SESSION['favorite_domains'])) {
        $favoriteDomains = $_SESSION['favorite_domains'];
    }
    if (isset($favoriteDomains)) {
        foreach ($favoriteDomains as $favoriteId => $favoriteInfo) {
            $domainName = $favoriteInfo['domain'];
            $tld = $favoriteInfo['tld'];
            $status = $favoriteInfo['status'];
            $checkoutPrice = $favoriteInfo['price'];
            $increasedPrice = $favoriteInfo['increasedPrice'];
            $currency = $favoriteInfo['itemCurrency'];
            $normalPrice = $favoriteInfo['normalPrice'];
            $price = $favoriteInfo['price'];

            // Add or adjust the missing variables according to your needs
            $currencySymbol = '$'; // Provide the correct value
            $brokerPriceRender = ''; // Provide the correct value
            $brokerPrice = 0; // Provide the correct value

            // Fetch the currency symbol from the mapping
            $currencySymbol = isset($currencySymbols[$currency]) ? $currencySymbols[$currency] : $currency;
            if ($currencySymbol === 'TL') {
                $renderPrice = $price . $currencySymbol;
            } else {
                $renderPrice = $currencySymbol . $price;
            }

            // Check if domain is already a favorite
            $isFavorite = true; // Since this is the favorites section
            displayDomainInfo($domainName, $tld, $status, $normalPrice, $renderPrice, $currency, $lang, $increasedPrice, $checkoutPrice, $currencySymbol, $brokerPriceRender, $brokerPrice);
        }
    } else {
        echo "<p>".$lang['domain-empty-favorite']."</p>";
    }

    exit();
}

if (isset($_POST['action']) && $_POST['action'] === 'get_history') {
    echo "<ul class='divide-y divide-gray-300 dark:divide-gray-500'>";
    if (isset($_SESSION['search_history'])) {
        // Reverse the order of search history
        $reversedHistory = array_reverse($_SESSION['search_history']);

        foreach ($reversedHistory as $search) {
            echo "<li class='flex justify-between py-4'><span>$search</span><span class='search-history-link cursor-pointer text-sm tracking-tight font-medium text-blue-600 dark:text-blue-400 dark:text-blue-500 hover:underline' data-search='$search' >".$lang['domain-check-availability']."</span></li>";
        }
    } else {
        echo "<p>".$lang['domain-empty-search-history']."</p>";
    }

    echo "</ul>";

    exit();
}

?>