<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{headline}}</title>
    <style>
        /* Base Styles */
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f7;
            color: #1d1d1f;
            line-height: 1.5;
        }

        /* Email Container */
        .email-container {
            max-width: 600px;
            margin: 40px auto;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.05);
            border-radius: 18px;
            overflow: hidden;
        }

        /* Header */
        .header {
            background-color: #ffffff;
            padding: 30px 40px 20px;
            text-align: center;
            border-bottom: 1px solid #f0f0f0;
        }

        .brand-logo {
            height: 32px;
            width: auto;
        }

        /* Content */
        .content {
            background-color: #ffffff;
            padding: 30px 40px;
        }

        h1 {
            font-size: 28px;
            font-weight: 600;
            margin: 0 0 20px;
            color: #1d1d1f;
            letter-spacing: -0.5px;
        }

        p {
            font-size: 16px;
            margin-bottom: 20px;
            color: #515154;
        }

        .highlight {
            background-color: #f5f5f7;
            padding: 20px;
            border-radius: 12px;
            margin: 25px 0;
        }

        /* Button */
        .btn-container {
            text-align: center;
            margin: 30px 0;
        }

        .button {
            display: inline-block;
            background-color: #0066ff;
            color: #ffffff !important;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 12px;
            font-weight: 500;
            font-size: 16px;
            min-width: 180px;
            text-align: center;
            transition: all 0.2s ease;
        }

        .button:hover {
            background-color: #0052d9;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 102, 255, 0.2);
        }

        /* Footer */
        .footer {
            background-color: #f5f5f7;
            padding: 25px 40px;
            text-align: center;
            font-size: 13px;
            color: #86868b;
            border-top: 1px solid #e5e5e7;
        }

        .footer-links {
            margin: 15px 0;
        }

        .footer-links a {
            color: #515154;
            text-decoration: none;
            margin: 0 10px;
            font-size: 13px;
        }

        .footer-links a:hover {
            text-decoration: underline;
        }

        .copyright {
            margin-top: 15px;
        }
        .tagline{
            font-size: 14px;
            color: #a2a2a2;
        }

        /* Responsive */
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 0;
                border-radius: 0;
            }

            .header, .content, .footer {
                padding: 25px;
            }

            h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <img src="https://datanito.com/assets/images/brand/datanito-logo.png" alt="Datanito" class="brand-logo">
    </div>

    <div class="content">
        <h1>{{headline}}</h1>

        <p>{{hello}} {{user-name}},</p>

        <p>{{email-p1}}</p>

        <div>
            <p>{{email-p2}}</p>
        </div>

        <div class="btn-container">
            <a href="{{cta-link}}" class="button">{{cta}}</a>
        </div>

        <div class="divider"></div>

        <p>{{email-p3}}</p>

        <p>{{best-regards}}<br>{{company-team}}</p>
    </div>

    <div class="footer">
        <div class="footer-links">
            <a href="https://datanito.com">{{home}}</a>
            <a href="https://datanito.com/about">{{about}}</a>
            <a href="https://datanito.com/dino">{{products}}</a>
            <a href="https://datanito.com/contact">{{contact}}</a>
            <a href="https://datanito.com/legal/privacy">{{privacy}}</a>
        </div>

        <p class="copyright">{{email-copyright}}</p>

        <p class="tagline">
            {{company-name}}<br>
            {{company-tagline}}
        </p>
    </div>
</div>
</body>
</html>