<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');

    $category = $_POST['category'];

    // Determine the language (session) and currency (session) settings
    $country = isset($_SESSION['country']) ? $_SESSION['country'] : 'en';
    $currency = isset($_SESSION['currency']) ? strtolower($_SESSION['currency']) : 'usd'; // Ensure currency code is in lowercase

    // Define the columns based on the language and currency settings
    $nameColumn = ($country === 'tr') ? 'name_tr' : 'name';
    $descriptionColumn = ($country === 'tr') ? 'description_tr' : 'description';
    $featuresColumn = ($country === 'tr') ? 'features_tr' : 'features';
    $priceColumn = 'price_' . $currency; // Ensure currency code is in lowercase
    $offerPriceColumn = 'offer_price_' . $currency; // Ensure currency code is in lowercase

    // Query to fetch product data
    $query = "SELECT product_id, $nameColumn AS name, $descriptionColumn AS description, $featuresColumn AS features, picture, $priceColumn AS price, $offerPriceColumn AS offerprice, features_icons, category FROM products WHERE category = ?";

    // Use prepared statements to prevent SQL injection
    $stmt = mysqli_prepare($conn, $query);

    if ($stmt) {
        // Bind the category parameter
        mysqli_stmt_bind_param($stmt, "s", $category);

        // Execute the prepared statement
        mysqli_stmt_execute($stmt);

        // Get the result set
        $result = mysqli_stmt_get_result($stmt);

        $products = [];

        while ($row = mysqli_fetch_assoc($result)) {
            // Convert features and features_icons JSON to an array
            $row['features'] = !empty($row['features']) ? json_decode($row['features'], true) : null;
            $row['features_icons'] = !empty($row['features_icons']) ? json_decode($row['features_icons'], true) : null;

            $originalPrice = floatval($row['price']);
            $offerPrice = floatval($row['offerprice']);
            $savedAmount = $originalPrice - $offerPrice;
            $row['saved_amount'] = $savedAmount;


            // Calculate the discount percentage if original price is greater than zero
            $discountPercentage = $originalPrice > 0 ? ($savedAmount / $originalPrice) * 100 : 0;
            $row['discount_percentage'] = $discountPercentage;

            // Calculate yearly prices
            $yearlyPriceOriginal = ($originalPrice) * 0.9; // Normal price x12 - 30%
            $yearlyPriceOffer = ($offerPrice) * 0.6; // Offer price x12 - 30%
            
            // Calculate the discount percentage for yearly price
            $savedAmountYearly = $yearlyPriceOriginal - $yearlyPriceOffer;
            $discountPercentageYearly = $yearlyPriceOriginal > 0 ? ($savedAmountYearly / $yearlyPriceOriginal) * 100 : 0;
            $row['discount_percentage_yearly'] = $discountPercentageYearly;

            // Add currency sign to the price
            $currencySign = getCurrencySign($currency);
            if ($currency === 'try') {
                $row['price'] = $row['price'] . ' ' . $currencySign; // Add a space before the currency sign
                $row['offerprice'] = $row['offerprice'] . ' ' . $currencySign; // Add a space before the currency sign
                $row['yearly_price'] = number_format($yearlyPriceOriginal, 2) . ' ' . $currencySign; // Add a space before the currency sign
                $row['offerprice_yearly'] = number_format($yearlyPriceOffer, 2) . ' ' . $currencySign; // Add a space before the currency sign
                $row['saved_amount'] = $row['saved_amount'] . ' ' . $currencySign; // Add a space before the currency sign
                $row['saved_amount_yearly'] = $savedAmountYearly . ' ' . $currencySign; // Add a space before the currency sign
            } else {
                $row['price'] = $currencySign . $row['price'];
                $row['offerprice'] = $currencySign . $row['offerprice'];
                $row['yearly_price'] = $currencySign . number_format($yearlyPriceOriginal, 2);
                $row['offerprice_yearly'] = $currencySign . number_format($yearlyPriceOffer, 2);
                $row['saved_amount'] = $currencySign . $row['saved_amount'];
                $row['saved_amount_yearly'] = $currencySign . $savedAmountYearly;
            }


            // Discount text for yearly price
            if (isset($lang['discount_text'])) {
                // Replace placeholders in discount text with calculated values
                $discountText = str_replace('${discountPercentage.toFixed(0)}', number_format($discountPercentage, 0), $lang['discount_text']);
                $discountText = str_replace('${product.saved_amount}', $row['saved_amount'], $discountText);
                $row['discount_text'] = $discountText;

                // Yearly discount text
                $discountTextYearly = str_replace('${discountPercentage.toFixed(0)}', number_format($discountPercentageYearly, 0), $lang['discount_text']);
                $discountTextYearly = str_replace('${product.saved_amount}', $row['saved_amount_yearly'], $discountTextYearly);
                $row['discount_text_yearly'] = $discountTextYearly;
            } else {
                // Provide a default value if the key is not found
                $row['discount_text'] = ''; // Or any other default text you want to set
                $row['discount_text_yearly'] = ''; // Default text for yearly discount
            }

            $products[] = $row;
        }

        mysqli_free_result($result);
        mysqli_stmt_close($stmt);
        mysqli_close($conn);

        echo json_encode($products);
    } else {
        // Handle the database query error
        echo json_encode(['error' => 'Failed to prepare and execute the statement: ' . mysqli_error($conn)]);
    }
}

function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'usd' => '$',
        'eur' => '€',
        'gbp' => '£',
        'try' => ' TL', // Added space before the TRY sign
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}
?>
