<?php

if (isset($_SESSION['user']) && isset($_SESSION['user']['id'])) {
    $this_userID = $_SESSION['user']['id'];
} else {
    // Handle the case when 'user' or 'id' key is not set in the session
    $this_userID = null; // Or any default value you want to set
}
// Assuming $profilePicture contains the profile picture URL or file path
include_once includes('config.php');


unset($_SESSION['chat_messages']);


$query = "SELECT name, email, username, phone_number, role, profile_picture, verification_badge FROM users WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $this_userID);
$stmt->execute();
$stmt->bind_result($this_name, $this_email, $this_username, $this_phoneNumber, $this_role, $this_profilePicture,  $this_verificationBadgeStatus);

// Fetch the results
$stmt->fetch();

// Close the statement
$stmt->close();
// Check if the profile picture is empty

function getThisAvatar($this_profilePicture, $this_name, $this_username)
{
    // Check if the profile picture is empty
    if (empty($this_profilePicture)) {
        // Generate an avatar based on initials
        $avatar = strtoupper(substr($this_name, 0, 1));

        // Display the avatar
        return '<div class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600"><span class="font-medium text-gray-600 dark:text-gray-300">' . $avatar . '</span></div>';
    }

    // Check if the profile picture is an external URL
    if (filter_var($this_profilePicture, FILTER_VALIDATE_URL) !== false) {
        // Display the user's profile picture
        return '<img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full" src="' . htmlspecialchars($this_profilePicture) . '" alt="' . htmlspecialchars($this_username) . ' Profile Picture">';
    }

    // Display the user's profile picture (assuming it's a local file)
    return '<img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full" src="' . asset('uploads/profile_pictures/'.$this_profilePicture) . '" alt="' . htmlspecialchars($this_username) . ' Profile Picture">';
}

if (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn']) {
    $this_userAvatar = getThisAvatar($this_profilePicture, $this_name, $this_username);
}
$_SESSION['user']['name'] = $this_name;
$_SESSION['user']['role'] = $this_role;
// Check if the user is verified
if (!empty($this_verificationBadgeStatus)) {
    // Display the verification badge and type
    if ($this_verificationBadgeStatus === 'government') {
        $this_verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__government-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    }elseif ($this_verificationBadgeStatus === 'corporation'){
        $this_verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__corporation-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    }elseif ($this_verificationBadgeStatus === 'personal'){
        $this_verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__personal-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
    }
} else {
    // Display a message for unverified users
    $this_verificationBadge = '';
}
$URL = $_SERVER['REQUEST_URI'];
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLanguage; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo $currentMeta['title']; ?></title>
    <meta name="description" content="<?php echo $currentMeta['description']; ?>">
    <meta property="og:title" content="<?php echo $currentMeta['og:title']; ?>" />
    <meta property="og:description" content="<?php echo $currentMeta['og:description']; ?>" />
    <meta property="og:url" content="<?php echo getCurrentUrl(); ?>" />
    <meta property="og:locale" content="<?php echo $currentLanguage; ?>" />
    <meta property="og:image" content="<?php echo url('') . $currentMeta['og:image']; ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:site_name" content="<?php echo $currentMeta['og:title']; ?>" />
    <meta name="robots" content="index, follow">
    <meta name="author" content="Datanito">
    <meta name="color-scheme" content="light dark" />
    <link rel="canonical" href="<?php echo getCurrentUrl(); ?>">
    <?php
    // Get the current URL
    $currentUrl = $_SERVER['REQUEST_URI'];

    // Define a regex pattern to check for '/tr' as a complete segment
    $trPattern = '#/tr(/|$)#';

    // Check if "/tr" is present as a full segment in the URL
    if (!preg_match($trPattern, $currentUrl)) {
        // If not present, insert "/tr" after the domain
        $urlParts = explode('/', $currentUrl, 2);
        $path = isset($urlParts[1]) ? rtrim($urlParts[1], '/') : '';

        // Construct the new URL for "tr"
        $newUrlTr = rtrim($urlParts[0], '/') . '/tr/' . $path;
        $newUrlTr = rtrim($newUrlTr, '/');

        // Construct the new URL for "en"
        $newUrlEn = rtrim($urlParts[0], '/') . '/' . $path;
        $newUrlEn = rtrim($newUrlEn, '/');

        // Remove language sign from the path
        $pathWithoutLangSign = preg_replace('/\/[a-z]{2}\//i', '/', $path);

        // Echo both versions for SEO improvements
        echo '<link rel="alternate" hreflang="en" href="https://' . $_SERVER['HTTP_HOST'] . $urlParts[0] . '/' . $pathWithoutLangSign . '">';
        echo '<link rel="alternate" hreflang="tr" href="https://' . $_SERVER['HTTP_HOST'] . $newUrlTr . '">';
    } else {
        // If "/tr" is already present as a full segment, construct the URL for "en"
        $urlParts = preg_split($trPattern, $currentUrl, 2);
        $path = isset($urlParts[1]) ? ltrim($urlParts[1], '/') : '';

        // Construct the new URL for "en"
        $newUrlEn = rtrim($urlParts[0], '/') . '/' . $path;
        $newUrlEn = rtrim($newUrlEn, '/');

        // Remove language sign from the path
        $pathWithoutLangSign = preg_replace('/\/[a-z]{2}\//i', '/', $path);

        // Echo both versions for SEO improvements
        echo '<link rel="alternate" hreflang="en" href="https://' . $_SERVER['HTTP_HOST'] . $newUrlEn . '">';
        echo '<link rel="alternate" hreflang="tr" href="https://' . $_SERVER['HTTP_HOST'] . $currentUrl . '">';
    }
    ?>




    <!-- Favicon -->
    <!-- Standard favicon for most browsers -->
    <link rel="icon" href="<?php echo asset('images/brand/icon.png'); ?>" type="image/x-icon">

    <!-- For IE 11 or lower -->
    <link rel="icon" href="<?php echo asset('images/brand/favicon.ico'); ?>" type="image/vnd.microsoft.icon">

    <!-- For Apple devices (iOS, macOS) -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo asset('images/brand/apple-touch-icon.png'); ?>">

    <!-- For Android devices -->
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo asset('images/brand/android-chrome-192x192.png'); ?>">

    <!-- For Safari on iOS -->
    <link rel="mask-icon" href="<?php echo asset('images/brand/safari-pinned-tab.svg'); ?>" color="#111111">

    <!-- For Windows 8 / IE 10 -->
    <meta name="msapplication-TileImage" content="<?php echo asset('images/brand/mstile-144x144.png'); ?>">

    <!-- CSS Stylesheets -->
    <script src="https://cdn.tailwindcss.com?plugins=typography"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.css" rel="stylesheet" />
<!--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/css/nice-select.min.css" integrity="sha512-CruCP+TD3yXzlvvijET8wV5WxxEh5H8P4cmz0RFbKK6FlZ2sYl3AEsKlLPHbniXKSrDdFewhbmBK5skbdsASbQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />-->
    <script>
        // On page load or when changing themes, best to add inline in `head` to avoid FOUC
        if (localStorage.getItem('color-theme') === 'dark' || (!('color-theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark')
        }
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: {
                            "50": "#F9FFE5",    // Very pale yellow-green
                            "100": "#F3FFC4",   // Light pastel yellow-green
                            "200": "#E9FF9A",   // Soft lime green
                            "300": "#DAFF70",   // Bright lime green
                            "400": "#C7F957",   // Lime with more saturation
                            "500": "#CDF140",   // Balanced yellow-green
                            "600": "#97D433",   // Muted yellow-green
                            "700": "#7BB42A",   // Deep yellow-green
                            "800": "#629322",   // Dark olive green
                            "900": "#4A721A",   // Dark moss green
                            "950": "#324E0F"    // Almost black green
                        },
                        dark: {
                            "50": "#1e1e1e",
                            "100": "#2c2c2c",
                            "200": "#383838",
                            "300": "#454545",
                            "400": "#525252",
                            "500": "#606060",
                            "600": "#373738",
                            "700": "#262626",
                            "800": "#1a1a1a", // Additional shade
                            "900": "#111111", // Additional shade
                            "950": "#000000"  // Additional shade
                        }
                    }
                },
                fontFamily: {
                    'body': [
                        'Raleway',
                        'ui-sans-serif',
                        'system-ui',
                        '-apple-system',
                        'system-ui',
                        'Segoe UI',
                        'Roboto',
                        'Helvetica Neue',
                        'Arial',
                        'Noto Sans',
                        'sans-serif',
                        'Apple Color Emoji',
                        'Segoe UI Emoji',
                        'Segoe UI Symbol',
                        'Noto Color Emoji'
                    ],
                    'sans': [
                        'Raleway',
                        'ui-sans-serif',
                        'system-ui',
                        '-apple-system',
                        'system-ui',
                        'Segoe UI',
                        'Roboto',
                        'Helvetica Neue',
                        'Arial',
                        'Noto Sans',
                        'sans-serif',
                        'Apple Color Emoji',
                        'Segoe UI Emoji',
                        'Segoe UI Symbol',
                        'Noto Color Emoji'
                    ]
                }
            }
        }
    </script>
    <link rel="stylesheet" href="<?php echo asset('css/main.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/critical.css'); ?>">

    <!-- Icons -->
    <link rel="stylesheet"
          href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0"/>
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "agvfdg8ljf");
    </script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-K2SZQ1ZB4N"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-K2SZQ1ZB4N');
    </script>
    <link rel="stylesheet" href="<?php echo asset('css/main.min.css'); ?>">
    <?php
    $jsonFaqLD = array(); // Initialize the variable
    $jsonOrgLD = array(); // Initialize the variable

    // Convert arrays to JSON strings
    $jsonFaqLDString = json_encode($jsonFaqLD);
    $jsonOrgLDString = json_encode($jsonOrgLD);

    // Output the schema as a script tag
    echo '<script type="application/ld+json">' . $jsonFaqLDString . '</script>';
    // Output the schema as a script tag
    echo '<script type="application/ld+json">' . $jsonOrgLDString . '</script>';
    ?>

</head>
<body class="bg-white dark:bg-dark-900 text-black dark:text-white">
<div class="loading-top fixed top-0 bg-gray-100 dark:bg-dark-900">
    <div class="loading-top-c">
    </div>
</div>
<div id="cart-drawer" class="cart-drawer fixed inset-0 z-50 overflow-hidden transition-all ease-in-out duration-300 transform translate-x-full" tabindex="-1" aria-labelledby="cart-drawer-label">
    <!-- Overlay -->
    <div class="absolute inset-0 bg-black bg-opacity-30 transition-opacity" data-drawer-hide="cart-drawer" aria-controls="cart-drawer"></div>

    <!-- Drawer Content -->
    <div class="absolute top-0 right-0 h-full w-full sm:w-[480px] bg-white dark:bg-dark-800 shadow-xl flex flex-col">
        <!-- Header -->
        <div class="px-6 py-5 border-b border-gray-100 dark:border-dark-700 flex justify-between items-center">
            <div>
                <h2 id="cart-drawer-label" class="text-2xl font-semibold text-gray-900 dark:text-white">
                    <?php echo $lang['cart'] ?>
                    <span class="cart-count-badge ml-2 bg-gray-100 dark:bg-dark-700 text-gray-800 dark:text-white text-sm font-medium px-2.5 py-0.5 rounded-full">0</span>
                </h2>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-1"><?php echo $lang['items-in-cart'] ?></p>
            </div>
            <button type="button" data-drawer-hide="cart-drawer" aria-controls="cart-drawer" class="text-gray-400 hover:text-gray-500 dark:hover:text-white p-2 rounded-full hover:bg-gray-100 dark:hover:bg-dark-700 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
                <span class="sr-only">Close menu</span>
            </button>
        </div>

        <!-- Items Section -->
        <div class="flex-1 overflow-y-auto px-6 py-4">
            <!-- Empty State -->
            <div class="cart-empty-message flex flex-col items-center justify-center py-12 text-center">
                <div class="w-24 h-24 bg-gray-100 dark:bg-dark-700 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-12 h-12 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-medium text-gray-900 dark:text-white mb-2"><?php echo $lang['cart-is-empty'] ?></h3>
                <p class="text-gray-500 dark:text-gray-400 mb-8 max-w-xs"><?php echo $lang['empty-cart-suggestion'] ?></p>

                <!-- Premium Recommendations -->
                <div class="w-full space-y-6">
                    <!-- Featured Product -->
                    <div class="bg-gradient-to-r from-blue-50 to-purple-50 dark:from-dark-700 dark:to-dark-600 rounded-xl p-6 border border-gray-200 dark:border-dark-600">
                        <div class="flex items-start">
                            <div class="flex-1">
                                <h4 class="text-lg font-semibold text-gray-900 dark:text-white mb-1"><?php echo $lang['featured-product'] ?></h4>
                                <p class="text-sm text-gray-600 dark:text-gray-300 mb-4"><?php echo $lang['featured-product-desc'] ?></p>
                                <div class="flex items-center justify-between">
                                    <span class="text-lg font-bold text-gray-900 dark:text-white">$9.99<span class="text-sm font-normal text-gray-500 dark:text-gray-400">/mo</span></span>
                                    <a href="<?php echo url('/cloud/web-hosting'); ?>" class="inline-flex items-center px-4 py-2.5 bg-black dark:bg-white text-white dark:text-black text-sm font-medium rounded-full hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors shadow-sm">
                                        <?php echo $lang['add-to-cart'] ?>
                                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <div class="ml-6 w-24 h-24 bg-white dark:bg-dark-600 rounded-lg flex items-center justify-center shadow-sm">
                                <svg class="w-12 h-12 text-blue-500 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M11.3 1.046A1 1 0 0112 2v5h4a1 1 0 01.82 1.573l-7 10A1 1 0 018 18v-5H4a1 1 0 01-.82-1.573l7-10a1 1 0 011.12-.38z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Recommendations Grid -->
                    <div class="grid grid-cols-2 gap-4">
                        <!-- Domain Recommendation -->
                        <div class="bg-white dark:bg-dark-700 rounded-lg p-4 border border-gray-200 dark:border-dark-600 hover:shadow-md transition-shadow">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900 rounded-full flex items-center justify-center mr-3">
                                    <svg class="w-5 h-5 text-purple-600 dark:text-purple-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M17.778 8.222c-4.296-4.296-11.26-4.296-15.556 0A1 1 0 01.808 6.808c5.076-5.077 13.308-5.077 18.384 0a1 1 0 01-1.414 1.414zM14.95 11.05a7 7 0 00-9.9 0 1 1 0 01-1.414-1.414 9 9 0 0112.728 0 1 1 0 01-1.414 1.414zM12.12 13.88a3 3 0 00-4.242 0 1 1 0 01-1.415-1.415 5 5 0 017.072 0 1 1 0 01-1.415 1.415zM9 16a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <h5 class="text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['domain-suggestion-headline'] ?></h5>
                            </div>
                            <a href="<?php echo url('/domain/register'); ?>" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 font-medium inline-flex items-center">
                                <?php echo $lang['shop-domains'] ?>
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>

                        <!-- SSL Recommendation -->
                        <div class="bg-white dark:bg-dark-700 rounded-lg p-4 border border-gray-200 dark:border-dark-600 hover:shadow-md transition-shadow">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 dark:bg-green-900 rounded-full flex items-center justify-center mr-3">
                                    <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <h5 class="text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['ssl-suggestion-headline'] ?></h5>
                            </div>
                            <a href="<?php echo url('/security/ssl-certificates'); ?>" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 font-medium inline-flex items-center">
                                <?php echo $lang['shop-ssl'] ?>
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items List -->
            <ul class="cart-items-list space-y-4 hidden">
                <!-- Sample Item Structure -->
                <li class="cart-item flex py-4 border-b border-gray-100 dark:border-dark-700">
                    <div class="flex-shrink-0 w-20 h-20 bg-gray-100 dark:bg-dark-600 rounded-lg overflow-hidden">
                        <img src="https://via.placeholder.com/80" alt="Product" class="w-full h-full object-cover">
                    </div>
                    <div class="ml-4 flex-1 flex flex-col">
                        <div class="flex justify-between">
                            <h4 class="text-sm font-medium text-gray-900 dark:text-white">Premium Web Hosting</h4>
                            <p class="text-sm font-medium text-gray-900 dark:text-white">$9.99/mo</p>
                        </div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Business Plan</p>
                        <div class="flex items-center justify-between mt-2">
                            <div class="flex items-center border border-gray-200 dark:border-dark-600 rounded-full">
                                <button class="quantity-btn px-3 py-1 text-gray-500 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-dark-700">-</button>
                                <span class="quantity px-2 text-sm">1</span>
                                <button class="quantity-btn px-3 py-1 text-gray-500 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-dark-700">+</button>
                            </div>
                            <button class="text-sm font-medium text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300">Remove</button>
                        </div>
                    </div>
                </li>
            </ul>
        </div>

        <!-- Footer -->
        <div class="cart-checkout border-t border-gray-100 dark:border-dark-700 bg-white dark:bg-dark-800 px-6 py-5">
            <div class="space-y-3">
                <div class="flex justify-between">
                    <span class="text-sm text-gray-500 dark:text-gray-400"><?php echo $lang['cart-subtotal'] ?></span>
                    <span class="subtotal-normal text-base font-medium text-gray-900 dark:text-white">$0.00</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-sm text-gray-500 dark:text-gray-400"><?php echo $lang['cart-saving'] ?></span>
                    <span class="text-base font-medium text-green-600 dark:text-green-400"><span>-</span><span class="saving-amount">$0.00</span></span>
                </div>
                <div class="pt-3 border-t border-gray-100 dark:border-dark-700 flex justify-between items-center">
                    <span class="text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['cart-total'] ?></span>
                    <span class="subtotal text-xl font-bold text-gray-900 dark:text-white">$0.00</span>
                </div>
            </div>

            <div class="mt-6 space-y-3">
                <a id="checkout-btn" href="<?php echo url('/checkout'); ?>" class="block w-full py-3 px-4 bg-black dark:bg-white text-white dark:text-black text-center font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors shadow-sm">
                    <?php echo $lang['cart-checkout'] ?>
                </a>
                <button type="button" data-drawer-hide="cart-drawer" aria-controls="cart-drawer" class="block w-full py-3 px-4 bg-white dark:bg-dark-700 text-gray-800 dark:text-white border border-gray-300 dark:border-dark-600 text-center font-medium rounded-lg hover:bg-gray-50 dark:hover:bg-dark-600 transition-colors">
                    <?php echo $lang['cart-continue-shopping'] ?>
                </button>
            </div>

            <div class="mt-4 flex items-center justify-center space-x-2">
                <svg class="flex-shrink-0 w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                </svg>
                <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo $lang['check-out-secure-headline']?></p>
            </div>
        </div>
    </div>
</div>