
</div>
</div>
</div>
<div id="settings-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <!-- Modal content -->
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="settings-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <!-- Modal header -->
            <div class="px-6 py-4 rounded-t sm:border-b dark:border-dark-600">
                <h3 class="text-base font-semibold text-gray-900 lg:text-xl dark:text-white">
                    <?php echo $lang['setting-modal-title'] ?>
                </h3>
            </div>
            <!-- Modal body -->
            <div class="p-6">
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['select-country-and-currency'] ?></p>
                <form method="POST" class="settings-form">
                    <div class="flex flex-col">
                        <label for="country" class="text-gray-900 dark:text-white font-medium mt-5 mb-2"><?php echo $lang['country-or-region'] ?></label>
                        <select id="country" name="country" class="block w-full px-4 py-2 my-1 text-base text-gray-900 border border-gray-300 rounded-xl bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="us" <?php if ($_SESSION["country"] === 'us') echo 'selected'; ?>>United States - English</option>
                            <option value="tr" <?php if ($_SESSION["country"] === 'tr') echo 'selected'; ?>>Türkiye - Türkçe</option>
                        </select>
                    </div>

                    <div class="flex flex-col">
                        <label for="currency" class="text-gray-900 dark:text-white font-medium my-2"><?php echo $lang['choose-currency'] ?></label>
                        <select id="currency" name="currency" class="block w-full px-4 py-2 my-1 text-base text-gray-900 border border-gray-300 rounded-xl bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="usd" <?php if ($_SESSION["currency"] === 'usd') echo 'selected'; ?>>USD $</option>
                            <option value="eur" <?php if ($_SESSION["currency"] === 'eur') echo 'selected'; ?>>EUR €</option>
                            <option value="try" <?php if ($_SESSION["currency"] === 'try') echo 'selected'; ?>>TRY TL</option>
                            <option value="gbp" <?php if ($_SESSION["currency"] === 'gbp') echo 'selected'; ?>>GBP £</option>
                        </select>
                    </div>
                    <div class="flex flex-col mt-4 items-end">
                        <button type="button"  class="save-settings text-white bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:outline-none focus:ring-dark-300 font-medium rounded-3xl text-sm px-5 py-2.5 text-center dark:bg-dark-500 dark:hover:bg-dark-600 dark:focus:ring-dark-800 mt-4"><?php echo $lang['setting-modal-save'] ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div id="datanito-premium-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <!-- Modal content -->
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="datanito-premium-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <!-- Modal header -->
            <div class="px-6 py-4 rounded-t">
                <h3 class="text-base font-extrabold lg:text-xl text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400">
                    <?php echo $lang['datanito-premium-headline']; ?>
                </h3>
            </div>
            <!-- Modal body -->
            <div class="bg-gray-100 dark:bg-dark-500">
                <div id="premiumPlans" class="block bg-white dark:bg-dark-700 p-2 space-y-2 mb-2">

                </div>
                <div class="block bg-white dark:bg-dark-700 p-6 space-y-2 h-48 md:h-full overflow-y-auto">
                    <div class="premium-features-container">
                        <?php foreach ($premiumFeatures as $feature): ?>
                            <div class="flex items-center space-x-4 space-y-4">
                                <span class="material-symbols-outlined <?php echo $feature['iconBgColor']; ?> <?php echo $feature['iconColor']; ?> rounded-xl p-2"><?php echo $feature['iconSymbol']; ?></span>
                                <div>
                                    <span class="text-sm font-bold text-gray-900 dark:text-gray-200"><?php echo $feature['title']; ?></span>
                                    <span class="text-xs font-normal text-gray-500 dark:text-gray-300"><?php echo $feature['description']; ?></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div id="premium-cta" class="block bg-white dark:bg-dark-700 p-2 border-t border-gray-200 dark:border-dark-500">
                </div>

            </div>
        </div>
    </div>
</div>

<?php
include_once includes('scripts.php');
?>
<script>
    function loadProducts() {
        $.ajax({
            type: "POST",
            url: "/get_products", // Update with the correct path to your PHP script
            dataType: "json",
            data: { category: "premium" }, // You can pass the category here
            success: function (data) {
                const productCardsContainer = $("#premiumPlans"); // Specify the container for product cards
                // Clear existing content in the container
                productCardsContainer.empty();
                console.log(data);

                $.each(data, function (index, product) {
                    // Create a product card
                    $("#premium-cta").html('<button type="button" id="premium-cta" data-product-id="' + product.product_id + '" class="add-to-cart-btn w-full text-white bg-blue-700 hover:bg-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800"><?php echo str_replace('%d', '\' + product.price + \'', $lang['datanito-premium-cta']); ?></button>');
                    const productCard = $("<div>");
                    productCard.addClass("flex items-center h-10 w-full ps-4 dark:border-dark-700");
                    productCard.html(`
                        <input id="premium-monthly-radio" type="radio" value="" name="bordered-radio" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-dark-800 focus:ring-2 dark:bg-dark-700 dark:border-gray-600" checked>
                        <div class="ms-2 w-full flex justify-between items-center text-sm mx-4">
                            <label for="premium-monthly-radio" class="w-full font-medium text-gray-900 dark:text-gray-300 ml-2">
                                <div>${product.name}</div>
                            </label>
                            <label for="premium-monthly-radio" class="w-full text-right font-medium text-gray-900 dark:text-gray-300 ml-2">
                                <p id="premium-monthly-radio" class="text-sm font-medium text-gray-900 dark:text-gray-300">${product.price}<span class="text-xs">/<?php echo $lang['mo']?></span></p>
                            </label>
                        </div>
                `);
                    productCardsContainer.append(productCard);
                });
            },
            error: function (error) {
                console.error("Error fetching product data:", error);
            },
        });
    }
    $(document).ready(function() {
        var sidebarWidth = 300; // Width of the sidebar
        var sidebarToggleWidth = 260; // Width of the sidebar toggle button

        // Check if sidebar state is stored in local storage
        var sidebarOpen = localStorage.getItem('sidebarOpen') === 'true';

        // Check if the screen size is smaller than "md" breakpoint
        if (window.matchMedia('(max-width: 768px)').matches) {
            sidebarOpen = true; // Set to false if screen size is smaller than "md"
        } else {
            sidebarOpen = true; // Set to true for devices larger than 768px
        }

        // Function to close the sidebar
        function closeSidebar() {
            $('#drawer-navigation').animate({
                left: '-=' + sidebarWidth + 'px'
            }, 200);
            $('.toggle-sidebar').animate({
                left: '-=' + sidebarToggleWidth + 'px',
                transform: 'translateX(10px) translateY(-50%) rotate(0deg) translateZ(0px)' // Adjust the values as needed
            }, 200);
            $('main').animate({
                'padding-left': 0
            }, 200);
            $('.toggle-sidebar').removeClass('sidebar-open').addClass('sidebar-close');
            $('.close-sidebar-text').addClass('hidden');
            $('.open-sidebar-text').removeClass('hidden');
            sidebarOpen = false;
            // Store sidebar state in local storage
            localStorage.setItem('sidebarOpen', false);
        }

        // Close sidebar on load if it was previously closed
        if (!sidebarOpen) {
            closeSidebar();
        }

        $('.toggle-sidebar').click(function() {
            if (sidebarOpen) {
                // If sidebar is open, close it
                closeSidebar();
            } else {
                // If sidebar is closed, open it
                $('#drawer-navigation').animate({
                    left: '+=' + sidebarWidth + 'px'
                }, 200);
                $('.toggle-sidebar').animate({
                    left: '+=' + sidebarToggleWidth + 'px',
                    transform: 'translateX(260px) translateY(-50%) rotate(0deg) translateZ(0px)' // Adjust the values as needed
                }, 200);
                $('main').animate({
                    'padding-left': '16rem' // Restore main's left margin to its original value
                }, 200);
                $('.toggle-sidebar').removeClass('sidebar-close').addClass('sidebar-open');
                $('.close-sidebar-text').removeClass('hidden');
                $('.open-sidebar-text').addClass('hidden');
                sidebarOpen = true;
            }
            localStorage.setItem('sidebarOpen', sidebarOpen); // Store sidebar state in local storage
        });

        // Add hover effect on sidebar toggle button
        $('.toggle-sidebar').hover(function() {
            $('#drawer-navigation ').addClass('opacity-50');
        }, function() {
            $('#drawer-navigation ').removeClass('opacity-50');
        });
    });


    loadProducts();
</script>
<script>
    $(document).ready(function(){
        $('.toggleAdminButton').click(function(){
            $('.adminArea').toggleClass('hidden');
        });
    });
</script>