<?php
include_once includes('head.php');
// Start the session
if (!isset($_SESSION['user']['id'])) {
    // User is not logged in. Display a message and a spinner.
    echo '<div class="fixed inset-0 flex items-center justify-center bg-white dark:bg-dark-900 z-50">';
    echo '<div class="text-center p-8 rounded-xl bg-gray-50 dark:bg-dark-700 shadow-lg max-w-md">';
    echo '<div role="status" class="flex justify-center mb-4">';
    echo '<svg aria-hidden="true" class="w-12 h-12 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">';
    echo '<path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>';
    echo '<path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>';
    echo '</svg>';
    echo '<span class="sr-only">Loading...</span>';
    echo '</div>';
    echo '<p class="text-gray-700 dark:text-gray-300 mb-4">'.$lang['user-not-logged-in'].'</p>';
    echo '<div class="w-full bg-gray-200 rounded-full h-1.5 dark:bg-gray-700">';
    echo '<div class="bg-blue-600 h-1.5 rounded-full dark:bg-blue-500 animate-pulse" style="width: 45%"></div>';
    echo '</div>';
    echo '</div>';
    echo '</div>';

    $loginURL = url('/account/login');
    echo '<script>
        setTimeout(function() {
            window.location.href = "'.$loginURL.'";
        }, 1500);
    </script>';

    $_SESSION['intended_destination'] = $_SERVER['REQUEST_URI'];
    if ($_SESSION['intended_destination'] === $loginURL) {
        $_SESSION['intended_destination'] = url('/account/overview');
    }
    exit;
}
$user_id = $_SESSION['user']['id'];

function isPremiumUser($user_id, $conn) {
    $query = "SELECT is_premium FROM users WHERE user_id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $isPremium);

    if (mysqli_stmt_fetch($stmt)) {
        return ['isPremium' => $isPremium];
    } else {
        return null;
    }
}
$getPremiumStatus = isPremiumUser($user_id, $conn);

// Count open tickets and unpaid invoices
$querySupportUser = "SELECT COUNT(*) AS ticket_count FROM support_tickets WHERE user_id = ? AND (status = 'Open' OR status = 'In Progress')";
$queryInvoiceUser = "SELECT COUNT(*) AS invoice_count FROM invoices WHERE user_id = ? AND invoice_status = 'Unpaid'";

$stmt = $conn->prepare($querySupportUser);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($openTicketCount);
$stmt->fetch();
$stmt->close();

$stmtInvoice = $conn->prepare($queryInvoiceUser);
$stmtInvoice->bind_param("i", $user_id);
$stmtInvoice->execute();
$stmtInvoice->bind_result($unpaidInvoiceCount);
$stmtInvoice->fetch();
$stmtInvoice->close();
?>
<style>
    #bottom-banner{
        display: none!important;
    }
    .nav-gradient {
        background: linear-gradient(90deg, rgba(255,255,255,0.9) 0%, rgba(255,255,255,0.95) 100%);
    }
    .dark .nav-gradient {
        background: linear-gradient(90deg, rgba(15,23,42,0.9) 0%, rgba(15,23,42,0.95) 100%);
    }
</style>
<div id="content">
    <div id="page-content">
        <div id="dashboard" class="antialiased bg-white dark:bg-dark-900">
            <!-- Enterprise Navigation Bar -->
            <nav class="nav-gradient backdrop-blur-sm border-b border-gray-200 dark:border-dark-600 fixed left-0 right-0 top-0 z-40 px-4 py-2">
                <div class="flex flex-wrap justify-between items-center mx-auto max-w-screen-2xl">
                    <!-- Left side - Logo and Mobile Menu -->
                    <div class="flex items-center space-x-4">
                        <!-- Mobile menu button -->
                        <button data-drawer-target="drawer-navigation" data-drawer-toggle="drawer-navigation" aria-controls="drawer-navigation" class="p-2 text-gray-500 rounded-lg md:hidden hover:text-gray-900 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-dark-700">
                            <span class="sr-only">Toggle sidebar</span>
                            <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h6a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                            </svg>
                        </button>

                        <!-- Logo -->
                        <a href="<?php echo url('/account/overview'); ?>" class="flex items-center">
                            <svg class="w-8 h-8 mr-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 639 636">
                                <g>
                                    <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-blue-600 dark:fill-blue-400" d="M543.414062 80.550781 C563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L155.367188 541.199219 C135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L471.371094 80.558594 C491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M543.414062 80.550781"/>
                                    <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-blue-600 dark:fill-blue-400" d="M350.257812 83.671875 C370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L158.246094 348.046875 C138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L278.207031 83.671875 C298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M350.257812 83.671875"/>
                                    <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-blue-600 dark:fill-blue-400" d="M198.839844 42.324219 C218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L116.90625 196.484375 C97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L126.78125 42.324219 C146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M198.839844 42.324219"/>
                                    <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-blue-600 dark:fill-blue-400" d="M549.855469 263.0625 C569.75 282.984375 569.75 315.277344 549.855469 335.199219 L337.238281 548.0625 C317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L477.804688 263.0625 C497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M549.855469 263.0625"/>
                                    <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-blue-600 dark:fill-blue-400" d="M578.785156 423.015625 C598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L496.855469 577.171875 C476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L506.726562 423.015625 C526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M578.785156 423.015625"/>
                                </g>
                            </svg>
                            <span class="text-xl font-bold text-gray-800 dark:text-white">
                                <?php echo $getPremiumStatus['isPremium'] ? $lang['premium-headline'] : $lang['account-headline']; ?>
                            </span>
                        </a>
                    </div>

                    <!-- Right side - User controls -->
                    <div class="flex items-center space-x-4">
                        <!-- Search (hidden on mobile) -->
                        <div class="hidden md:block relative">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                            <input type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white" placeholder="Search...">
                        </div>

                        <!-- Notification and Settings -->
                        <div class="flex items-center space-x-2">
                            <!-- Notification -->
                            <button type="button" data-dropdown-toggle="notification-dropdown" class="p-2 text-gray-500 rounded-full hover:text-gray-900 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-dark-700 relative">
                                <span class="sr-only">View notifications</span>
                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 2a6 6 0 00-6 6v3.586l-.707.707A1 1 0 004 14h12a1 1 0 00.707-1.707L16 11.586V8a6 6 0 00-6-6zM10 18a3 3 0 01-3-3h6a3 3 0 01-3 3z"></path>
                                </svg>
                                <?php if ($unpaidInvoiceCount + $openTicketCount > 0): ?>
                                    <span class="absolute top-0 right-0 w-3 h-3 bg-red-500 rounded-full"></span>
                                <?php endif; ?>
                            </button>

                            <!-- Settings -->
                            <button type="button" data-modal-target="settings-modal" class="p-2 text-gray-500 rounded-full hover:text-gray-900 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-dark-700">
                                <span class="sr-only">Settings</span>
                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd"></path>
                                </svg>
                            </button>

                            <!-- User dropdown -->
                            <?php if ($_SESSION['userLoggedIn']): ?>
                                <button type="button" class="flex text-sm bg-gray-800 rounded-full focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600" id="user-menu-button" aria-expanded="false" data-dropdown-toggle="user-dropdown">
                                    <span class="sr-only">Open user menu</span>
                                    <span class="relative inline-flex items-center justify-center w-8 h-8 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-800">
                                        <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo $this_userAvatar; ?></span>
                                    </span>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Notification Dropdown -->
            <div class="hidden z-50 my-4 text-base list-none bg-white divide-y divide-gray-100 rounded-xl shadow dark:bg-dark-700 dark:divide-gray-600 w-80" id="notification-dropdown">
                <div class="px-4 py-3 font-medium text-gray-900 dark:text-white">
                    <?php echo $lang['notification-headline']; ?>
                </div>
                <div class="divide-y divide-gray-100 dark:divide-gray-600">
                    <!-- Unpaid Invoices -->
                    <?php if ($unpaidInvoiceCount > 0): ?>
                        <a href="<?php echo url('/account/billing/invoices'); ?>" class="flex px-4 py-3 hover:bg-gray-50 dark:hover:bg-dark-600">
                            <div class="flex-shrink-0 relative">
                                <div class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-100 dark:bg-dark-500">
                                    <span class="material-symbols-outlined">receipt_long</span>
                                </div>
                                <div class="absolute top-0 right-0 w-3 h-3 bg-red-500 rounded-full"></div>
                            </div>
                            <div class="pl-3 w-full">
                                <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">
                                    <?php echo sprintf($lang['unpaid-invoice-headline'], $unpaidInvoiceCount); ?>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <?php echo $lang['unpaid-invoice-subheading']; ?>
                                </div>
                            </div>
                        </a>
                    <?php else: ?>
                        <div class="flex px-4 py-3">
                            <div class="flex-shrink-0 relative">
                                <div class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-100 dark:bg-dark-500">
                                    <span class="material-symbols-outlined">receipt_long</span>
                                </div>
                                <div class="absolute top-0 right-0 w-3 h-3 bg-green-500 rounded-full"></div>
                            </div>
                            <div class="pl-3 w-full">
                                <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">
                                    <?php echo $lang['no-unpaid-invoice-headline']; ?>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <?php echo $lang['no-unpaid-invoice-subheading']; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Open Support Cases -->
                    <?php if ($openTicketCount > 0): ?>
                        <a href="<?php echo url('/account/support/requests'); ?>" class="flex px-4 py-3 hover:bg-gray-50 dark:hover:bg-dark-600">
                            <div class="flex-shrink-0 relative">
                                <div class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-100 dark:bg-dark-500">
                                    <span class="material-symbols-outlined">chat_bubble</span>
                                </div>
                                <div class="absolute top-0 right-0 w-3 h-3 bg-yellow-500 rounded-full"></div>
                            </div>
                            <div class="pl-3 w-full">
                                <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">
                                    <?php echo sprintf($lang['open-support-case-headline'], $openTicketCount); ?>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <?php echo $lang['open-support-case-subheading']; ?>
                                </div>
                            </div>
                        </a>
                    <?php else: ?>
                        <div class="flex px-4 py-3">
                            <div class="flex-shrink-0 relative">
                                <div class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-100 dark:bg-dark-500">
                                    <span class="material-symbols-outlined">chat_bubble</span>
                                </div>
                                <div class="absolute top-0 right-0 w-3 h-3 bg-green-500 rounded-full"></div>
                            </div>
                            <div class="pl-3 w-full">
                                <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">
                                    <?php echo $lang['no-open-support-case-headline']; ?>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <?php echo $lang['no-open-support-case-subheading']; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- User Dropdown -->
            <div class="hidden z-50 my-4 text-base list-none bg-white divide-y divide-gray-100 rounded-xl shadow dark:bg-dark-700 dark:divide-gray-600 w-64" id="user-dropdown">
                <div class="px-4 py-3 bg-gray-50 dark:bg-dark-600 rounded-t-xl">
                    <div class="flex items-center">
                        <div class="relative inline-flex items-center justify-center w-10 h-10 mr-3 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-800">
                            <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo $this_userAvatar; ?></span>
                        </div>
                        <div>
                            <div class="font-medium text-gray-900 dark:text-white truncate"><?php echo $this_name; ?></div>
                            <div class="text-sm text-gray-500 dark:text-gray-400 truncate">
                                <?php if (!empty($this_username)): ?>
                                    @<?php echo $this_username; ?>
                                    <?php if (!empty($this_verificationBadge)): ?>
                                        <?php echo $this_verificationBadge; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="py-2">
                    <li>
                        <a href="<?php echo url('/account/profile/update'); ?>" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-600 dark:text-gray-200">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <?php echo $lang['manage-your-account']; ?>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo url(''); ?>" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-600 dark:text-gray-200">
                            <span class="material-symbols-outlined mr-2">reply</span>
                            <?php echo $lang['return-to-website']; ?>
                        </a>
                    </li>
                    <li>
                        <form method="POST" class="logout-action">
                            <button type="submit" class="flex w-full items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-600 dark:text-gray-200">
                                <span class="material-symbols-outlined mr-2">logout</span>
                                <?php echo $lang['sign-out']; ?>
                            </button>
                        </form>
                    </li>
                </ul>
            </div>

            <!-- Enterprise Sidebar -->
            <aside id="drawer-navigation" class="fixed top-0 left-0 z-40 w-64 h-screen pt-16 transition-transform -translate-x-full bg-white border-r border-gray-200 dark:bg-dark-800 dark:border-dark-700 md:translate-x-0" aria-label="Navigation">
                <div class="h-full px-3 pb-4 overflow-y-auto bg-white dark:bg-dark-800">
                    <!-- Main Navigation -->
                    <ul class="space-y-2 mt-4">
                        <li>
                            <a href="<?php echo url('/account/overview'); ?>" class="<?php echo (strpos($URL, $accountURL.'/overview') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">dashboard</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['account-overview']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/solutions'); ?>" class="<?php echo (strpos($URL, $accountURL.'/solutions') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">lightbulb</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['solutions']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/cloud'); ?>" class="<?php echo (strpos($URL, $accountURL.'/cloud') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">cloud</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['cloud']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/domains'); ?>" class="<?php echo (strpos($URL, $accountURL.'/domains') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">domain</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['domain']?></span>
                            </a>
                        </li>
                    </ul>

                    <hr class="my-4 border-gray-200 dark:border-dark-700">

                    <!-- Financial Services -->
                    <ul class="space-y-2">
                        <li>
                            <a href="<?php echo url('/account/pay'); ?>" class="<?php echo (strpos($URL, $accountURL.'/pay') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">credit_card</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['datanito-pay-title']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/analytics'); ?>" class="<?php echo (strpos($URL, $accountURL.'/analytics') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">analytics</span>
                                </span>
                                <span class="ml-3"><?php echo $lang['datanito-analytics']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/dino'); ?>" class="<?php echo (strpos($URL, $accountURL.'/dino') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                                        <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z" clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                                <span class="ml-3"><?php echo $lang['dino']?></span>
                                <span class="inline-flex items-center justify-center px-2 ml-3 text-xs font-medium text-blue-800 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-300">
                                    <?php echo $lang['account-dino-ai']?>
                                </span>
                            </a>
                        </li>
                    </ul>

                    <hr class="my-4 border-gray-200 dark:border-dark-700">

                    <!-- Support & Billing -->
                    <ul class="space-y-2">
                        <li>
                            <button type="button" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg" aria-controls="dropdown-billing" data-collapse-toggle="dropdown-billing">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">wallet</span>
                                </span>
                                <span class="flex-1 ml-3 text-left whitespace-nowrap"><?php echo $lang['account-billing']?></span>
                                <svg class="w-4 h-4" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <ul id="dropdown-billing" class="<?php echo (strpos($URL, $accountURL.'/billing') === 0 ? '' : 'hidden'); ?> py-2 space-y-2">
                                <li>
                                    <a href="<?php echo url('/account/billing/invoices'); ?>" class="<?php echo (strpos($URL, $accountURL.'/billing/invoices') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">
                                        <?php echo $lang['account-invoices']?>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <button type="button" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg" aria-controls="dropdown-support" data-collapse-toggle="dropdown-support">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <span class="material-symbols-outlined">support</span>
                                </span>
                                <span class="flex-1 ml-3 text-left whitespace-nowrap"><?php echo $lang['account-support']?></span>
                                <svg class="w-4 h-4" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <ul id="dropdown-support" class="<?php echo (strpos($URL, $accountURL.'/support') === 0 ? '' : 'hidden'); ?> py-2 space-y-2">
                                <li>
                                    <a href="<?php echo url('/account/support/requests'); ?>" class="<?php echo (strpos($URL, '/account/support/requests') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">
                                        <?php echo $lang['account-support-requests']?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo url('/account/support/new'); ?>" class="<?php echo (strpos($URL, '/account/support/new') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">
                                        <?php echo $lang['account-support-new']?>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <button type="button" data-modal-target="datanito-premium-modal" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg">
                                <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 639 636" fill="currentColor">
                                        <g>
                                            <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" d="M543.414062 80.550781 C563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L155.367188 541.199219 C135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L471.371094 80.558594 C491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M543.414062 80.550781"/>
                                            <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" d="M350.257812 83.671875 C370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L158.246094 348.046875 C138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L278.207031 83.671875 C298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M350.257812 83.671875"/>
                                            <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" d="M198.839844 42.324219 C218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L116.90625 196.484375 C97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L126.78125 42.324219 C146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M198.839844 42.324219"/>
                                            <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" d="M549.855469 263.0625 C569.75 282.984375 569.75 315.277344 549.855469 335.199219 L337.238281 548.0625 C317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L477.804688 263.0625 C497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M549.855469 263.0625"/>
                                            <path style="stroke:none;fill-rule:nonzero;fill-opacity:1;" d="M578.785156 423.015625 C598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L496.855469 577.171875 C476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L506.726562 423.015625 C526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M578.785156 423.015625"/>
                                        </g>
                                    </svg>
                                </span>
                                <span class="flex-1 ml-3 text-left whitespace-nowrap">Premium</span>
                                <svg class="w-4 h-4" aria-hidden="true" fill="none" stroke="currentColor" viewBox="0 0 16 16">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 1h4m0 0v4m0-4-5 5.243M5 15H1m0 0v-4m0 4 5.243-5"/>
                                </svg>
                            </button>
                        </li>
                    </ul>

                    <!-- Admin Section -->
                    <?php if ($this_role === 'admin'):
                        $querySupport = "SELECT COUNT(*) AS open_ticket_count FROM support_tickets WHERE (status = 'Open' OR status = 'In Progress')";
                        $stmt = $conn->prepare($querySupport);
                        $stmt->execute();
                        $stmt->bind_result($openTicketCount);
                        $stmt->fetch();
                        $stmt->close();
                        ?>
                        <hr class="my-4 border-gray-200 dark:border-dark-700">

                        <div class="flex items-center justify-between bg-gray-100 dark:bg-dark-700 p-3 rounded-lg mb-2">
                            <div class="flex items-center">
                                <span class="material-symbols-outlined text-blue-600 dark:text-blue-400 mr-2">lock</span>
                                <span class="font-medium text-gray-700 dark:text-gray-300">Admin</span>
                            </div>
                            <button class="toggleAdminButton text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200">
                                <span class="material-symbols-outlined">visibility</span>
                            </button>
                        </div>

                        <ul class="adminArea space-y-2">
                            <li>
                                <a href="<?php echo url('/admin'); ?>" class="<?php echo (strpos($URL, $accountURL.'/admin') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center p-3 rounded-lg group">
                                    <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                        <span class="material-symbols-outlined">dashboard</span>
                                    </span>
                                    <span class="ml-3"><?php echo $lang['account-overview']?></span>
                                </a>
                            </li>
                            <li>
                                <button type="button" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg" aria-controls="dropdown-blog-admin" data-collapse-toggle="dropdown-blog-admin">
                                    <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                        <span class="material-symbols-outlined">local_library</span>
                                    </span>
                                    <span class="flex-1 ml-3 text-left whitespace-nowrap">Blog</span>
                                    <svg class="w-4 h-4" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-blog-admin" class="hidden py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/blog'); ?>" class="<?php echo (strpos($URL, '/admin/blog') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Archive</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/blog/new'); ?>" class="<?php echo (strpos($URL, '/admin/blog/new') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Add New</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/blog/category'); ?>" class="<?php echo (strpos($URL, '/admin/blog/category') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Category</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <button type="button" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg" aria-controls="dropdown-operations-admin" data-collapse-toggle="dropdown-operations-admin">
                                    <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                        <span class="material-symbols-outlined">category</span>
                                    </span>
                                    <span class="flex-1 ml-3 text-left whitespace-nowrap">Operations</span>
                                    <svg class="w-4 h-4" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-operations-admin" class="hidden py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/leads'); ?>" class="<?php echo (strpos($URL, '/admin/leads') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Leads</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/products'); ?>" class="<?php echo (strpos($URL, '/admin/products') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg"><?php echo $lang['account-products']?></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/users'); ?>" class="<?php echo (strpos($URL, '/admin/users') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Users</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/email/send'); ?>" class="<?php echo (strpos($URL, '/admin/email/send') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg">Send email</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <button type="button" class="flex items-center w-full p-3 text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700 rounded-lg" aria-controls="dropdown-support-admin" data-collapse-toggle="dropdown-support-admin">
                                    <span class="flex-shrink-0 w-6 h-6 text-blue-600 dark:text-blue-400">
                                        <span class="material-symbols-outlined">support</span>
                                    </span>
                                    <span class="flex-1 ml-3 text-left whitespace-nowrap"><?php echo $lang['account-support']?></span>
                                    <span class="inline-flex items-center justify-center px-2 ml-3 text-xs font-medium text-blue-800 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-300">
                                        <?php echo $openTicketCount; ?>
                                    </span>
                                    <svg class="w-4 h-4" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-support-admin" class="<?php echo (strpos($URL, $adminURL.'/support') === 0 ? '' : 'hidden'); ?> py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/support/requests'); ?>" class="<?php echo (strpos($URL, '/admin/support/requests') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg"><?php echo $lang['account-support-requests']?></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/support/new'); ?>" class="<?php echo (strpos($URL, '/admin/support/new') === 0 ? 'bg-blue-50 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400' : 'text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-dark-700'); ?> flex items-center w-full p-3 pl-11 rounded-lg"><?php echo $lang['account-support-new']?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    <?php endif; ?>
                </div>

                <!-- Theme Toggle -->
                <div class="absolute bottom-0 left-0 right-0 p-4 bg-white dark:bg-dark-800 border-t border-gray-200 dark:border-dark-700">
                    <button id="theme-toggle" type="button" class="w-full flex items-center justify-center px-4 py-2 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700 rounded-lg">
                        <svg id="theme-toggle-dark-icon" class="hidden w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path>
                        </svg>
                        <svg id="theme-toggle-light-icon" class="hidden w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z" fill-rule="evenodd" clip-rule="evenodd"></path>
                        </svg>
                        <span class="ml-2" id="theme-toggle-text">Toggle theme</span>
                    </button>
                </div>
            </aside>

            <!-- Sidebar Toggle (Desktop) -->
            <div class="fixed left-0 top-1/2 z-40 toggle-sidebar hidden md:flex">
                <button class="sidebar-action-btn bg-white dark:bg-dark-800 border border-gray-200 dark:border-dark-700 rounded-r-lg p-2 shadow-md" type="button" data-tooltip-target="tooltip-close-sidebar" data-tooltip-placement="right">
                    <span class="flex h-6 w-6 items-center justify-center">
                        <div class="flex flex-col items-center">
                            <div class="h-3 w-1 rounded-full bg-gray-400 dark:bg-gray-500 first-sidebar-line transform transition-transform"></div>
                            <div class="h-3 w-1 rounded-full bg-gray-400 dark:bg-gray-500 second-sidebar-line transform transition-transform mt-1"></div>
                        </div>
                    </span>
                    <span class="sr-only">Toggle sidebar</span>
                </button>
            </div>
            <div id="tooltip-close-sidebar" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-2 text-sm font-medium text-white bg-gray-900 rounded-lg shadow-sm opacity-0 tooltip dark:bg-dark-600">
                <span class="close-sidebar-text">Close sidebar</span>
                <span class="open-sidebar-text hidden">Open sidebar</span>
                <div class="tooltip-arrow" data-popper-arrow></div>
            </div>
        </div>
    </div>
</div>

<!-- Settings Modal -->
<div id="settings-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-full max-h-full bg-gray-900/50 dark:bg-gray-900/80">
    <div class="relative w-full max-w-md max-h-full mx-auto my-12">
        <div class="relative bg-white rounded-lg shadow dark:bg-dark-700">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="settings-modal">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="px-6 py-4 border-b rounded-t dark:border-dark-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    <?php echo $lang['setting-modal-title'] ?>
                </h3>
            </div>
            <div class="p-6">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-4"><?php echo $lang['select-country-and-currency'] ?></p>
                <form method="POST" class="settings-form space-y-4">
                    <div>
                        <label for="country" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['country-or-region'] ?></label>
                        <select id="country" name="country" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="us" <?php if ($_SESSION["country"] === 'us') echo 'selected'; ?>>United States - English</option>
                            <option value="tr" <?php if ($_SESSION["country"] === 'tr') echo 'selected'; ?>>Türkiye - Türkçe</option>
                        </select>
                    </div>
                    <div>
                        <label for="currency" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['choose-currency'] ?></label>
                        <select id="currency" name="currency" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="usd" <?php if ($_SESSION["currency"] === 'usd') echo 'selected'; ?>>USD $</option>
                            <option value="eur" <?php if ($_SESSION["currency"] === 'eur') echo 'selected'; ?>>EUR €</option>
                            <option value="try" <?php if ($_SESSION["currency"] === 'try') echo 'selected'; ?>>TRY ₺</option>
                            <option value="gbp" <?php if ($_SESSION["currency"] === 'gbp') echo 'selected'; ?>>GBP £</option>
                        </select>
                    </div>
                    <div class="flex justify-end">
                        <button type="button" class="save-settings text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            <?php echo $lang['setting-modal-save'] ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Premium Modal -->
<div id="datanito-premium-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-full max-h-full bg-gray-900/50 dark:bg-gray-900/80">
    <div class="relative w-full max-w-md max-h-full mx-auto my-12">
        <div class="relative bg-white rounded-lg shadow dark:bg-dark-700">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="datanito-premium-modal">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="px-6 py-4">
                <h3 class="text-xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-500">
                    <?php echo $lang['datanito-premium-headline']; ?>
                </h3>
            </div>
            <div class="p-4 space-y-4">
                <div id="premiumPlans" class="space-y-2">
                    <!-- Premium plans will be inserted here -->
                </div>
                <div class="premium-features-container space-y-4 max-h-96 overflow-y-auto p-2">
                    <?php foreach ($premiumFeatures as $feature): ?>
                        <div class="flex items-start space-x-4">
                            <span class="flex-shrink-0 <?php echo $feature['iconBgColor']; ?> <?php echo $feature['iconColor']; ?> rounded-lg p-2">
                                <span class="material-symbols-outlined"><?php echo $feature['iconSymbol']; ?></span>
                            </span>
                            <div>
                                <h4 class="text-sm font-semibold text-gray-900 dark:text-white"><?php echo $feature['title']; ?></h4>
                                <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo $feature['description']; ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div id="premium-cta" class="pt-4 border-t border-gray-200 dark:border-dark-600">
                    <!-- CTA button will be inserted here -->
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include_once includes('scripts.php');
?>

<script>
    $(document).ready(function() {
        // Load premium products
        function loadProducts() {
            $.ajax({
                type: "POST",
                url: "/get_products",
                dataType: "json",
                data: { category: "premium" },
                success: function(data) {
                    const productCardsContainer = $("#premiumPlans");
                    productCardsContainer.empty();

                    $.each(data, function(index, product) {
                        $("#premium-cta").html(`
                            <button type="button" id="premium-cta" data-product-id="${product.product_id}"
                                class="w-full text-white bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:focus:ring-blue-800">
                                <?php echo str_replace('%d', '\' + product.price + \'', $lang['datanito-premium-cta']); ?>
                            </button>
                        `);

                        const productCard = $(`
                            <div class="flex items-center p-3 border border-gray-200 rounded-lg dark:border-dark-600">
                                <input id="premium-${product.product_id}" name="premium-plan" type="radio" value="${product.product_id}"
                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-dark-700 focus:ring-2 dark:bg-dark-600 dark:border-gray-500" ${index === 0 ? 'checked' : ''}>
                                <label for="premium-${product.product_id}" class="ml-2 w-full">
                                    <div class="flex justify-between items-center">
                                        <span class="text-sm font-medium text-gray-900 dark:text-gray-300">${product.name}</span>
                                        <span class="text-sm font-medium text-gray-900 dark:text-gray-300">${product.price}<span class="text-xs">/<?php echo $lang['mo']?></span></span>
                                    </div>
                                </label>
                            </div>
                        `);
                        productCardsContainer.append(productCard);
                    });
                },
                error: function(error) {
                    console.error("Error fetching product data:", error);
                }
            });
        }

        // Sidebar toggle functionality
        function setupSidebar() {
            const sidebarWidth = 288; // Width of the sidebar
            const sidebar = $('#drawer-navigation');
            const toggleBtn = $('.toggle-sidebar');
            const mainContent = $('main');
            const tooltip = $('#tooltip-close-sidebar');

            // Check localStorage for sidebar state
            let sidebarOpen = localStorage.getItem('sidebarOpen') !== 'false';

            // Initialize sidebar state
            function initSidebar() {
                if (!sidebarOpen) {
                    sidebar.css('transform', `translateX(-${sidebarWidth}px)`);
                    toggleBtn.css('transform', 'translateX(0)');
                    mainContent.css('margin-left', '0');
                    $('.close-sidebar-text').addClass('hidden');
                    $('.open-sidebar-text').removeClass('hidden');
                } else {
                    sidebar.css('transform', 'translateX(0)');
                    toggleBtn.css('transform', `translateX(${sidebarWidth}px)`);
                    mainContent.css('margin-left', `${sidebarWidth}px`);
                    $('.close-sidebar-text').removeClass('hidden');
                    $('.open-sidebar-text').addClass('hidden');
                }
            }

            // Toggle sidebar
            function toggleSidebar() {
                sidebarOpen = !sidebarOpen;
                localStorage.setItem('sidebarOpen', sidebarOpen);
                initSidebar();

                // Animate sidebar lines
                if (sidebarOpen) {
                    $('.first-sidebar-line').css('transform', 'rotate(45deg) translate(4px, 4px)');
                    $('.second-sidebar-line').css('transform', 'rotate(-45deg) translate(4px, -4px)');
                } else {
                    $('.first-sidebar-line').css('transform', 'rotate(0) translate(0, 0)');
                    $('.second-sidebar-line').css('transform', 'rotate(0) translate(0, 0)');
                }
            }

            // Initialize
            initSidebar();

            // Bind click event
            $('.sidebar-action-btn').on('click', toggleSidebar);

            // Responsive behavior
            function handleResize() {
                if (window.matchMedia('(max-width: 768px)').matches) {
                    sidebarOpen = false;
                    initSidebar();
                } else {
                    sidebarOpen = localStorage.getItem('sidebarOpen') !== 'false';
                    initSidebar();
                }
            }

            // Listen for resize events
            $(window).on('resize', handleResize);
            handleResize(); // Initial check
        }

        // Admin section toggle
        $('.toggleAdminButton').click(function() {
            $('.adminArea').toggleClass('hidden');
        });

        // Initialize components
        loadProducts();
        setupSidebar();

        // Theme toggle
        const themeToggleBtn = document.getElementById('theme-toggle');
        const themeToggleDarkIcon = document.getElementById('theme-toggle-dark-icon');
        const themeToggleLightIcon = document.getElementById('theme-toggle-light-icon');
        const themeToggleText = document.getElementById('theme-toggle-text');

        if (themeToggleBtn) {
            themeToggleBtn.addEventListener('click', function() {
                // Toggle icons
                themeToggleDarkIcon.classList.toggle('hidden');
                themeToggleLightIcon.classList.toggle('hidden');

                // Update text
                if (themeToggleDarkIcon.classList.contains('hidden')) {
                    themeToggleText.textContent = 'Dark mode';
                } else {
                    themeToggleText.textContent = 'Light mode';
                }
            });
        }
    });
</script>