<footer class="bg-gray-50 dark:bg-dark-900">
    <hr class="border-gray-200 sm:mx-auto dark:border-dark-700" />
    <section class="bg-gray-50 dark:bg-dark-900">
        <div class="py-8 lg:py-10">
            <div class="flex justify-center">
                <a href="<?php echo url('/dino'); ?>" class="inline-flex justify-between items-center py-1 px-1 pr-4 mb-7 text-sm text-blue-700 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-300 hover:bg-blue-200 dark:hover:bg-blue-800">
                    <span class="text-xs bg-blue-600 rounded-full text-white px-4 py-1.5 mr-3"><?php echo $lang['new'] ?></span> <span class="text-sm font-medium"><?php echo $lang['new-cta'] ?></span>
                    <svg class="w-2.5 h-2.5 ml-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>
                    </svg>
                </a>
            </div>
            <h6 class="mb-1 lg:mb-3 text-3xl font-bold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-4xl"><?php echo $lang['before-footer-headline'] ?></h6>
            <p class="mb-1 lg:mb-3 text-xl font-normal tracking-tight leading-tight text-center text-dark-800 dark:text-gray-300"><?php echo $lang['before-footer-subheading'] ?></p>
            <div class="flex justify-center mb-8 lg:mb-16 space-x-3 sm:space-x-6 mx-4">
                <a href="<?php echo url('/solutions/web-design'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                    <span class="hover:underline"><?php echo $lang['before-footer-cta-1']; ?></span>
                    <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                </a>
                <a href="<?php echo url('/solutions/seo'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                    <span class="hover:underline"><?php echo $lang['before-footer-cta-2']; ?></span>
                    <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                </a>
            </div>
            <div class="grid grid-cols-2 gap-8 text-gray-500 sm:gap-12 md:grid-cols-3 lg:grid-cols-6 dark:text-gray-400">
                <article class="wrapper">
                    <div class="marquee">
                        <div class="marquee__group">
                <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#hulu"/>
                    </svg>
                </span>
                <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#notion"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#honda"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#burger-king"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#spotify"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#jordan"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#mcdonalds"/>
                    </svg>
                </span>
                        </div>

                        <div aria-hidden="true" class="marquee__group">
                <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#hulu"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#notion"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#honda"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#burger-king"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#spotify"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#jordan"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#mcdonalds"/>
                    </svg>
                </span>
                        </div>
                    </div>

                    <div class="marquee marquee--reverse">
                        <div class="marquee__group">
                                <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#hulu"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#notion"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#honda"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#burger-king"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#spotify"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#jordan"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#mcdonalds"/>
                    </svg>
                </span>
                        </div>

                        <div aria-hidden="true" class="marquee__group">
                <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#hulu"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#notion"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#honda"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#burger-king"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#spotify"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#jordan"/>
                    </svg>
                </span>
                            <span class="skeleton rounded-3xl">
                    <svg class="fill-gray-500 dark:fill-gray-300 bg-white dark:bg-dark-700 rounded-3xl">
                        <use xlink:href="#mcdonalds"/>
                    </svg>
                </span>
                        </div>
                    </div>
                </article>

                <svg style="display: none" xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <symbol id="mcdonalds" viewBox="0 0 24 24">
                            <path d="M17.243 3.006c2.066 0 3.742 8.714 3.742 19.478H24c0-11.588-3.042-20.968-6.766-20.968-2.127 0-4.007 2.81-5.248 7.227-1.241-4.416-3.121-7.227-5.231-7.227C3.031 1.516 0 10.888 0 22.476h3.014c0-10.763 1.658-19.47 3.724-19.47 2.066 0 3.741 8.05 3.741 17.98h2.997c0-9.93 1.684-17.98 3.75-17.98Z"/>
                        </symbol>

                        <symbol id="jordan" viewBox="0 0 24 24">
                            <path d="M13.55 2.194v-.075c0-.35.113-.663.338-.938.225-.275.512-.412.862-.412s.663.112.938.337.425.525.45.9c.025.375-.088.688-.338.938s-.55.375-.9.375l-.225.075.075.112-.075.413-.15 1.2c.05.05.075.1.075.15l-.15.75c-.05.1-.1.175-.15.225l-.075.3a22.59 22.59 0 01-.45 1.575v.15c-.05.25-.087.45-.112.6-.025.15-.113.4-.263.75-.1.2-.1.525 0 .975l.075.075c0 .15.063.325.188.525s.187.375.187.525c.05 1-.025 1.85-.225 2.55l.15.45c.6.3.775.625.525.975l.375.15c.6.3 1.025.562 1.275.787.25.225.5.463.75.713.2.05.35.125.45.225l.225.075c1.05.7 2.1 1.55 3.15 2.55l.3.225v.075l-.075.15.225.15h.075c.15.1.25.15.3.15h.075c.05 0 .1-.025.15-.075l.15-.075c.1-.1.2-.175.3-.225h.3c.05 0 .05.025 0 .075l-.3.15-.375.45h.525l.525.075c.15-.05.275-.1.375-.15l.375-.225c.15-.05.3 0 .45.15h.075c.05.05.025.125-.075.225l-.9.825c-.25.2-.475.325-.675.375l-.975.675c-.05.05-.1.05-.15 0l-.225-.3-.15-.3-.188-.263-.225-.3-.187-.225-.15-.187-.3-.225c-.1 0-.2-.025-.3-.075l-.975-.75c-.15 0-.325-.075-.525-.225-.75-.65-1.25-1.05-1.5-1.2l-.45-.3-.9-.15c-.3-.05-.7-.2-1.2-.45l-.6-.3c-.4-.2-.675-.3-.825-.3l-.3-.15c-.2-.05-.35-.1-.45-.15l-.15-.15c-.1 0-.2.025-.3.075l-1.5.75-1.875.825c-.5.4-.975.725-1.425.975l-.825.375-1.275.9c-.1.1-.2.1-.3 0l-.15.15c-.15.05-.25.075-.3.075l-.3.15v.15H3.2l-.15.225c-.1.2-.2.312-.3.337-.1.025-.162.063-.187.113a.434.434 0 01-.075.112l-.15.15-.225.15-.338-.037-.45.075-.3.075c-.25.05-.45.012-.6-.113-.15-.125-.275-.312-.375-.562-.1-.15-.05-.275.15-.375l.075-.075c.05-.05.125-.075.225-.075h.45l.6-.225.3-.075c0-.1.025-.175.075-.225.05-.05.125-.075.225-.075v-.075a.666.666 0 01-.075-.3c-.05-.1-.063-.175-.037-.225.025-.05.05-.075.075-.075h.037l.075.225c.05.25.125.325.225.225l.075-.15c.05-.1.125-.15.225-.15l.15.15.15-.15-.075-.075c0-.05.025-.075.075-.075l.3-.3c.25-.3.55-.575.9-.825.7-.55 1.45-.975 2.25-1.275.25-.25.525-.375.825-.375.2-.35.5-.725.9-1.125.35-.25.6-.425.75-.525.1-.2.225-.3.375-.3h.075l.15-.15c.1-.05.175-.1.225-.15v-.375c0-.25.025-.45.075-.6.05-.15.175-.225.375-.225l.3-.3c-.1-.2-.15-.425-.15-.675h-.075c-.1-.15-.15-.3-.15-.45-.15-.25-.25-.45-.3-.6H9.65c-.05.15-.175.25-.375.3l-.075.15c-.2.35-.375.612-.525.787-.15.175-.425.388-.825.638-.25.25-.425.525-.525.825-.05.15-.05.3 0 .45l-.075.15h.075c0 .1.025.15.075.15h.075c.1.05.15.112.15.187s-.075.1-.225.075a.606.606 0 01-.337-.15c-.075-.075-.138-.112-.188-.112l-.225.225c-.1.15-.2.212-.3.187-.1-.025-.125-.062-.075-.112l.075-.075c.05-.1.05-.15 0-.15l-.6.15c-.05.05-.112.05-.187 0s-.063-.1.037-.15l.375-.15c0-.05-.025-.075-.075-.075-.2.1-.4.125-.6.075l-.375-.075-.075-.075c0-.05.025-.075.075-.075.2.05.45.025.75-.075l.525-.225.6-.675.075-.15c.2-.4.413-.763.638-1.088a3.68 3.68 0 01.712-.787l.075-.3c.1-.2.2-.375.3-.525.1-.15.225-.35.375-.6l.225-.3c.2-.3.425-.45.675-.45l.225-.225c.05-.05.075-.125.075-.225l.15-.15-.075-.075c-.3-.25-.45-.475-.45-.675-.05-.35.063-.65.338-.9s.55-.363.825-.338c.275.025.487.113.637.263l.15.15c.05 0 .075.025.075.075l.3.15v.225c.1.1.15.175.15.225.1-.15.25-.325.45-.525l.375-1.2c0-.2.05-.4.15-.6l.15-.225v-.15l.225-.9h.15l.225-.9a.933.933 0 000-.525l-.3-.75-.15-.6z"/>
                        </symbol>

                        <symbol id="aws" viewBox="0 0 24 24">
                            <path d="M6.763 10.036c0 .296.032.535.088.71.064.176.144.368.256.576.04.063.056.127.056.183 0 .08-.048.16-.152.24l-.503.335a.383.383 0 0 1-.208.072c-.08 0-.16-.04-.239-.112a2.47 2.47 0 0 1-.287-.375 6.18 6.18 0 0 1-.248-.471c-.622.734-1.405 1.101-2.347 1.101-.67 0-1.205-.191-1.596-.574-.391-.384-.59-.894-.59-1.533 0-.678.239-1.23.726-1.644.487-.415 1.133-.623 1.955-.623.272 0 .551.024.846.064.296.04.6.104.918.176v-.583c0-.607-.127-1.03-.375-1.277-.255-.248-.686-.367-1.3-.367-.28 0-.568.031-.863.103-.295.072-.583.16-.862.272a2.287 2.287 0 0 1-.28.104.488.488 0 0 1-.127.023c-.112 0-.168-.08-.168-.247v-.391c0-.128.016-.224.056-.28a.597.597 0 0 1 .224-.167c.279-.144.614-.264 1.005-.36a4.84 4.84 0 0 1 1.246-.151c.95 0 1.644.216 2.091.647.439.43.662 1.085.662 1.963v2.586zm-3.24 1.214c.263 0 .534-.048.822-.144.287-.096.543-.271.758-.51.128-.152.224-.32.272-.512.047-.191.08-.423.08-.694v-.335a6.66 6.66 0 0 0-.735-.136 6.02 6.02 0 0 0-.75-.048c-.535 0-.926.104-1.19.32-.263.215-.39.518-.39.917 0 .375.095.655.295.846.191.2.47.296.838.296zm6.41.862c-.144 0-.24-.024-.304-.08-.064-.048-.12-.16-.168-.311L7.586 5.55a1.398 1.398 0 0 1-.072-.32c0-.128.064-.2.191-.2h.783c.151 0 .255.025.31.08.065.048.113.16.16.312l1.342 5.284 1.245-5.284c.04-.16.088-.264.151-.312a.549.549 0 0 1 .32-.08h.638c.152 0 .256.025.32.08.063.048.12.16.151.312l1.261 5.348 1.381-5.348c.048-.16.104-.264.16-.312a.52.52 0 0 1 .311-.08h.743c.127 0 .2.065.2.2 0 .04-.009.08-.017.128a1.137 1.137 0 0 1-.056.2l-1.923 6.17c-.048.16-.104.263-.168.311a.51.51 0 0 1-.303.08h-.687c-.151 0-.255-.024-.32-.08-.063-.056-.119-.16-.15-.32l-1.238-5.148-1.23 5.14c-.04.16-.087.264-.15.32-.065.056-.177.08-.32.08zm10.256.215c-.415 0-.83-.048-1.229-.143-.399-.096-.71-.2-.918-.32-.128-.071-.215-.151-.247-.223a.563.563 0 0 1-.048-.224v-.407c0-.167.064-.247.183-.247.048 0 .096.008.144.024.048.016.12.048.2.08.271.12.566.215.878.279.319.064.63.096.95.096.502 0 .894-.088 1.165-.264a.86.86 0 0 0 .415-.758.777.777 0 0 0-.215-.559c-.144-.151-.416-.287-.807-.415l-1.157-.36c-.583-.183-1.014-.454-1.277-.813a1.902 1.902 0 0 1-.4-1.158c0-.335.073-.63.216-.886.144-.255.335-.479.575-.654.24-.184.51-.32.83-.415.32-.096.655-.136 1.006-.136.175 0 .359.008.535.032.183.024.35.056.518.088.16.04.312.08.455.127.144.048.256.096.336.144a.69.69 0 0 1 .24.2.43.43 0 0 1 .071.263v.375c0 .168-.064.256-.184.256a.83.83 0 0 1-.303-.096 3.652 3.652 0 0 0-1.532-.311c-.455 0-.815.071-1.062.223-.248.152-.375.383-.375.71 0 .224.08.416.24.567.159.152.454.304.877.44l1.134.358c.574.184.99.44 1.237.767.247.327.367.702.367 1.117 0 .343-.072.655-.207.926-.144.272-.336.511-.583.703-.248.2-.543.343-.886.447-.36.111-.734.167-1.142.167zM21.698 16.207c-2.626 1.94-6.442 2.969-9.722 2.969-4.598 0-8.74-1.7-11.87-4.526-.247-.223-.024-.527.272-.351 3.384 1.963 7.559 3.153 11.877 3.153 2.914 0 6.114-.607 9.06-1.852.439-.2.814.287.383.607zM22.792 14.961c-.336-.43-2.22-.207-3.074-.103-.255.032-.295-.192-.063-.36 1.5-1.053 3.967-.75 4.254-.399.287.36-.08 2.826-1.485 4.007-.215.184-.423.088-.327-.151.32-.79 1.03-2.57.695-2.994z"/>
                        </symbol>

                        <symbol id="spotify" viewBox="0 0 24 24">
                            <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.419 1.56-.299.421-1.02.599-1.559.3z"/>
                        </symbol>

                        <symbol id="burger-king" viewBox="0 0 24 24">
                            <path d="M15.39 12.614c-.72 0-1.11.538-1.11 1.215v1.508c0 .125-.043.182-.12.182-.056 0-.098-.035-.147-.133l-.971-1.885c-.37-.72-.755-.887-1.196-.887-.734 0-1.14.552-1.14 1.243v4.314c0 .678.392 1.215 1.112 1.215.72 0 1.112-.537 1.112-1.215v-1.507c0-.126.042-.182.119-.182.055 0 .097.035.146.133l.972 1.885c.37.719.769.886 1.195.886.735 0 1.14-.551 1.14-1.242v-4.315c0-.677-.391-1.215-1.111-1.215zm-4.02-.405c.364 0 .68-.286.68-.642 0-.238-.099-.412-.224-.572-.203-.266-.385-.496-.476-.74-.02-.056-.007-.105.056-.154.217-.167.469-.537.469-1.124 0-.886-.734-1.389-1.622-1.389h-.79c-.553 0-.819.321-.819.754v3.114c0 .419.245.754.692.754.448 0 .693-.335.693-.754v-.74c0-.09.042-.133.111-.133.084 0 .112.049.126.133.063.356.23.837.42 1.082.237.314.46.411.685.411zm-1.146-2.666h-.098c-.119 0-.175-.07-.175-.161v-.474c0-.09.056-.16.175-.16h.098c.294 0 .385.208.385.39 0 .174-.091.405-.385.405zm-3.761 2.666c1.132 0 1.734-.677 1.734-1.528V8.328c0-.419-.245-.754-.692-.754-.448 0-.693.335-.693.754v2.276c0 .167-.097.363-.35.363-.251 0-.335-.196-.335-.363V8.328c0-.419-.252-.754-.7-.754-.447 0-.691.335-.691.754v2.353c0 .852.594 1.528 1.727 1.528zm12.011-.034c.392 0 .7-.23.7-.65 0-.412-.308-.642-.7-.642h-.63c-.118 0-.174-.07-.174-.16v-.133c0-.091.056-.161.175-.161h.482c.336 0 .602-.202.602-.559 0-.355-.266-.558-.602-.558h-.482c-.12 0-.175-.07-.175-.16V9.04c0-.091.056-.161.175-.161h.629c.392 0 .7-.23.7-.65 0-.411-.308-.642-.7-.642h-1.321c-.553 0-.818.321-.818.754v3.079c0 .432.265.754.818.754h1.321zm2.642 3.127h-.342c-.615 0-1.09.286-1.09.914 0 .573.517.845.901.845.189 0 .322.056.322.202 0 .182-.224.3-.462.3-.79 0-1.328-.537-1.328-1.535 0-1.11.734-1.515 1.3-1.515.692 0 .804.349 1.287.349a.927.927 0 0 0 .936-.915.95.95 0 0 0-.398-.788c-.427-.315-1.07-.545-1.979-.545-1.629 0-3.216 1.026-3.216 3.414 0 2.282 1.587 3.35 3.153 3.35 1.643 0 2.685-1.012 2.685-2.492 0-.935-.587-1.584-1.769-1.584zm-12.43-2.688c-.783 0-1.21.587-1.21 1.32v4.132c0 .734.427 1.32 1.21 1.32.783 0 1.21-.586 1.21-1.32v-4.132c0-.733-.427-1.32-1.21-1.32zm11.494-.405c.447 0 .692-.335.692-.754v-.74c0-.09.042-.132.112-.132.084 0 .111.049.125.133.063.355.231.837.42 1.082.238.314.461.412.685.412.363 0 .678-.286.678-.643 0-.237-.098-.412-.224-.572-.237-.3-.384-.496-.475-.74-.02-.056-.007-.105.056-.153.217-.168.469-.538.469-1.124 0-.887-.735-1.39-1.623-1.39h-.79c-.552 0-.817.321-.817.754v3.114c0 .419.244.753.692.753zm.615-3.301c0-.09.056-.161.175-.161h.098c.293 0 .384.21.384.391 0 .175-.09.405-.384.405h-.098c-.12 0-.175-.07-.175-.16zm-18.87 3.267h.986c.93 0 1.496-.622 1.496-1.397 0-.621-.37-.907-.454-.977-.035-.028-.07-.056-.07-.084 0-.035.021-.048.056-.09.133-.154.266-.398.266-.754 0-.838-.567-1.285-1.448-1.285h-.832c-.552 0-.817.321-.817.754v3.079c0 .433.265.754.817.754zm.413-3.386c0-.09.056-.16.175-.16h.09c.301 0 .392.209.392.39 0 .168-.09.405-.391.405h-.091c-.12 0-.175-.07-.175-.16zm0 1.634c0-.091.056-.161.175-.161h.126c.335 0 .433.223.433.426 0 .181-.098.44-.433.44h-.126c-.12 0-.175-.07-.175-.161zm11.878 1.794c1.098 0 1.79-.699 1.79-1.718 0-.649-.391-1.096-1.174-1.096h-.224c-.413 0-.734.196-.734.636 0 .39.342.58.601.58.133 0 .217.041.217.139 0 .125-.147.21-.315.21-.524 0-.88-.37-.88-1.062 0-.768.489-1.047.866-1.047.462 0 .539.238.86.238.37 0 .623-.308.623-.629a.669.669 0 0 0-.266-.544c-.294-.217-.706-.377-1.321-.377-1.084 0-2.14.712-2.14 2.36 0 1.576 1.056 2.31 2.097 2.31zm-8.718 3.762a.354.354 0 0 1-.07-.188c0-.077.042-.133.126-.21.196-.181.678-.635.944-1.047.202-.314.286-.6.286-.837 0-.607-.552-1.082-1.153-1.082-.385 0-.748.216-.993.614-.329.53-.72 1.145-.972 1.39-.063.062-.098.076-.146.076-.084 0-.12-.056-.12-.146v-.699c0-.684-.405-1.235-1.139-1.235-.74 0-1.14.551-1.14 1.235v4.3c0 .685.399 1.237 1.14 1.237.734 0 1.14-.552 1.14-1.236v-.991c0-.084.035-.147.119-.147.111 0 .14.112.167.168.161.384.63 1.2 1.063 1.682.294.32.657.524 1.042.524.65 0 1.196-.566 1.196-1.173 0-.377-.161-.657-.469-.991-.392-.427-.853-.986-1.021-1.244zm15.751 6.702C19.432 23.707 16.313 24 12 24c-4.313 0-7.432-.293-9.25-1.32-1.09-.614-1.642-1.451-1.642-2.052 0-.342.181-.537.587-.537h20.61c.406 0 .587.195.587.537 0 .6-.552 1.438-1.643 2.053zm1.056-15.917H1.695c-.406 0-.587-.209-.587-.586C1.108 3.944 4.47 0 12 0c7.46 0 10.892 3.944 10.892 6.178 0 .377-.181.586-.587.586Z"/>
                        </symbol>

                        <symbol id="honda" viewBox="0 0 24 24">
                            <path d="M23.902 6.87c-.33-3.218-2.47-3.895-4.354-4.204-.946-.16-2.63-.3-3.716-.34-.946-.06-3.168-.09-3.835-.09-.657 0-2.89.03-3.835.09-1.076.04-2.77.18-3.716.34C2.563 2.985.42 3.66.092 6.87c-.08.877-.1 2.023-.09 3.248.03 2.031.2 3.406.3 4.363.07.657.338 2.62.687 3.636.478 1.395.916 1.803 1.424 2.222.937.757 2.471.996 2.79 1.056 1.733.31 5.24.368 6.784.368 1.544 0 5.05-.05 6.784-.368.329-.06 1.863-.29 2.79-1.056.508-.419.946-.827 1.424-2.222.35-1.016.628-2.979.698-3.636.1-.957.279-2.332.299-4.363.04-1.225.01-2.371-.08-3.248m-1.176 5.4c-.19 2.57-.418 4.104-.747 5.22-.29.976-.637 1.623-1.165 2.092-.867.787-2.063.956-2.76 1.056-1.514.23-4.055.3-6.057.3-2.002 0-4.543-.08-6.057-.3-.697-.1-1.893-.269-2.76-1.056-.518-.469-.876-1.126-1.155-2.093-.329-1.105-.558-2.65-.747-5.22-.11-1.543-.09-4.054.08-5.4.258-2.011 1.255-3.018 3.387-3.396.996-.18 2.34-.31 3.606-.37 1.016-.07 2.7-.1 3.636-.09.936-.01 2.62.03 3.636.09 1.275.06 2.61.19 3.606.37 2.142.378 3.139 1.395 3.388 3.397.199 1.345.229 3.856.11 5.4m-5.202-8.39c-.548 2.462-.767 3.588-1.216 5.37-.428 1.715-.767 3.298-1.335 4.065-.587.777-1.365.947-1.893 1.006-.279.03-.478.04-1.066.05-.596 0-.796-.02-1.075-.05-.528-.06-1.315-.229-1.892-1.006-.578-.767-.907-2.35-1.335-4.064-.47-1.773-.678-2.91-1.236-5.37 0 0-.548.02-.797.04-.329.02-.588.05-.867.09.343 5.372.692 11.079 1.126 16.13a21.983 21.983 0 002.39.169c.33-1.266.748-3.02 1.207-3.767.378-.608.966-.677 1.295-.717.518-.07.956-.08 1.165-.08.2-.01.637 0 1.165.08.33.05.917.11 1.295.717.47.747.877 2.5 1.206 3.766 0 0 .358-.01 1.165-.05.41-.018.82-.058 1.226-.12.458-5.39.785-10.728 1.126-16.128-.28-.04-.538-.07-.867-.09-.23-.02-.787-.04-.787-.04z"/>
                        </symbol>

                        <symbol id="notion" viewBox="0 0 24 24">
                            <path d="M4.459 4.208c.746.606 1.026.56 2.428.466l13.215-.793c.28 0 .047-.28-.046-.326L17.86 1.968c-.42-.326-.981-.7-2.055-.607L3.01 2.295c-.466.046-.56.28-.374.466zm.793 3.08v13.904c0 .747.373 1.027 1.214.98l14.523-.84c.841-.046.935-.56.935-1.167V6.354c0-.606-.233-.933-.748-.887l-15.177.887c-.56.047-.747.327-.747.933zm14.337.745c.093.42 0 .84-.42.888l-.7.14v10.264c-.608.327-1.168.514-1.635.514-.748 0-.935-.234-1.495-.933l-4.577-7.186v6.952L12.21 19s0 .84-1.168.84l-3.222.186c-.093-.186 0-.653.327-.746l.84-.233V9.854L7.822 9.76c-.094-.42.14-1.026.793-1.073l3.456-.233 4.764 7.279v-6.44l-1.215-.139c-.093-.514.28-.887.747-.933zM1.936 1.035l13.31-.98c1.634-.14 2.055-.047 3.082.7l4.249 2.986c.7.513.934.653.934 1.213v16.378c0 1.026-.373 1.634-1.68 1.726l-15.458.934c-.98.047-1.448-.093-1.962-.747l-3.129-4.06c-.56-.747-.793-1.306-.793-1.96V2.667c0-.839.374-1.54 1.447-1.632z"/>
                        </symbol>

                        <symbol id="hulu" viewBox="0 0 24 24">
                            <path d="M14.707 15.957h1.912V8.043h-1.912zm-3.357-2.256a.517.517 0 01-.512.511H9.727a.517.517 0 01-.512-.511v-3.19H7.303v3.345c0 1.368.879 2.09 2.168 2.09h1.868c1.189 0 1.912-.856 1.912-2.09V10.51h-1.912c.01 0 .01 3.09.01 3.19zm10.75-3.19v3.19a.517.517 0 01-.512.511h-1.112a.517.517 0 01-.511-.511v-3.19h-1.912v3.345c0 1.368.878 2.09 2.167 2.09h1.868c1.19 0 1.912-.856 1.912-2.09V10.51zm-18.32 0H2.557c-.434 0-.645.11-.645.11V8.044H0v7.903h1.9v-3.179c0-.278.234-.511.512-.511h1.112c.278 0 .511.233.511.511v3.19h1.912v-3.446c0-1.445-.967-2-2.167-2Z"/>
                        </symbol>
                    </defs>
                </svg>
            </div>
        </div>
    </section>
    <div class="w-full bg-white dark:bg-dark-800 rounded-t-3xl p-4 py-6 lg:py-12">
        <div class="max-w-screen-xl mx-auto">
            <div class="md:flex md:justify-between">
                <div class="mb-6 md:mb-0 md:max-w-[30%]">
                    <a href="<?php echo url(''); ?>" class="flex items-center">
                        <svg class="w-[150px]" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="300px" height="77px" viewBox="0 0 2485 636" version="1.1">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 543.941406 80.550781 C 563.855469 100.46875 563.855469 132.765625 543.941406 152.683594 L 155.519531 541.199219 C 135.601562 561.121094 103.3125 561.121094 83.398438 541.199219 C 63.480469 521.28125 63.480469 488.984375 83.398438 469.066406 L 471.828125 80.558594 C 491.734375 60.628906 524.023438 60.628906 543.941406 80.550781 Z M 543.941406 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 350.597656 83.671875 C 370.515625 103.589844 370.515625 135.886719 350.597656 155.804688 L 158.398438 348.046875 C 138.480469 367.964844 106.195312 367.964844 86.277344 348.046875 C 66.363281 328.125 66.363281 295.828125 86.277344 275.910156 L 278.480469 83.671875 C 298.386719 63.75 330.683594 63.75 350.597656 83.671875 Z M 350.597656 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 199.03125 42.324219 C 218.949219 62.242188 218.949219 94.539062 199.03125 114.457031 L 117.019531 196.484375 C 97.105469 216.40625 64.816406 216.40625 44.902344 196.484375 C 24.984375 176.566406 24.984375 144.269531 44.902344 124.351562 L 126.90625 42.324219 C 146.820312 22.402344 179.117188 22.402344 199.03125 42.324219 Z M 199.03125 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 550.390625 263.0625 C 570.304688 282.984375 570.304688 315.277344 550.390625 335.199219 L 337.566406 548.0625 C 317.652344 567.984375 285.363281 567.984375 265.445312 548.0625 C 245.53125 528.140625 245.53125 495.847656 265.445312 475.925781 L 478.269531 263.0625 C 498.183594 243.140625 530.472656 243.140625 550.390625 263.0625 Z M 550.390625 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 579.347656 423.015625 C 599.265625 442.933594 599.265625 475.230469 579.347656 495.148438 L 497.335938 577.171875 C 477.421875 597.089844 445.132812 597.089844 425.21875 577.171875 C 405.300781 557.25 405.300781 524.953125 425.21875 505.035156 L 507.21875 423.015625 C 527.136719 403.085938 559.433594 403.085938 579.347656 423.015625 Z M 579.347656 423.015625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 783.945312 475.972656 L 783.945312 150.816406 L 897.996094 150.816406 C 992.066406 150.816406 1046.167969 217.605469 1046.167969 313.640625 C 1046.167969 409.679688 992.554688 475.980469 898.484375 475.980469 L 783.945312 475.980469 Z M 965.746094 313.640625 C 965.746094 253.191406 942.351562 219.554688 898.484375 219.554688 L 862.902344 219.554688 L 862.902344 407.242188 L 898.484375 407.242188 C 940.886719 407.242188 965.746094 370.679688 965.746094 313.640625 Z M 965.746094 313.640625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 1206.035156 475.972656 L 1206.035156 452.574219 C 1193.851562 470.609375 1167.53125 481.824219 1143.648438 481.824219 C 1106.605469 481.824219 1070.050781 455.011719 1070.050781 403.824219 C 1070.050781 351.171875 1106.605469 327.773438 1143.648438 327.773438 C 1168.503906 327.773438 1193.851562 337.523438 1206.035156 355.558594 L 1206.035156 330.699219 C 1206.035156 308.761719 1190.925781 294.136719 1164.117188 294.136719 C 1144.621094 294.136719 1124.152344 302.910156 1106.605469 318.511719 L 1081.261719 269.273438 C 1107.09375 244.410156 1146.570312 234.660156 1178.253906 234.660156 C 1231.867188 234.660156 1276.707031 257.574219 1276.707031 320.460938 L 1276.707031 475.972656 Z M 1206.035156 417.472656 L 1206.035156 392.609375 C 1199.210938 379.933594 1185.5625 374.574219 1171.429688 374.574219 C 1153.394531 374.574219 1139.75 385.785156 1139.75 404.796875 C 1139.75 424.296875 1153.394531 435.023438 1171.429688 435.023438 C 1185.5625 435.03125 1199.210938 430.15625 1206.035156 417.472656 Z M 1206.035156 417.472656 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 1335.195312 414.546875 L 1335.195312 301.449219 L 1304.976562 301.449219 L 1304.976562 240.511719 L 1335.195312 240.511719 L 1335.195312 176.160156 L 1405.382812 176.160156 L 1405.382812 240.511719 L 1443.398438 240.511719 L 1443.398438 301.449219 L 1405.382812 301.449219 L 1405.382812 397.484375 C 1405.382812 411.136719 1411.230469 419.421875 1421.464844 419.421875 C 1428.289062 419.421875 1434.625 416.984375 1437.550781 414.058594 L 1450.222656 468.660156 C 1441.449219 475.972656 1424.390625 481.824219 1401.484375 481.824219 C 1356.148438 481.824219 1335.195312 459.40625 1335.195312 414.546875 Z M 1335.195312 414.546875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 1599.847656 475.972656 L 1599.847656 452.574219 C 1587.664062 470.609375 1561.34375 481.824219 1537.460938 481.824219 C 1500.417969 481.824219 1463.863281 455.011719 1463.863281 403.824219 C 1463.863281 351.171875 1500.417969 327.773438 1537.460938 327.773438 C 1562.316406 327.773438 1587.664062 337.523438 1599.847656 355.558594 L 1599.847656 330.699219 C 1599.847656 308.761719 1584.738281 294.136719 1557.929688 294.136719 C 1538.433594 294.136719 1517.964844 302.910156 1500.417969 318.511719 L 1475.074219 269.273438 C 1500.90625 244.410156 1540.386719 234.660156 1572.066406 234.660156 C 1625.679688 234.660156 1670.519531 257.574219 1670.519531 320.460938 L 1670.519531 475.972656 Z M 1599.847656 417.472656 L 1599.847656 392.609375 C 1593.023438 379.933594 1579.378906 374.574219 1565.242188 374.574219 C 1547.207031 374.574219 1533.5625 385.785156 1533.5625 404.796875 C 1533.5625 424.296875 1547.207031 435.023438 1565.242188 435.023438 C 1579.378906 435.03125 1593.023438 430.15625 1599.847656 417.472656 Z M 1599.847656 417.472656 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 1852.800781 475.972656 L 1852.800781 327.773438 C 1852.800781 305.835938 1842.566406 297.058594 1825.019531 297.058594 C 1807.472656 297.058594 1794.800781 309.734375 1787.976562 321.921875 L 1787.976562 475.972656 L 1717.304688 475.972656 L 1717.304688 240.515625 L 1787.976562 240.515625 L 1787.976562 269.765625 C 1799.675781 252.21875 1826.96875 234.667969 1857.675781 234.667969 C 1903.492188 234.667969 1923.476562 261.480469 1923.476562 299.503906 L 1923.476562 475.980469 L 1852.800781 475.980469 Z M 1852.800781 475.972656 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 1964.90625 177.140625 C 1964.90625 154.230469 1982.9375 136.191406 2005.847656 136.191406 C 2028.265625 136.191406 2046.789062 154.230469 2046.789062 177.140625 C 2046.789062 199.566406 2028.265625 218.09375 2005.847656 218.09375 C 1982.9375 218.09375 1964.90625 199.566406 1964.90625 177.140625 Z M 1970.265625 475.972656 L 1970.265625 240.515625 L 2040.9375 240.515625 L 2040.9375 475.980469 L 1970.265625 475.980469 Z M 1970.265625 475.972656 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 2099.425781 414.546875 L 2099.425781 301.449219 L 2069.207031 301.449219 L 2069.207031 240.511719 L 2099.425781 240.511719 L 2099.425781 176.160156 L 2169.613281 176.160156 L 2169.613281 240.511719 L 2207.628906 240.511719 L 2207.628906 301.449219 L 2169.613281 301.449219 L 2169.613281 397.484375 C 2169.613281 411.136719 2175.460938 419.421875 2185.699219 419.421875 C 2192.519531 419.421875 2198.859375 416.984375 2201.78125 414.058594 L 2214.453125 468.660156 C 2205.679688 475.972656 2188.621094 481.824219 2165.714844 481.824219 C 2120.386719 481.824219 2099.425781 459.40625 2099.425781 414.546875 Z M 2099.425781 414.546875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 2228.09375 358.003906 C 2228.09375 292.191406 2267.574219 234.667969 2340.683594 234.667969 C 2414.28125 234.667969 2453.273438 292.191406 2453.273438 358.003906 C 2453.273438 423.816406 2414.28125 481.828125 2340.683594 481.828125 C 2267.574219 481.824219 2228.09375 423.808594 2228.09375 358.003906 Z M 2380.652344 358.003906 C 2380.652344 323.878906 2368.464844 297.066406 2340.683594 297.066406 C 2313.390625 297.066406 2300.71875 323.878906 2300.71875 358.003906 C 2300.71875 392.617188 2313.390625 419.429688 2340.683594 419.429688 C 2368.464844 419.421875 2380.652344 392.617188 2380.652344 358.003906 Z M 2380.652344 358.003906 "/>
                            </g>
                        </svg>
                    </a>
                    <p class="text-gray-700 dark:text-gray-300 font-semibold"><?php echo $lang['about-us-footer'] ?></p>
                </div>
                <div class="grid grid-cols-2 gap-8 sm:gap-6 sm:grid-cols-3">
                    <div>
                        <p class="mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['domain-names'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/domain/register');?>" class="hover:underline"><?php echo $lang['get-a-new-domain'] ?></a>
                            </li>
                            <li class="mb-4">
                                <a href="<?php echo url('/domain/transfer'); ?>" class="hover:underline"><?php echo $lang['transfer-your-domain'] ?></a>
                            </li>
                        </ul>
                        <p class="mt-6 mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['cloud-hosting'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/cloud');?>" class="hover:underline"><?php echo $lang['datanito-cloud'] ?></a>
                            </li>
                            <li class="mb-4">
                                <a href="<?php echo url('/cloud/web-hosting');?>" class="hover:underline"><?php echo $lang['web-hosting'] ?></a>
                            </li>
                            <li>
                                <a href="<?php echo url('/cloud/business-hosting');?>" class="hover:underline"><?php echo $lang['business-hosting'] ?></a>
                            </li>
                        </ul>
                    </div>
                    <div>
                        <p class="mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['websites'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/solutions/web-design');?>" class="hover:underline "><?php echo $lang['web-design-solutions'] ?></a>
                            </li>
                            <li class="mb-4">
                                <a href="<?php echo url('/solutions/seo');?>" class="hover:underline "><?php echo $lang['seo-solutions'] ?></a>
                            </li>
                            <li>
                                <a href="<?php echo url('/solutions/wordpress-premium-support');?>" class="hover:underline"><?php echo $lang['wordpress-premium-support'] ?></a>
                            </li>
                        </ul>
                        <p class="mt-6 mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['digital-marketing'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/solutions/digital-advertising');?>" class="hover:underline"><?php echo $lang['digital-advertising'] ?></a>
                            </li>
                        </ul>
                        <p class="mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['dino'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li>
                                <a href="<?php echo url('/dino'); ?>" class="hover:underline"><?php echo $lang['dino-ai'] ?></a>
                            </li>
                        </ul>
                    </div>
                    <div>
                        <p class="mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['support'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/contact'); ?>" class="hover:underline"><?php echo $lang['contact-us'] ?></a>
                            </li>
                            <li class="mb-4">
                                <a href="<?php echo url('/blog'); ?>" class="hover:underline"><?php echo $lang['blog'] ?></a>
                            </li>
                            <li class="mb-4">
                                <a href="<?php echo url('/about'); ?>" class="hover:underline"><?php echo $lang['about-us'] ?></a>
                            </li>
                            <li>
                                <a href="<?php echo url('/account/support/requests'); ?>" class="hover:underline"><?php echo $lang['support-requests'] ?></a>
                            </li>
                        </ul>
                        <p class="mt-6 mb-3 text-sm font-bold text-gray-900 uppercase dark:text-white"><?php echo $lang['mobile-app'] ?></p>
                        <ul class="text-gray-600 dark:text-gray-300 font-normal text-[1rem]">
                            <li class="mb-4">
                                <a href="<?php echo url('/solutions/mobile-app-development');?>" class="hover:underline"><?php echo $lang['mobile-app-dev-solutions'] ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="sm:flex sm:items-center sm:justify-between text-center mt-12 space-y-4 sm:space-y-0">
                <div class="text-center inline-flex items-center mt-3 sm:mt-0">

                    <div class="flex space-x-6 sm:justify-center sm:mt-0 mr-2.5">
                        <a href="<?php echo $localization['instagram'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 015.45 2.525c.636-.247 1.363-.416 2.427-.465C8.901 2.013 9.256 2 11.685 2h.63zm-.081 1.802h-.468c-2.456 0-2.784.011-3.807.058-.975.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.882-.344 1.857-.047 1.023-.058 1.351-.058 3.807v.468c0 2.456.011 2.784.058 3.807.045.975.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.882.3 1.857.344 1.054.048 1.37.058 4.041.058h.08c2.597 0 2.917-.01 3.96-.058.976-.045 1.505-.207 1.858-.344.466-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.882.344-1.857.048-1.055.058-1.37.058-4.041v-.08c0-2.597-.01-2.917-.058-3.96-.045-.976-.207-1.505-.344-1.858a3.097 3.097 0 00-.748-1.15 3.098 3.098 0 00-1.15-.748c-.353-.137-.882-.3-1.857-.344-1.023-.047-1.351-.058-3.807-.058zM12 6.865a5.135 5.135 0 110 10.27 5.135 5.135 0 010-10.27zm0 1.802a3.333 3.333 0 100 6.666 3.333 3.333 0 000-6.666zm5.338-3.205a1.2 1.2 0 110 2.4 1.2 1.2 0 010-2.4z" clip-rule="evenodd" /></svg>
                            <span class="sr-only">Instagram page</span>
                        </a>
                        <a href="<?php echo $localization['facebook'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd" /></svg>
                            <span class="sr-only">Facebook page</span>
                        </a>
                        <a href="<?php echo $localization['x'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-4 h-4 mt-0.5" fill="currentColor" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                <path stroke="currentColor" d="M12.186 8.672 18.743.947h-2.927l-5.005 5.9-4.44-5.9H0l7.434 9.876-6.986 8.23h2.927l5.434-6.4 4.82 6.4H20L12.186 8.672Zm-2.267 2.671L8.544 9.515 3.2 2.42h2.2l4.312 5.719 1.375 1.828 5.731 7.613h-2.2l-4.699-6.237Z"/>
                            </svg>
                            <span class="sr-only">X page</span>
                        </a>
                        <a href="<?php echo $localization['github'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482A10.019 10.019 0 0022 12.017C22 6.484 17.522 2 12 2z" clip-rule="evenodd" /></svg>
                            <span class="sr-only">GitHub account</span>
                        </a>
                        <a href="<?php echo $localization['linkedin'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="-31 -31 372.00 372.00"></g><g stroke-linecap="round" stroke-linejoin="round" stroke="#CCCCCC" stroke-width="4.340000000000001"></g><g id="SVGRepo_iconCarrier"> <g id="XMLID_801_"> <path id="XMLID_802_" d="M72.16,99.73H9.927c-2.762,0-5,2.239-5,5v199.928c0,2.762,2.238,5,5,5H72.16c2.762,0,5-2.238,5-5V104.73 C77.16,101.969,74.922,99.73,72.16,99.73z"></path> <path id="XMLID_803_" d="M41.066,0.341C18.422,0.341,0,18.743,0,41.362C0,63.991,18.422,82.4,41.066,82.4 c22.626,0,41.033-18.41,41.033-41.038C82.1,18.743,63.692,0.341,41.066,0.341z"></path> <path id="XMLID_804_" d="M230.454,94.761c-24.995,0-43.472,10.745-54.679,22.954V104.73c0-2.761-2.238-5-5-5h-59.599 c-2.762,0-5,2.239-5,5v199.928c0,2.762,2.238,5,5,5h62.097c2.762,0,5-2.238,5-5v-98.918c0-33.333,9.054-46.319,32.29-46.319 c25.306,0,27.317,20.818,27.317,48.034v97.204c0,2.762,2.238,5,5,5H305c2.762,0,5-2.238,5-5V194.995 C310,145.43,300.549,94.761,230.454,94.761z"></path> </g> </g></svg>

                            <span class="sr-only">LinkedIn account</span>
                        </a>
                        <a href="<?php echo $localization['youtube'] ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-gray-700 dark:text-white hover:text-gray-900 dark:hover:text-white">
                            <svg class="w-5 h-5" fill="currentColor" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="80" height="80" viewBox="0 0 72 72"><path d="M61.115,18.856C63.666,21.503,64,25.709,64,36s-0.334,14.497-2.885,17.144C58.563,55.791,55.906,56,36,56	s-22.563-0.209-25.115-2.856C8.334,50.497,8,46.291,8,36s0.334-14.497,2.885-17.144S16.094,16,36,16S58.563,16.209,61.115,18.856z M31.464,44.476l13.603-8.044l-13.603-7.918V44.476z"></path></svg>                        <span class="sr-only">YouTube account</span>
                            <span class="sr-only">YouTube account</span>
                        </a>
                    </div>
                </div>
                    <div class="text-center inline-flex items-center">
                        <span class="text-[15px] font-medium text-gray-700 dark:text-white">
                      <div class="flex items-center sm:align-content-start my-4 sm:my-0 align-content-center justify-center">
                          <a href="<?php echo url('/legal/privacy'); ?>" class="hover:underline"><?php echo $lang['privacy-policy'] ?></a>
                        <div class="vl border-0.5 h-5 border-gray-200 dark:border-gray-700"></div>
                          <a href="<?php echo url('/legal/terms'); ?>" class="hover:underline"><?php echo $lang['terms-of-use'] ?></a>
                          <div class="vl border-0.5 h-5 border-gray-200 dark:border-gray-700"></div>
                            <button id="theme-toggle" type="button" class="mr-2 text-gray-700 dark:text-white text-sm">
                                <span class="sr-only">Switch Theme</span>
                                <svg id="theme-toggle-dark-icon" class="hidden w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                                <svg id="theme-toggle-light-icon" class="hidden w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>
                            </button>
                      </div>
                    </span>
                </div>
            </div>
            <hr class="w-full h-0.5 mx-auto my-4 bg-gray-100 border-0 rounded md:my-6 dark:bg-gray-700">
            <div class="sm:flex sm:items-center sm:justify-between text-center mb-8">
              <span class="text-[15px] font-medium text-gray-700 dark:text-white">
                  <div class="align-content-start mb-2 sm:mb-0 text-left">
                    <?php echo $lang['copyright'] ?>
                  </div>
              </span>


                <span class="text-[15px] font-medium text-gray-700 dark:text-white mt-6 md:mt-0 flex justify-start md:justify-end md:w-[30%]">
              <div class="align-content-end">
                <button type="button" data-modal-target="region-modal" data-modal-toggle="region-modal" class="text-gray-700 dark:text-white hover:bg-gray-100 dark:hover:bg-dark-700 focus:outline-none focus:ring-4 focus:ring-gray-200 dark:focus:ring-dark-700 rounded-full text-center inline-flex items-center px-3 py-2">
                                    <?php
                                    // Get the selected country and currency from the $_SESSION variables
                                    $selectedCountry = $_SESSION["country"];
                                    $selectedCurrency = $_SESSION["currency"];

                                    // Generate the button's text based on the selected values
                                    if ($selectedCountry === 'us') {
                                        echo 'United States';
                                    } elseif ($selectedCountry === 'tr') {
                                        echo 'Türkiye';
                                    }
                                    //                                    echo ' | ';
                                    //                                    if ($selectedCurrency === 'USD') {
                                    //                                        echo 'USD $';
                                    //                                    } elseif ($selectedCurrency === 'EUR') {
                                    //                                        echo 'EUR €';
                                    //                                    } elseif ($selectedCurrency === 'TRY') {
                                    //                                        echo 'TRY TL';
                                    //                                    } elseif ($selectedCurrency === 'GBP') {
                                    //                                        echo 'GBP £';
                                    //                                    }
                                    ?>
                 </button>
              </div>
          </span>
            </div>
        </div>
    </div>
</footer>



<?php
include_once includes('scripts.php');
?>
