<?php
include_once includes('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $cardNumber = $_POST['cardNumber'];
    $expirationMonth = $_POST['expirationMonth'];
    $expirationYear = $_POST['expirationYear'];
    $cvv = $_POST['cvv'];
    $cardHolderName = $_POST['cardHolder'];

    $exp_date = substr($expirationYear, -2) . $expirationMonth;
    $transactionId = date('YmdHis');

    // Process auth request
    $authResult = processAuthRequest($cardNumber, $exp_date, $cvv, $amount, $transactionId);

    if ($authResult['success']) {
        // Get installment options for this card/amount
        $installments = getInstallmentOptions($cardNumber, $amount);

        $response = [
            'success' => true,
            'message' => 'Ön provizyon başarılı',
            'installments' => $installments,
            'authCode' => $authResult['authCode']
        ];
    } else {
        $response = [
            'success' => false,
            'message' => $authResult['message']
        ];
    }

    echo json_encode($response);
}

function processAuthRequest($pan, $expiry, $cvv, $amount, $transactionId) {
    $url = 'https://onlineodeme.vakifbank.com.tr:4443/VposService/v3/Vposreq.aspx';
    $merchantId = "000000005720628";
    $terminalNo = "VP744648";
    $password = "q0D7Taf4";

    $xml = 'prmstr=<?xml version="1.0" encoding="utf-8"?>
        <VposRequest>
            <MerchantId>'.$merchantId.'</MerchantId>
            <Password>'.$password.'</Password>
            <TerminalNo>'.$terminalNo.'</TerminalNo>
            <TransactionType>Auth</TransactionType>
            <TransactionId>'.$transactionId.'</TransactionId>
            <CurrencyAmount>'.$amount.'</CurrencyAmount>
            <CurrencyCode>949</CurrencyCode>
            <Pan>'.$pan.'</Pan>
            <Expiry>'.$expiry.'</Expiry>
            <Cvv>'.$cvv.'</Cvv>
            <ClientIp>'.$_SERVER['REMOTE_ADDR'].'</ClientIp>
            <TransactionDeviceSource>0</TransactionDeviceSource>
        </VposRequest>';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $xmlResponse = simplexml_load_string($response);
    $result = json_decode(json_encode($xmlResponse), true);

    if ($result['ResultCode'] == '0000') {
        return [
            'success' => true,
            'authCode' => $result['AuthCode'],
            'rrn' => $result['Rrn'],
            'message' => $result['ResultDetail']
        ];
    } else {
        return [
            'success' => false,
            'message' => $result['ResultDetail'] ?? 'Ön provizyon alınamadı'
        ];
    }
}

function getInstallmentOptions($pan, $amount) {
    // This would typically call the bank's installment query API
    // For demo purposes, returning mock data
    $brandCode = getCardBrandCode(substr($pan, 0, 2));

    // Mock installment options
    $installments = [];
    $maxInstallments = ($brandCode == '100') ? 12 : 9; // Visa allows more installments

    for ($i = 1; $i <= $maxInstallments; $i++) {
        $interestRate = ($i > 1) ? '1.5' : '0';
        $monthlyAmount = round($amount / $i, 2);

        $installments[] = [
            'installmentNumber' => $i,
            'monthlyAmount' => $monthlyAmount,
            'totalAmount' => $amount,
            'interestRate' => $interestRate
        ];
    }

    return $installments;
}
?>